/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.ljzc.loan.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.StringUtil;
import com.artfess.ljzc.loan.dao.AssetLoanInfoDao;
import com.artfess.ljzc.loan.manager.AssetLoanInfoManager;
import com.artfess.ljzc.loan.manager.AssetLoanInterestManager;
import com.artfess.ljzc.loan.model.AssetLoanInfo;
import com.artfess.ljzc.loan.model.AssetLoanInterest;
import com.artfess.ljzc.loan.vo.MonthVo;
import com.artfess.uc.util.ContextUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.google.api.client.util.Sets;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class AssetLoanInfoManagerImpl
extends BaseManagerImpl<AssetLoanInfoDao, AssetLoanInfo>
implements AssetLoanInfoManager {
    @Autowired
    AssetLoanInterestManager loanInterestManager;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String insertLoanInfo(AssetLoanInfo loanInfo) throws Exception {
        if (BeanUtils.isNotEmpty((Object)((Object)loanInfo))) {
            if (StringUtil.isEmpty((String)loanInfo.getAssetAudit())) {
                loanInfo.setAssetAudit("0");
            }
            if (StringUtil.isEmpty((String)loanInfo.getBelongsOrgId())) {
                loanInfo.setBelongsOrgId(ContextUtil.getCurrentOrgId());
                loanInfo.setBelongsOrgName(ContextUtil.getCurrentOrgName());
                loanInfo.setBelongsOrgFullId(ContextUtil.getCurrentOrgFullId());
            }
            ((AssetLoanInfoDao)this.baseMapper).insert((Object)loanInfo);
            List<AssetLoanInterest> list = loanInfo.getLoanInterest();
            if (!CollectionUtils.isEmpty(list)) {
                list.forEach(s -> s.setLoanId(loanInfo.getId()));
                this.loanInterestManager.saveBatch(list);
            }
            return loanInfo.getId();
        }
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Boolean updateLoanInfo(AssetLoanInfo loanInfo) throws Exception {
        if (BeanUtils.isNotEmpty((Object)((Object)loanInfo))) {
            this.saveOrUpdate((Object)loanInfo);
            List<AssetLoanInterest> list = loanInfo.getLoanInterest();
            QueryWrapper delWrapper = new QueryWrapper();
            delWrapper.eq((Object)"loan_id_", (Object)loanInfo.getId());
            this.loanInterestManager.getBaseMapper().delete((Wrapper)delWrapper);
            if (!CollectionUtils.isEmpty(list)) {
                list.forEach(s -> s.setLoanId(loanInfo.getId()));
                this.loanInterestManager.saveOrUpdateBatch(list);
            }
            return true;
        }
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Boolean deleteLoanInfo(String id) {
        Assert.hasText((String)id, (String)"\u8bf7\u9009\u62e9\u8981\u5220\u9664\u7684\u8d44\u4ea7\uff01");
        boolean flag = this.removeById((Serializable)((Object)id));
        if (flag) {
            QueryWrapper delWrapper = new QueryWrapper();
            delWrapper.eq((Object)"loan_id_", (Object)id);
            this.loanInterestManager.getBaseMapper().delete((Wrapper)delWrapper);
        }
        return flag;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Boolean deleteBachLoanInfo(List<String> ids) {
        Assert.noNullElements(ids, (String)"\u8bf7\u9009\u62e9\u8981\u5220\u9664\u7684\u8d44\u4ea7\uff01");
        boolean flag = this.removeByIds(ids);
        if (flag) {
            QueryWrapper delWrapper = new QueryWrapper();
            delWrapper.in((Object)"loan_id_", ids);
            this.loanInterestManager.getBaseMapper().delete((Wrapper)delWrapper);
        }
        return flag;
    }

    @Override
    public AssetLoanInfo findLoanInfo(String id) {
        Assert.hasText((String)id, (String)"\u8bf7\u9009\u62e9\u8981\u67e5\u8be2\u7684\u8d44\u4ea7\uff01");
        AssetLoanInfo assetLoanInfo = (AssetLoanInfo)((Object)this.getById((Serializable)((Object)id)));
        if (BeanUtils.isNotEmpty((Object)((Object)assetLoanInfo))) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"loan_id_", (Object)id);
            List list = this.loanInterestManager.list((Wrapper)queryWrapper);
            assetLoanInfo.setLoanInterest(list);
            return assetLoanInfo;
        }
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Boolean auditLoan(String status, String msg, List<String> idList) {
        Assert.hasText((String)status, (String)"\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.notNull(idList, (String)"\u8bf7\u9009\u62e9\u8981\u5ba1\u6838\u7684\u8d44\u4ea7");
        Integer result = null;
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.set((Object)"asset_audit_", (Object)status);
        updateWrapper.set((Object)"audit_msg_", (Object)msg);
        updateWrapper.in((Object)"id_", idList);
        result = ((AssetLoanInfoDao)this.baseMapper).update(null, (Wrapper)updateWrapper);
        return null != result && result >= 1;
    }

    @Override
    public List<MonthVo> loanStatistics(String fullId) {
        Integer year = LocalDate.now().getYear();
        List<MonthVo> list = ((AssetLoanInfoDao)this.baseMapper).loanStatistics(fullId, year);
        Set monthList = list.stream().map(MonthVo::getMonth).collect(Collectors.toSet());
        HashSet noMonthList = Sets.newHashSet();
        for (int i = 1; i <= 12; ++i) {
            if (monthList.contains(i)) continue;
            noMonthList.add(i);
        }
        noMonthList.forEach(month -> {
            MonthVo monthVo = new MonthVo();
            monthVo.setMonth((Integer)month);
            monthVo.setAddUpMoney(BigDecimal.ZERO);
            list.add(monthVo);
        });
        list.sort(Comparator.comparing(MonthVo::getMonth));
        return list;
    }
}

