/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.ljzc.business.manager.impl;

import com.alibaba.fastjson.JSONObject;
import com.artfess.base.enums.DelStatusEnum;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.ljzc.business.dao.BizAssetBusinessInfoDao;
import com.artfess.ljzc.business.manager.BizAssetBusinessInfoManager;
import com.artfess.ljzc.business.manager.BizAssetBusinessUseManager;
import com.artfess.ljzc.business.manager.BizAssetBusinessWarrentsManager;
import com.artfess.ljzc.business.model.BizAssetBusinessInfo;
import com.artfess.ljzc.business.model.BizAssetBusinessUse;
import com.artfess.ljzc.business.model.BizAssetBusinessWarrents;
import com.artfess.ljzc.fixed.dao.BizAssetFixedInfoDao;
import com.artfess.ljzc.land.dao.BizAssetLandInfoDao;
import com.artfess.ljzc.loan.dao.AssetLoanInfoDao;
import com.artfess.ljzc.stock.dao.AssetStockInfoDao;
import com.artfess.ljzc.welfare.dao.AssetPubilcInfoDao;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class BizAssetBusinessInfoManagerImpl
extends BaseManagerImpl<BizAssetBusinessInfoDao, BizAssetBusinessInfo>
implements BizAssetBusinessInfoManager {
    @Autowired
    private BizAssetBusinessUseManager businessUseManager;
    @Autowired
    private BizAssetBusinessWarrentsManager businessWarrentsManager;
    @Resource
    private BizAssetLandInfoDao assetLandInfoDao;
    @Resource
    private BizAssetFixedInfoDao fixedInfoDao;
    @Resource
    private AssetPubilcInfoDao pubilcInfoDao;
    @Resource
    private AssetStockInfoDao stockInfoDao;
    @Resource
    private AssetLoanInfoDao loanInfoDao;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Boolean audit(List<String> ids, String status, String assetMsg) {
        Assert.notEmpty(ids, (String)"\u8bf7\u9009\u62e9\u8981\u5ba1\u6838\u7684\u8d44\u4ea7");
        Assert.hasText((String)status, (String)"\u8bf7\u9009\u62e9\u5ba1\u6838\u72b6\u6001");
        List bizAssetBusinessInfos = this.listByIds(ids);
        Assert.notEmpty((Collection)bizAssetBusinessInfos, (String)"\u8d44\u4ea7\u4fe1\u606f\u4e0d\u5b58\u5728");
        bizAssetBusinessInfos.forEach(info -> {
            info.setAssetAudit(status);
            info.setAssetMsg(assetMsg);
        });
        boolean b = this.updateBatchById(bizAssetBusinessInfos);
        return b;
    }

    @Override
    public PageList<BizAssetBusinessInfo> findByPage(QueryFilter<BizAssetBusinessInfo> queryFilter) {
        queryFilter.addFilter("is_dele_", (Object)DelStatusEnum.N.getType(), QueryOP.EQUAL);
        PageBean pageBean = queryFilter.getPageBean();
        Class currentModelClass = this.currentModelClass();
        IPage<BizAssetBusinessInfo> result = ((BizAssetBusinessInfoDao)this.baseMapper).findByPage((IPage<BizAssetBusinessInfo>)this.convert2IPage(pageBean), (Wrapper<BizAssetBusinessInfo>)this.convert2Wrapper(queryFilter, currentModelClass));
        return new PageList(result);
    }

    @Override
    public JSONObject bookValue(String fullId) {
        JSONObject data = new JSONObject();
        BigDecimal businessBookValue = ((BizAssetBusinessInfoDao)this.baseMapper).bookValue(fullId);
        data.put("businessBookValue", (Object)businessBookValue);
        BigDecimal landBookValue = this.assetLandInfoDao.bookValue(fullId);
        data.put("landBookValue", (Object)landBookValue);
        BigDecimal fixedBookValue = this.fixedInfoDao.bookValue(fullId);
        data.put("fixedBookValue", (Object)fixedBookValue.divide(new BigDecimal(10000), 2, 4));
        BigDecimal publicBookValue = this.pubilcInfoDao.bookValue(fullId);
        data.put("publicBookValue", (Object)publicBookValue);
        BigDecimal stockBookValue = this.stockInfoDao.bookValue(fullId);
        data.put("stockBookValue", (Object)stockBookValue);
        BigDecimal loanBookValue = this.loanInfoDao.bookValue(fullId);
        data.put("loanBookValue", (Object)loanBookValue);
        BigDecimal totalBookValue = businessBookValue.add(landBookValue).add(fixedBookValue).add(publicBookValue).add(stockBookValue).add(loanBookValue);
        data.put("totalBookValue", (Object)totalBookValue);
        return data;
    }

    @Override
    public JSONObject businessStatistics(String fullId) {
        List<JSONObject> list = ((BizAssetBusinessInfoDao)this.baseMapper).businessStatistics(fullId);
        BigDecimal totalStructureArea = BigDecimal.ZERO;
        BigDecimal totalUnconfirmArea = BigDecimal.ZERO;
        for (JSONObject jsonObject : list) {
            if (jsonObject.containsKey((Object)"0")) {
                jsonObject.put("name", (Object)"\u7269\u4e1a\u8d44\u4ea7");
            }
            if (jsonObject.containsKey((Object)"1")) {
                jsonObject.put("name", (Object)"\u5546\u54c1\u623f");
            }
            totalStructureArea = totalStructureArea.add(jsonObject.getBigDecimal("structureArea"));
            totalUnconfirmArea = totalUnconfirmArea.add(jsonObject.getBigDecimal("unconfirmArea"));
        }
        JSONObject object = new JSONObject();
        object.put("name", (Object)"\u5efa\u7b51\u9762\u79ef");
        object.put("structureArea", (Object)totalStructureArea);
        object.put("unconfirmArea", (Object)totalUnconfirmArea);
        list.add(object);
        List<JSONObject> assetStatusList = ((BizAssetBusinessInfoDao)this.baseMapper).assetStatusList(fullId);
        JSONObject data = new JSONObject();
        data.put("areaInfo", list);
        data.put("bookValueInfo", assetStatusList);
        return data;
    }

    @Override
    public JSONObject gatherStatistics(String fullId) {
        return ((BizAssetBusinessInfoDao)this.baseMapper).gatherStatistics(fullId);
    }

    @Override
    public List<JSONObject> sourceStatistics(String fullId) {
        return ((BizAssetBusinessInfoDao)this.baseMapper).sourceStatistics(fullId);
    }

    @Override
    public List<JSONObject> statusStatistics(String fullId) {
        return ((BizAssetBusinessInfoDao)this.baseMapper).statusStatistics(fullId);
    }

    @Override
    public List<JSONObject> operationStatistics(String fullId) {
        return ((BizAssetBusinessInfoDao)this.baseMapper).operationStatistics(fullId);
    }

    @Override
    public List<JSONObject> typeStatistics(String fullId) {
        return ((BizAssetBusinessInfoDao)this.baseMapper).typeStatistics(fullId);
    }

    @Override
    public List<JSONObject> belongStatistics(String fullId) {
        return ((BizAssetBusinessInfoDao)this.baseMapper).belongStatistics(fullId);
    }

    @Override
    public List<JSONObject> natureStatistics(String fullId) {
        return ((BizAssetBusinessInfoDao)this.baseMapper).natureStatistics(fullId);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean createInfo(BizAssetBusinessInfo t) {
        boolean save = this.save((Object)t);
        if (save) {
            this.processInfo(t);
        }
        return save;
    }

    private void processInfo(BizAssetBusinessInfo t) {
        BizAssetBusinessWarrents assetBusinessWarrents = t.getAssetBusinessWarrents();
        assetBusinessWarrents.setAssetId(t.getId());
        assetBusinessWarrents.setProjectId(t.getProjectId());
        assetBusinessWarrents.setBuildingId(t.getBuildingId());
        this.businessWarrentsManager.saveOrUpdate((Object)assetBusinessWarrents);
        BizAssetBusinessUse assetBusinessUse = t.getAssetBusinessUse();
        assetBusinessUse.setAssetId(t.getId());
        assetBusinessUse.setProjectId(t.getProjectId());
        assetBusinessUse.setBuildingId(t.getBuildingId());
        this.businessUseManager.saveOrUpdate((Object)assetBusinessUse);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean updateInfo(BizAssetBusinessInfo t) {
        boolean b = this.updateById((Object)t);
        if (b) {
            this.processInfo(t);
        }
        return b;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean removeInfo(List<String> ids) {
        boolean b = this.removeByIds(ids);
        if (b) {
            QueryWrapper warrentsQueryWrapper = new QueryWrapper();
            warrentsQueryWrapper.in((Object)"asset_id_", ids);
            this.businessWarrentsManager.remove((Wrapper)warrentsQueryWrapper);
            QueryWrapper useQueryWrapper = new QueryWrapper();
            useQueryWrapper.in((Object)"asset_id_", ids);
            this.businessUseManager.remove((Wrapper)useQueryWrapper);
        }
        return b;
    }

    @Override
    public BizAssetBusinessInfo findById(String id) {
        Assert.hasText((String)id, (String)"\u8bf7\u9009\u62e9\u8981\u67e5\u770b\u7684\u8d44\u4ea7");
        BizAssetBusinessInfo businessInfo = (BizAssetBusinessInfo)this.get((Serializable)((Object)id));
        QueryWrapper warrentsQueryWrapper = new QueryWrapper();
        warrentsQueryWrapper.eq((Object)"asset_id_", (Object)id);
        BizAssetBusinessWarrents warrents = (BizAssetBusinessWarrents)((Object)this.businessWarrentsManager.getOne((Wrapper)warrentsQueryWrapper));
        businessInfo.setAssetBusinessWarrents(warrents);
        QueryWrapper useQueryWrapper = new QueryWrapper();
        useQueryWrapper.eq((Object)"asset_id_", (Object)id);
        BizAssetBusinessUse bizAssetBusinessUse = (BizAssetBusinessUse)((Object)this.businessUseManager.getOne((Wrapper)useQueryWrapper));
        businessInfo.setAssetBusinessUse(bizAssetBusinessUse);
        return businessInfo;
    }
}

