/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.bpm.engine.task.skip;

import com.artfess.base.util.BeanUtils;
import com.artfess.bpm.api.context.ContextThreadUtil;
import com.artfess.bpm.api.inst.ISkipCondition;
import com.artfess.bpm.api.model.identity.BpmIdentity;
import com.artfess.bpm.api.model.process.task.BpmTask;
import com.artfess.bpm.persistence.manager.BpmCheckOpinionManager;
import com.artfess.bpm.persistence.model.DefaultBpmCheckOpinion;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class ApproverSkipCondition
implements ISkipCondition {
    @Resource
    private BpmCheckOpinionManager bpmCheckOpinionManager;

    @Override
    public boolean canSkip(BpmTask task) {
        String instId = task.getProcInstId();
        List<DefaultBpmCheckOpinion> list = this.bpmCheckOpinionManager.getByInstId(instId);
        for (DefaultBpmCheckOpinion opinion : list) {
            if (opinion.getTaskKey().equals(task.getNodeId()) || !this.isChecked(opinion.getAuditor(), task.getIdentityList())) continue;
            ContextThreadUtil.putCommonVars("Auditor", opinion.getAuditor());
            ContextThreadUtil.putCommonVars("auditorName", opinion.getAuditorName());
            return true;
        }
        return false;
    }

    private boolean isChecked(String auditor, List<BpmIdentity> identitys) {
        if (BeanUtils.isEmpty(identitys)) {
            return false;
        }
        for (BpmIdentity bpmIdentity : identitys) {
            if (!bpmIdentity.getId().equals(auditor)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getTitle() {
        return "\u5ba1\u6279\u8df3\u8fc7";
    }

    @Override
    public String getType() {
        return "approver";
    }
}

