/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.easyExcel.util.paralle;

import com.artfess.easyExcel.util.paralle.ParallelResult;
import java.util.ArrayList;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.LongFunction;

public class ParallelUtil<R> {
    public static final int DEF_PARALLEL_NUM = Runtime.getRuntime().availableProcessors();
    private int parallelNum;
    private long totalNum;
    private Consumer<R> resultConsumer;
    private LongFunction<R> producerFunction;
    private ArrayBlockingQueue<ParallelResult<R>> queue;
    private ThreadPoolExecutor threadPoolExecutor;
    private long timeout = 60L;
    private TimeUnit timeoutTimeUnit = TimeUnit.SECONDS;

    public static <R> ParallelUtil<R> parallel(Class<R> consumerClass, long totalNum) {
        return ParallelUtil.parallel(consumerClass, DEF_PARALLEL_NUM, totalNum);
    }

    public static <R> ParallelUtil<R> parallel(Class<R> consumerClass, int parallelNum, long totalNum) {
        ParallelUtil<R> parallelUtil = new ParallelUtil<R>();
        parallelUtil.parallelNum = (int)Math.max(1L, Math.min((long)parallelNum, totalNum));
        parallelUtil.totalNum = totalNum;
        return parallelUtil;
    }

    public ParallelUtil<R> timeout(long timeout, TimeUnit unit) {
        this.timeout = timeout;
        this.timeoutTimeUnit = unit;
        return this;
    }

    public ParallelUtil<R> asyncProducer(LongFunction<R> producerFunction) {
        this.producerFunction = producerFunction;
        return this;
    }

    public ParallelUtil<R> syncConsumer(Consumer<R> resultConsumer) {
        this.resultConsumer = resultConsumer;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws InterruptedException {
        try {
            ParallelResult<R> parallelResult;
            if (this.totalNum <= 0L) {
                return;
            }
            if (this.totalNum == 1L) {
                this.resultConsumer.accept(this.producerFunction.apply(1L));
                return;
            }
            this.queue = new ArrayBlockingQueue(this.parallelNum);
            this.threadPoolExecutor = new ThreadPoolExecutor(1, this.parallelNum, 10L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new ThreadPoolExecutor.CallerRunsPolicy());
            Thread producerThread = new Thread(() -> {
                try {
                    AtomicLong indexAtomicLong = new AtomicLong(1L);
                    ArrayList<CompletableFuture<Object>> futureList = new ArrayList<CompletableFuture<Object>>(this.parallelNum);
                    for (long index = 1L; index <= this.totalNum; ++index) {
                        long finalIndex = index;
                        futureList.add(CompletableFuture.supplyAsync(() -> this.producerFunction.apply(finalIndex), this.threadPoolExecutor));
                        if (futureList.size() != this.parallelNum) continue;
                        for (CompletableFuture completableFuture : futureList) {
                            this.queue.put(new ParallelResult(indexAtomicLong.getAndIncrement(), completableFuture.join()));
                        }
                        futureList.clear();
                    }
                    for (CompletableFuture completableFuture : futureList) {
                        this.queue.put(new ParallelResult(indexAtomicLong.getAndIncrement(), completableFuture.join()));
                    }
                    futureList.clear();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    this.queue.offer(ParallelResult.empty());
                    throw new RuntimeException(e);
                }
                catch (Exception e) {
                    this.queue.offer(ParallelResult.empty());
                    throw new RuntimeException(e);
                }
            });
            producerThread.setDaemon(true);
            producerThread.start();
            AtomicReference exception = new AtomicReference();
            producerThread.setUncaughtExceptionHandler((t, e) -> exception.set(e));
            AtomicLong count = new AtomicLong();
            while ((parallelResult = this.queue.poll(this.timeout, this.timeoutTimeUnit)) != null && !parallelResult.isEmpty()) {
                this.resultConsumer.accept(parallelResult.getData());
                count.incrementAndGet();
                if (parallelResult.getIndex() != this.totalNum) continue;
            }
            if (count.get() != this.totalNum) {
                throw new RuntimeException(exception.get() == null ? "timeout" : ((Throwable)exception.get()).getMessage());
            }
        }
        finally {
            if (this.threadPoolExecutor != null) {
                this.threadPoolExecutor.shutdown();
            }
        }
    }
}

