/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.easyExcel.converter;

import com.alibaba.excel.converters.Converter;
import com.alibaba.excel.converters.ReadConverterContext;
import com.alibaba.excel.enums.CellDataTypeEnum;
import com.alibaba.excel.metadata.GlobalConfiguration;
import com.alibaba.excel.metadata.data.WriteCellData;
import com.alibaba.excel.metadata.property.ExcelContentProperty;
import com.alibaba.fastjson.JSON;
import com.artfess.base.cache.CacheManager;
import com.artfess.base.cache.ICache;
import com.artfess.base.cache.setting.CacheSetting;
import com.artfess.base.util.AppUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.easyExcel.annotaion.ExcelDictItem;
import com.artfess.easyExcel.annotaion.ExcelDictItemLabel;
import com.artfess.easyExcel.vo.DictionaryDetailVo;
import java.lang.reflect.Field;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

public class ExcelDictConverter
implements Converter<String> {
    private static final CacheSetting cacheSetting = CacheSetting.buildDefault((String)"\u5b57\u5178\u7f13\u5b58");

    public Class supportJavaTypeKey() {
        return null;
    }

    public CellDataTypeEnum supportExcelTypeKey() {
        return null;
    }

    public String convertToJavaData(ReadConverterContext<?> context) throws Exception {
        String key;
        Field field = context.getContentProperty().getField();
        ExcelDictItemLabel excel = field.getAnnotation(ExcelDictItemLabel.class);
        String dictType = excel.type();
        String dictLabel = context.getReadCellData().getStringValue();
        if (StringUtil.isEmpty((String)dictLabel)) {
            return dictLabel;
        }
        CacheManager cacheManager = (CacheManager)AppUtil.getBean(CacheManager.class);
        ICache cache = cacheManager.getCache("", cacheSetting);
        Object o = cache.get((Object)(key = "sys:dictionary::" + dictType.toUpperCase() + ":"));
        if (null == o) {
            return dictLabel;
        }
        List dictionaryDetails = JSON.parseArray((String)o.toString(), DictionaryDetailVo.class);
        AtomicReference value = new AtomicReference();
        dictionaryDetails.forEach(dictionaryDetail -> {
            String name = dictionaryDetail.getName();
            if (dictLabel.equals(name)) {
                value.set(dictionaryDetail.getValue());
                return;
            }
        });
        return (String)value.get();
    }

    public WriteCellData<?> convertToExcelData(String dictLabel, ExcelContentProperty excelContentProperty, GlobalConfiguration globalConfiguration) throws Exception {
        String key;
        Field field = excelContentProperty.getField();
        ExcelDictItem excel = field.getAnnotation(ExcelDictItem.class);
        String dictType = excel.type();
        if (StringUtil.isEmpty((String)dictLabel)) {
            return null;
        }
        CacheManager cacheManager = (CacheManager)AppUtil.getBean(CacheManager.class);
        ICache cache = cacheManager.getCache("", cacheSetting);
        Object o = cache.get((Object)(key = "sys:dictionary::" + dictType.toUpperCase() + ":"));
        if (null == o) {
            return null;
        }
        List dictionaryDetails = JSON.parseArray((String)o.toString(), DictionaryDetailVo.class);
        AtomicReference name = new AtomicReference();
        dictionaryDetails.forEach(dictionaryDetail -> {
            String value = dictionaryDetail.getValue();
            if (dictLabel.equals(value)) {
                name.set(dictionaryDetail.getName());
                return;
            }
        });
        return new WriteCellData((String)name.get());
    }
}

