/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.bpm.engine.form;

import com.artfess.base.groovy.GroovyScriptEngine;
import com.artfess.base.model.CommonResult;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.StringUtil;
import com.artfess.bpm.api.constant.NodeType;
import com.artfess.bpm.api.model.process.def.BpmSubTableRight;
import com.artfess.bpm.api.model.process.nodedef.BpmNodeDef;
import com.artfess.bpm.api.model.process.nodedef.ext.UserTaskNodeDef;
import com.artfess.bpm.api.service.BoSubDataHandlers;
import com.artfess.bpm.api.service.BpmDefinitionAccessor;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="boSubDataHandlersImpl")
public class BoSubDataHandlersImpl
implements BoSubDataHandlers {
    @Resource
    BpmDefinitionAccessor bpmDefinitionAccessor;
    @Resource
    GroovyScriptEngine groovyScriptEngine;

    @Override
    public CommonResult<String> getSubDataSqlByFk(ObjectNode boEnt, Object fkValue, String defId, String nodeId, String parentDefKey) throws Exception {
        BpmSubTableRight bpmSubTableRight = this.getSubTableRight(defId, nodeId, parentDefKey, boEnt);
        String sql = "";
        if (boEnt.get("type").asText().equals("manytomany")) {
            sql = "select A.* from " + boEnt.get("tableName").asText() + " A , form_bo_data_relation B where " + " B.SUB_BO_NAME = '" + boEnt.get("name").asText() + "' AND A." + boEnt.get("pkKey").asText() + "=B.FK_  AND B.PK_=?";
        } else {
            String fk = boEnt.get("fk").asText();
            if (StringUtil.isEmpty((String)fk)) {
                throw new RuntimeException("\u901a\u8fc7\u6dfb\u52a0\u5916\u90e8\u8868\u6784\u5efa\u4e1a\u52a1\u5bf9\u8c61\u65f6\u5fc5\u987b\u6307\u5b9a\u5916\u952e");
            }
            sql = "select * from " + boEnt.get("tableName").asText() + " A  where A." + fk + "=?";
        }
        sql = this.handleRight(bpmSubTableRight, fkValue, sql);
        return new CommonResult(true, "\u83b7\u53d6\u6210\u529f\uff01", (Object)sql);
    }

    private BpmSubTableRight getSubTableRight(String defId, String nodeId, String parentDefKey, ObjectNode boEnt) throws Exception {
        if (StringUtil.isEmpty((String)nodeId) || "undefined".equals(nodeId)) {
            return null;
        }
        BpmNodeDef nodeDef = this.bpmDefinitionAccessor.getBpmNodeDef(defId, nodeId);
        if (BeanUtils.isEmpty((Object)nodeDef) || NodeType.START.equals((Object)nodeDef.getType()) || NodeType.END.equals((Object)nodeDef.getType())) {
            return null;
        }
        UserTaskNodeDef utnd = (UserTaskNodeDef)nodeDef;
        BpmSubTableRight bpmSubTableRight = null;
        List<BpmSubTableRight> list = utnd.getBpmSubTableRightByParentDefKey(parentDefKey);
        for (BpmSubTableRight bsr : list) {
            if (!bsr.getTableName().equals(boEnt.get("name").asText())) continue;
            bpmSubTableRight = bsr;
            break;
        }
        return bpmSubTableRight;
    }

    private String handleRight(BpmSubTableRight right, Object fkValue, String sql) throws Exception {
        if (right == null) {
            return sql;
        }
        if (right.getRightType().equals("script")) {
            String str = this.groovyScriptEngine.executeString(right.getScript(), new HashMap());
            sql = sql + " and " + str;
        } else if (right.getRightType().equals("curUser")) {
            sql = "select a.* from (" + sql + ") a , bpm_bus_link b where a.ID_ = B.businesskey_str_ and  B.start_id_=" + ContextUtil.getCurrentUserId();
        } else if (right.getRightType().equals("curOrg")) {
            sql = "select a.* from (" + sql + ") a , bpm_bus_link b where a.ID_ = B.businesskey_str_ and  B.start_group_id_=" + ContextUtil.getCurrentGroupId();
        }
        return sql;
    }
}

