import * as echarts from 'echarts'
import { Radar } from '@antv/g2plot'
import cq from '@/assets/js/cq.js'
import main9 from '@/assets/js/main9.js'
import dialogConfig from '@/views/BigScreen/js/DistrictReformDialogConfig.js'
import { mapState } from 'vuex'
import VueSeamlessScroll from 'vue-seamless-scroll'
import dialogComponents from '@/views/BigScreen/js/dialog_components.js'
import EasyDialog from '@/views/BigScreen/components/easy-dialog/index.vue'
import fakeData from '@/views/BigScreen/js/fakeData_district.js'
import apiList from '@/api/bigScreen/districView.js'
import bigScreenMixin from '@/mixins/bigScreenMixin.js'
import utils from '@/utils.js'
import screenHeader from '@/views/BigScreen/components/screenHeader.vue'
import dataMixin from '@/views/BigScreen/js/DistrictReformMethods.js'
import { size } from 'lodash'
import Swiper from 'swiper';
// import "swiper/dist/css/swiper.css";
// import 'swiper/swiper.scss'
// import { swiper, swiperSlide } from "vue-awesome-swiper";
export default {
    name: 'DistrictReformMixin',
    data() {
        return {
            mapKeyArr: [
                // 'synGrade',
                // 'digitGrade',
                // 'countryFirmGrade',
                // 'muGrade',
                // 'firmGrade',
                // 'creditGrade',
                'allGrade',
                // 'nationalProjectGrade', //国企改革
                // 'nationalProjectGrade', //亩均论英雄
                'listedCompaniesGrade', //企业上市
                'creditGrade', //信用重庆
                'nationalProjectGrade', //国家试点
                'nationwideGrade', //全国肯定
                'cityGrade', //全市推广
                'satisfiedGrade', //满意度
                // 'cityProjectGrade',
                // 'workablePassGrade',  //验收通过率（包括市级）
                'nationalPassGrade',   //验收通过率（不包括市级）
                // 'workableAddGrade', //新增试点（包括市级）
                'workableNationalAddGrade', //新增试点（不包括市级）


                // 'mediaGrade',

            ],
            swiper: null,
            swiperOption: {
                loop: true,
                autoplay: {
                    disableOnInteraction: false,
                    delay: 5000,
                },
                direction: 'vertical',
                slidesPerView: 5,
                centeredSlides: true,
                centeredSlidesBounds: true,
                grabCursor: true,
            },
            // slideData: [
            //     { name: '综合排名' },
            //     { name: '国家试点' },
            //     { name: '市级试点' },
            //     { name: '验收率' },
            //     { name: '新增试点' },
            //     { name: '全国肯定' },
            //     { name: '全市推广' },
            //     { name: '央媒报道' },
            //     { name: '满意度' },
            // ],
            timer: null,
            kindIndex: 0,
            mapDataKide: [],// 地图各指标数据
            mapDataAll: [], // 地图各指标综合数据
            eightIndex: [
                {
                    name: '数字重庆',
                    number: 0,
                    unit: '%',
                    comp: 'mapTarget_9',
                    imgurl: 'zd_09.png'
                },
                {
                    name: '国企改革',
                    number: 0,
                    unit: '分',
                    comp: 'mapTarget_10',
                    imgurl: 'zd_10.png'
                },
                {
                    name: '亩均论英雄',
                    number: 0,
                    unit: '分',
                    comp: 'mapTarget_11',
                    imgurl: 'zd_11.png'
                },
                {
                    name: '企业上市',
                    number: 0,
                    unit: '分',
                    comp: 'mapTarget_12',
                    imgurl: 'zd_12.png'
                },
                {
                    name: '信用重庆',
                    number: 0,
                    unit: '分',
                    comp: 'mapTarget_13',
                    imgurl: 'zd_13.png'
                },
                {
                    name: '国家试点',
                    number: 0,
                    unit: '个',
                    comp: 'mapTarget_1',
                    imgurl: 'zd_01.png'
                },
                // {
                //     name: '市级试点',
                //     number: 0,
                //     unit: '个',
                //     comp: 'mapTarget_2',
                //     imgurl: 'zd_02.png'
                // },
                {
                    name: '验收率',
                    number: 0,
                    unit: '%',
                    comp: 'mapTarget_3',
                    imgurl: 'zd_03.png'
                },
                {
                    name: '新增试点',
                    number: 0,
                    unit: '个',
                    comp: 'mapTarget_4',
                    imgurl: 'zd_04.png'
                },
                {
                    name: '全国肯定',
                    number: 0,
                    unit: '次',
                    comp: 'mapTarget_5',
                    imgurl: 'zd_05.png'
                },
                {
                    name: '全市推广',
                    number: 0,
                    unit: '次',
                    comp: 'mapTarget_6',
                    imgurl: 'zd_06.png'
                },
                // {
                //     name: '央媒报道',
                //     number: 0,
                //     unit: '次',
                //     comp: 'mapTarget_7',
                //     imgurl: 'zd_07.png'
                // },
                {
                    name: '满意度',
                    number: 0,
                    unit: '分',
                    comp: 'mapTarget_8',
                    imgurl: 'zd_08.png'
                }
            ],
            loadingColor: 'rgba(6, 46, 106, 0.01)',
            loadObj: {
                scrollListData1: false,
                scrollListData2: false,
                brandList: false,
                pilotReform: false,
                scrollBoradData: false,
                scrollListDataBottom: false,
                loadingMap: false,
            },
            ggbb_ssly: [],
            showWorkPlat: false,
            workPlatMenu: [],
            currentTabComponent: '',
            tableOptions: null,
            dialogOption: {
                dialogTitle: '',
                width: '50%',
            },
            showEasy: false,
            mapDialogShow: false,
            mapDialogTop: 0,
            mapDialogleft: 0,
            // 地图分类颜色值
            typeColor1: '#398C8F', // 优
            typeColor2: '#1970c1', // 良
            typeColor3: '#B0825C', // 一般
            // 主城九区区域编码
            main9Code: [
                '500103000000',
                '500112000000',
                '500108000000',
                '500106000000',
                '500104000000',
                '500107000000',
                '500105000000',
                '500113000000',
                '500109000000',
            ],
            currentMenu: {
                name: '',
            },
            currentKey: 'DistrictReformView',
            menuData: [],
            activeBtn: 1,
            activeBtnKey: 'composite',
            myChartCQ: null,
            myChartMain: null,
            optionCQ: null,
            optionMain: null,
            // 单项指数排行榜
            singleheader: [
                {
                    name: '指数',
                    width: '33.33%',
                },
                {
                    name: '入榜区县',
                    width: '33.33%',
                },
                // {
                //     name: '得分',
                //     width: '25%',
                // },
                // {
                //     name: '全市排位',  //放在区县名字前面展示
                //     width: '16%',
                // },
                {
                    name: '入榜形式', // 显示 蝉联冠军  新进冠军
                    width: '33.33%',
                },
            ],
            // 指数排行榜
            scrollheader1: [
                {
                    name: '区县',
                    width: '28%',
                },
                {
                    name: '得分',
                    width: '18%',
                },
                {
                    name: '区域排位',
                    width: '18%',
                },
                {
                    name: '全市排位',
                    width: '18%',
                },
                {
                    name: '区域变化',
                    width: '18%',
                },
            ],
            scrollListData1: [],
            // 一地创新
            scrollheader2: [
                {
                    name: '区县',
                    width: '20%',
                },
                {
                    name: 'A',
                    width: '12%',
                    type: 'level'
                },
                {
                    name: 'B',
                    width: '12%',
                    type: 'level'
                },
                {
                    name: 'C',
                    width: '12%',
                    type: 'level'
                },
                {
                    name: 'D',
                    width: '12%',
                    type: 'level'
                },
                // {
                //     name: 'E',
                //     width: '12%',
                //     type: 'level'
                // },
                {
                    name: '得分',
                    width: '10%',
                },
                {
                    name: '排名',
                    width: '10%',
                },
                {
                    name: '总档位',
                    width: '15%',
                },
            ],
            scrollListData2: [],
            // 改革品牌
            scrollheader3: [
                {
                    name: '区县',
                    width: '20%',
                },
                {
                    name: '全国肯定',
                    width: '16%',
                    // type: 'l',
                },
                {
                    name: '全市推广',
                    width: '16%',
                    // type: 'l',
                },
                // {
                //     name: '央媒报道',
                //     width: '16%',
                //     // type: 'l',
                // },
                {
                    name: '排名',
                    width: '16%',
                },
                {
                    name: '变化',
                    width: '16%',
                },
            ],
            scrollListData3: [],
            // 地图滚动数据
            scrollBoradData: [
                //     {
                //         id: 1,
                //         name: '江津举办xx现场会',
                //     },
                //     {
                //         id: 2,
                //         name: '江津区陆海新通道打通xx一公里',
                //     },
                //     {
                //         id: 3,
                //         name: '沙坪坝区陆海新通道打通xx一公里',
                //     },
                //     {
                //         id: 4,
                //         name: '北碚区陆海新通道打通xx一公里',
                //     },
                //     {
                //         id: 5,
                //         name: '南岸区陆海新通道打通xx一公里',
                //     },
                //     {
                //         id: 6,
                //         name: '江津区陆海新通道打通xx一公里',
                //     },
                //     {
                //         id: 7,
                //         name: '北碚区陆海新通道打通xx一公里',
                //     },
            ],
            // 指数排行榜
            scrollheaderBottom: [
                {
                    name: '区县',
                    width: '20%',
                },
                {
                    name: '提出需求',
                    width: '18%',
                },
                {
                    name: '转化为清单',
                    width: '24%',
                },
                {
                    name: '质效指数',
                    width: '18%',
                },
                {
                    name: '排名',
                    width: '20%',
                },
            ],
            scrollListDataBottom: [],
            reformBrandData: [
                { time: '1月', value: 4, count: 1 },
                { time: '2月', value: 5, count: 2 },
                { time: '3月', value: 2, count: 4 },
                { time: '4月', value: 1, count: 3 },
                { time: '5月', value: 2, count: 1 },
                { time: '6月', value: 4, count: 4 },
            ],
            reformBrandOption: null,
            reformBrandChart: null,
            reformData: null,
            // 雷达 总书记指示
            rayChart: null,
            rayChartOption: null,
            // 对接时 max设置为值的1.2倍
            rayChartData: [
                {
                    name: '经济和社会民生',
                    value: 60,
                    type: '习近平总书记重要指示批示、重要讲话精神',
                },
                { name: '经济和社会民生', value: 70, type: '群众企业基层所盼' },
                { name: '经济和社会民生', value: 80, type: '其他省市先进经验' },

                {
                    name: '文化',
                    value: 80,
                    type: '习近平总书记重要指示批示、重要讲话精神',
                },
                { name: '文化', value: 70, type: '群众企业基层所盼' },
                { name: '文化', value: 60, type: '其他省市先进经验' },

                {
                    name: '平安法治',
                    value: 40,
                    type: '习近平总书记重要指示批示、重要讲话精神',
                },
                { name: '平安法治', value: 50, type: '群众企业基层所盼' },
                { name: '平安法治', value: 20, type: '其他省市先进经验' },

                {
                    name: '民主法制',
                    value: 70,
                    type: '习近平总书记重要指示批示、重要讲话精神',
                },
                { name: '民主法制', value: 40, type: '群众企业基层所盼' },
                { name: '民主法制', value: 10, type: '其他省市先进经验' },

                {
                    name: '党建统领',
                    value: 60,
                    type: '习近平总书记重要指示批示、重要讲话精神',
                },
                { name: '党建统领', value: 50, type: '群众企业基层所盼' },
                { name: '党建统领', value: 30, type: '其他省市先进经验' },
            ],
            // 雷达 所属领域
            rayChart2: null,
            rayChartOption2: null,
            // 对接时 max设置为值的1.2倍
            rayChartData2: [
                { name: '经济和社会民生', value: 20, type: '国家级' },
                { name: '经济和社会民生', value: 120, type: '市级' },

                { name: '文化', value: 20, type: '国家级' },
                { name: '文化', value: 80, type: '市级' },

                { name: '平安法治', value: 18, type: '国家级' },
                { name: '平安法治', value: 78, type: '市级' },

                { name: '民主法制', value: 5, type: '国家级' },
                { name: '民主法制', value: 115, type: '市级' },

                { name: '党建统领', value: 10, type: '国家级' },
                { name: '党建统领', value: 70, type: '市级' },
            ],
            // 部署时间
            deployTimeChart: null,
            deployTimeOption: null,
            deployTimeData: [],
            // 盼望
            hopeChart: null,
            hopeOption: null,
            hopeData: [],
            // 需求来源
            quarterData: [
                {
                    value: 1,
                    name: '一季度',
                },
                { value: 2, name: '二季度' },
                { value: 3, name: '三季度' },
                { value: 4, name: '四季度' },
            ],
            ggbb_lyqd: [],
            heatBarChart: null,
            heatBarOption: null,
            legendBottom: [],
            legendTop: [],
            heatBarData: [],
            //品牌榜chart数据
            brandChartData1: [],
            brandChartData2: [],
            brandChartData3: [],
            xAxisData: [],
            //改革试点成果
            // 形成制度成果
            achievement1: {
                totalAchievement: 0,
                gapQAchievement: 0,
            },
            // 搭建工作平台
            achievement2: {
                totalAchievement: 0,
                gapQAchievement: 0,
            },
            // 上线应用场景
            achievement3: {
                totalAchievement: 0,
                gapQAchievement: 0,
            },
            // 部署时间
            deploymentTimeData: {},
            deploymentTimeYear: [],
            deploymentTimeData1: [],
            deploymentTimeData2: [],
            // 指数 单项
            indexSingleData: [],
            // 地图数据
            compositeMapData: [],
            workableMapData: [],
            brandMapData: [],
            satisfactionMapData: [],
            riskMapData: [],
            fxcd: [], //事件风险程度
            quarter: null,
            year: null,
            currentQuarter: null,
            ljxqGrade: '',
            gxqGrade: '',
        }
    },
    components: {
        // swiper,
        // swiperSlide
    },
    computed: {
        ...mapState({
            frontMenus: (state) => {
                return state.menu.frontMenus
            },
        }),
        optionSingleHeightTime() {
            return {
                step: 0.1,
            }
        },
    },
    created() {
        this.ggbb_ssly = utils.getDictItemsFromCache('ggbb_ssly')
        this.ggbb_lyqd = utils.getDictItemsFromCache('ggbb_lyqd')
        this.fxcd = utils.getDictItemsFromCache('fxcd')
    },
    mounted() {


        this.nowQuarter()
        let searchDate = sessionStorage.getItem('searchDate')
        if (searchDate) {
            searchDate = JSON.parse(searchDate)
            this.year = searchDate.year
            this.quarter = searchDate.quarter
        } else {
            this.checkQuarter()
        }
        this.$nextTick(() => {
            this.initMapMain()
            this.initMapCQ()
            this.loadData('init')
            // this.$refs.mySwiper.swiper.autoplay.stop()
            // console.log('当前的swiper实例', this.swiper, )
        })
        this.$bus.$on('changeDate', (searchDate) => {
            this.quarter = searchDate.quarter
            this.year = searchDate.year
            if (this.$route.path == '/DistrictReformView') {
                this.loadData()
            }
        })
        // this.initSwiper();
        this.$root.$on('resize', () => {
            this.resize(500)
        })
    },
    beforeDestory() {
        let tooltip = document.querySelectorAll('.data-tooltip')
        Array.from(tooltip).forEach((item) => {
            item.remove()
        })
        clearInterval(this.timer)
    },
    methods: {
        handleIndexDetail(item) {
            console.log(item);
            if (item.number) {
                this.handleDetail(item.comp)
            }
        },
        initSwiper() {
            const _this = this
            this.swiper = new Swiper('.swiper-container', {
                loop: true,
                autoplay: true,
                direction: 'vertical',
                slidesPerView: 5,
                spaceBetween: 10,
                slideToClickedSlide: true,
                centeredSlides: true,
                centeredSlidesBounds: true,
                grabCursor: true,
                allowTouchMove: false,
                on: {
                    click: () => {
                        // let data = JSON.parse(JSON.stringify(_this.swiper))
                        let dom = _this.swiper.clickedSlide
                        let index = dom.getAttribute('data-swiper-slide-index') - 0
                        _this.slideChange(index)
                    },
                },
            })
        },
        slideChange(index) {
            // 此规则根据index和地图对应index数据得来，没有具体规律
            // console.log(index < 13);
            // if (index < 7) {
            //     this.kindIndex = index + 1
            // } else if (index < 13) {
            //     this.kindIndex = index - 6
            // } else {
            //     this.kindIndex = index - 13
            // }
            // console.log(index,'index');
            this.kindIndex = index
            console.log(this.kindIndex);
            // console.log(this.mapKeyArr[this.kindIndex], this.kindIndex, index)
            this.changeMapType()
            // clearInterval(this.timer)
            // this.timer = setInterval(() => {
            //     this.changeMapType()
            // }, 5000)
        },
        handleDetail(comp, type) {
            if (comp == 'reformPilot') {
                this.$router.push({
                    path: '/DetailComponent',
                    name: 'DetailComponent',
                    query: {
                        comp,
                        type: '1',
                        numType: 'nationalProject'
                    }
                })
            } else if (comp == 'reformNewsSingle') {
                this.$router.push({
                    path: '/DetailComponent',
                    name: 'DetailComponent',
                    query: {
                        comp,
                        type
                    }
                })
            } else {
                this.$router.push({
                    path: '/DetailComponent',
                    name: 'DetailComponent',
                    query: {
                        comp,
                        type
                    }
                })
            }

        },
        getFileData(type) {
            if (type == 'satisfaction') {
                let data = this.qs.stringify({
                    year: this.year,
                    quarter: this.quarter,
                })
                apiList.satisfactionFile(data, (res) => {
                    if (res.satisfaction && res.satisfaction.id) {
                        this.openSubDialog('satisfactionReport', {
                            fileId: res.satisfaction.id
                        })
                    } else {
                        this.openSubDialog('satisfactionReport')
                    }
                })
            }
        },
        nowQuarter() {
            let month = new Date().getMonth() + 1
            if (month <= 3) {
                this.currentQuarter = 1
            } else if (month <= 6) {
                this.currentQuarter = 2
            } else if (month <= 9) {
                this.currentQuarter = 3
            } else if (month <= 12) {
                this.currentQuarter = 4
            }
        },
        checkQuarter() {
            this.year = new Date().getFullYear()
            let month = new Date().getMonth() + 1
            if (month <= 3) {
                this.quarter = 1
            } else if (month <= 6) {
                this.quarter = 2
            } else if (month <= 9) {
                this.quarter = 3
            } else if (month <= 12) {
                this.quarter = 4
            }
        },
        goToSub(type) {
            let data = {
                ljxq: {
                    name: '两江新区',
                    code: '500191000000',
                },
                gxq: {
                    name: '高新区',
                    code: '500193000000',
                },
            }
            this.$router.push({
                path: '/DistrictReformSubView',
                query: {
                    name: data[type].name,
                    code: data[type].code,
                },
            })
            let tooltip = document.getElementsByClassName('data-tooltip')
            Array.from(tooltip).forEach((item) => {
                item.remove()
            })
        },
        convertData(data, mapData, key, showTitle) {
            // console.log(key, "key")
            // ['#20A367', '#3877B2', '#E3C428', '#E49317', '#B04332']
            let res = []
            for (let i = 0; i < data.length; i++) {
                let obj = data[i].properties
                let color = '#081c47'
                let find = mapData.find((item) => item.unitCode == obj.code)
                if (find) {
                    if (find[key] == 'A') {
                        color = '#20A367'
                    } else if (find[key] == 'B') {
                        color = '#3877B2'
                    } else if (find[key] == 'C') {
                        color = '#E3C428'
                    } else if (find[key] == 'D') {
                        color = '#E49317'
                    } else if (find[key] == 'E') {
                        color = '#B04332'
                    }
                }
                let show = true
                let offset = [0, 0]
                if (
                    [
                        '渝中区',
                        '大渡口区',
                        '江北区',
                        '沙坪坝区',
                        '九龙坡区',
                        '南岸区',
                        '北碚区',
                        '渝北区',
                        '巴南区',
                        '两江新区',
                        '高新区',
                    ].includes(obj.name)
                ) {
                    show = false
                }
                if (['沙坪坝区'].includes(obj.name)) {
                    offset = [-10, 0]
                }
                if (['九龙坡区'].includes(obj.name)) {
                    offset = [-10, -10]
                }
                if (['大渡口区'].includes(obj.name)) {
                    offset = [0, 5]
                }
                if (['江北区'].includes(obj.name)) {
                    offset = [10, 0]
                }
                if (['南岸区'].includes(obj.name)) {
                    offset = [10, 6]
                }
                if (['綦江区'].includes(obj.name)) {
                    offset = [0, 20]
                }
                if (showTitle != undefined) {
                    show = showTitle
                }
                if (obj.name == '两江新区' || obj.name == '高新区') {
                    show = false
                }
                res.push({
                    name: obj.name,
                    value: find ? find['unitCode'] : 0,
                    itemStyle: {
                        color: color,
                        areaColor: color,
                        label: {
                            show,
                        },
                    },
                    label: {
                        normal: {
                            show,
                            offset, //是否对文字进行偏移。默认不偏移。例如：[30, 40] 表示文字在横向上偏移 30，纵向上偏移 40。
                            position: 'inside', //标签的位置。// 绝对的像素值[10, 10]
                            color: '#fff',
                            fontSize: 12,
                        },
                    },
                    emphasis: {
                        disabled: true,
                    },
                })
            }
            return res
        },
        loadData(type) {
            // type == init  初始化查询
            // this.getGisData()
            this.getMapData()
            this.loadNews() // 新闻动态
            this.getTarget() // 重点关注
            this.getIndex() // 创先争优  √
            // this.getBroad() // 一地创新 全市推广 √
            this.getBrand(type) // 品牌榜 √
            this.getPilotReform(type) // 改革试点√
            // this.getDemandHeatList(type)// 需求热力榜 √
        },
        getMapData() {
            this.loadObj.loadingMap = true
            let data = this.qs.stringify({
                type: 'composite',
                quarter: this.quarter,
                year: this.year,
            })

            apiList.statementDetail(data, (res) => {
                this.loadObj.loadingMap = false
                let data = res || []
                this.mapDataKide = data
                // this.mapDataKide.forEach(item=>{
                //     // item.numberGrade = 'A'
                //     item.countryFirmGrade = 'E'
                //     item.muGrade = 'E'
                //     item.firmGrade = 'E'
                //     item.creditGrade = 'E'
                // })


                this.preMapData()
            })
        },
        getAllScroe(data) {
            let scroe = this.defineLevelScroe(data.nationalProjectGrade) +
                this.defineLevelScroe(data.cityProjectGrade) +
                this.defineLevelScroe(data.workablePassGrade) +
                this.defineLevelScroe(data.workableAddGrade) +
                this.defineLevelScroe(data.nationwideGrade) +
                this.defineLevelScroe(data.cityGrade) +
                this.defineLevelScroe(data.mediaGrade) +
                this.defineLevelScroe(data.satisfiedGrade)
            return scroe
        },
        defineLevelScroe(grade) {
            if (grade == 'A') {
                return 3
            } else if (grade == 'B') {
                return 1
            } else if (grade == 'C') {
                return 0
            } else if (grade == 'D') {
                return -1
            } else if (grade == 'E') {
                return -3
            }
        },
        getTarget() {
            apiList.getTarget({
                quarter: this.quarter,
                year: this.year,
            }).then(res => {
                if (res.state) {
                    // this.eightIndex[0].number = res.value.nationalProjectNum
                    // this.eightIndex[1].number = res.value.cityProjectNum
                    // this.eightIndex[2].number = res.value.passRate
                    // this.eightIndex[3].number = res.value.addNum
                    // this.eightIndex[4].number = res.value.nationwideNum
                    // this.eightIndex[5].number = res.value.cityNum
                    // this.eightIndex[6].number = res.value.mediaNum
                    // this.eightIndex[7].number = res.value.satisfied
                    // this.eightIndex[0].number = this.quarter == 2 ? 100 : 0
                    this.eightIndex[0].number = res.value.digitRate
                    // this.eightIndex[1].number = 100
                    // this.eightIndex[2].number = 100
                    // 企业上市
                    // res.value.listedCompaniesDivide || 100
                    this.eightIndex[3].number = res.value.listedCompaniesDivide || 0
                    this.eightIndex[4].number = res.value.creditRate || 0
                    this.eightIndex[5].number = res.value.nationalProjectNum
                    this.eightIndex[6].number = res.value.nationalPassRate
                    this.eightIndex[7].number = res.value.nationalAddNum
                    this.eightIndex[8].number = res.value.nationwideNum
                    this.eightIndex[9].number = res.value.cityNum
                    this.eightIndex[10].number = res.value.satisfied
                }
            })
        },
        getIndex() {
            this.loadObj.scrollListData2 = true
            let data = this.qs.stringify({
                quarter: this.quarter,
                year: this.year,
            })
            apiList.getIndex(data, (res) => {
                if (res && res.value) {
                    this.scrollListData2 = res.value
                    this.mapDataAll = res.value || []
                    // this.preMapData()
                }
                this.loadObj.scrollListData2 = false
            })
        },
        // getBroad() {
        //     this.loadObj.scrollListData2 = true
        //     let data = this.qs.stringify({
        //         type: 1,
        //         quarter: this.quarter,
        //         year: this.year,
        //     })
        //     apiList.getBroad(data, (res) => {
        //         if (res && res.value) {
        //             this.scrollListData2 = res.value
        //         }
        //         this.loadObj.scrollListData2 = false
        //     })
        // },
        getBrand(type) {
            this.loadObj.brandList = true
            this.brandChartData1.length = 12
            this.brandChartData2.length = 12
            this.brandChartData3.length = 12
            let data = this.qs.stringify({
                quarter: this.quarter,
                year: this.year,
            })
            apiList.getBrand(data, (res) => {
                if (res && res.value && res.value.brand) {
                    this.scrollListData3 = res.value.brand
                }
                if (res && res.value && res.value.chart) {
                    let chartData = res.value.chart
                    // 查询当年1-12月--------
                    chartData[1].forEach((item, i) => {
                        this.brandChartData1[i] = item.effectCount
                    })
                    chartData[2].forEach((item, i) => {
                        this.brandChartData2[i] = item.effectCount
                    })
                    chartData[3].forEach((item, i) => {
                        this.brandChartData3[i] = item.effectCount
                    })
                    this.xAxisData = []
                    for (let i = 1; i <= 12; i++) {
                        this.xAxisData.push(i + '月')
                    }

                    // 根据当前月往前查询--------
                    // let { XData, arr1, arr2, arr3 } = this.formatBrandChartData(chartData)
                    // this.xAxisData = XData
                    // this.brandChartData1 = arr1
                    // this.brandChartData2 = arr2
                    // this.brandChartData3 = arr3
                }

                if (type) {
                    this.initReformBrand()
                } else {
                    this.reformBrandOption.series[0].data = this.brandChartData1 || []
                    this.reformBrandOption.series[1].data = this.brandChartData2 || []
                    // this.reformBrandOption.series[2].data = this.brandChartData3 || []
                    this.reformBrandOption.xAxis.data = this.xAxisData
                    this.reformBrandChart.setOption(this.reformBrandOption)
                }
                this.loadObj.brandList = false
            })
        },
        formatBrandChartData(chartData) {
            //向前查询
            let XData = []
            let __thisYear = this.year + '/'
            let __lsetYear = this.year - 1 + '/'
            if (this.quarter < 4) {
                for (let m = this.quarter * 3 + 1; m <= 12; m++) {
                    XData.push(__lsetYear + m)
                }
                for (let m = 1; m <= this.quarter * 3; m++) {
                    XData.push(__thisYear + m)
                }
            } else {
                for (let m = 1; m <= 12; m++) {
                    XData.push(__thisYear + m)
                }
            }
            let arr1 = [],
                arr2 = [],
                arr3 = []
            if (chartData[1]) {
                let _thisYear = []
                let _lastYear = []
                chartData[1].forEach((item) => {
                    if (item.effectMonth <= this.quarter * 3) {
                        _thisYear.push(item.effectCount)
                    } else {
                        _lastYear.push(item.effectCount)
                    }
                })
                arr1 = [..._lastYear, ..._thisYear]
            }
            if (chartData[2]) {
                let _thisYear = []
                let _lastYear = []
                chartData[2].forEach((item) => {
                    if (item.effectMonth <= this.quarter * 3) {
                        _thisYear.push(item.effectCount)
                    } else {
                        _lastYear.push(item.effectCount)
                    }
                })
                arr2 = [..._lastYear, ..._thisYear]
            }
            if (chartData[3]) {
                let _thisYear = []
                let _lastYear = []
                chartData[3].forEach((item) => {
                    if (item.effectMonth <= this.quarter * 3) {
                        _thisYear.push(item.effectCount)
                    } else {
                        _lastYear.push(item.effectCount)
                    }
                })
                arr3 = [..._lastYear, ..._thisYear]
            }

            return {
                XData, arr1, arr2, arr3
            }
        },
        getPilotReform(type) {
            this.loadObj.pilotReform = true
            let data = this.qs.stringify({
                quarter: this.quarter,
                year: this.year,
            })
            apiList.getPilotReform(data, (res) => {
                if (res && res.value && res.value.chart) {
                    this.deploymentTimeData = {}
                    this.deploymentTimeYear = []
                    this.deploymentTimeData1 = []
                    this.deploymentTimeData2 = []
                    let data = res.value.chart
                    data[1] &&
                        data[1].forEach((item) => {
                            if (!this.deploymentTimeData[item.x]) {
                                this.deploymentTimeData[item.x] = {
                                    country: item.y,
                                }
                            } else {
                                this.deploymentTimeData[item.x].country = item.y
                            }
                        })
                    data[2] &&
                        data[2].forEach((item) => {
                            if (!this.deploymentTimeData[item.x]) {
                                this.deploymentTimeData[item.x] = {
                                    city: item.y,
                                }
                            } else {
                                this.deploymentTimeData[item.x].city = item.y
                            }
                        })
                    for (let year in this.deploymentTimeData) {
                        this.deploymentTimeYear.push(year)
                        let city =
                            this.deploymentTimeData[year].city || undefined
                        let country =
                            this.deploymentTimeData[year].country || undefined
                        this.deploymentTimeData1.push(city)
                        this.deploymentTimeData2.push(country)
                    }
                    console.log(this.deploymentTimeData1)

                    if (type) {
                        this.initLineChart()
                    } else {
                        this.deployTimeOption.xAxis.data = this.deploymentTimeYear
                        this.deployTimeOption.series[0].data = this.deploymentTimeData2
                        // this.deployTimeOption.series[1].data = this.deploymentTimeData2
                        this.deployTimeChart.setOption(this.deployTimeOption)
                    }

                }
                if (res && res.value && res.value.achievement) {
                    res.value.achievement.forEach((item) => {
                        if (item.achievementType == 1) {
                            this.achievement1.totalAchievement =
                                item.totalAchievement || 0
                            this.achievement1.gapQAchievement =
                                item.gapQAchievement || 0
                        }
                        if (item.achievementType == 2) {
                            this.achievement2.totalAchievement =
                                item.totalAchievement || 0
                            this.achievement2.gapQAchievement =
                                item.gapQAchievement || 0
                        }
                        if (item.achievementType == 3) {
                            this.achievement3.totalAchievement =
                                item.totalAchievement || 0
                            this.achievement3.gapQAchievement =
                                item.gapQAchievement || 0
                        }
                    })
                }
                this.loadObj.pilotReform = false
            })
        },
        getGisData() {
            this.loadObj.loadingMap = true
            // composite 综合评价指数、workable 改革落实力、brand 品牌显示度、satisfaction 改革满意度、risk 风险管控力
            let types = [
                'composite',
                'workable',
                'brand',
                'satisfaction',
                'risk',
            ]
            types.forEach((type) => {
                let data = this.qs.stringify({
                    type,
                    quarter: this.quarter,
                    year: this.year,
                })
                apiList.getGisData(data, (res) => {
                    this[`${type}MapData`] = this.formatMapData(type, res)
                })
            })
        },
        formatMapData(type, res) {
            if (type == this.activeBtnKey) {
                this.handleMapArea(res, this.activeBtnKey)
                this.loadObj.loadingMap = false
            }
            if (type == 'risk') {
                let codeArr = []
                let temp = []
                res.forEach((item) => {
                    if (!codeArr.includes(item.unitCode)) {
                        codeArr.push(item.unitCode)
                        temp.push({
                            unitCode: item.unitCode,
                            eventData: [
                                {
                                    riskName: item.riskName,
                                    riskLevel: item.riskLevel,
                                    riskType: item.riskType,
                                },
                            ],
                        })
                    } else {
                        let i = codeArr.findIndex((key) => key == item.unitCode)
                        temp[i].eventData.push({
                            riskName: item.riskName,
                            riskLevel: item.riskLevel,
                            riskType: item.riskType,
                        })
                    }
                })
                return temp
            } else {
                return res
            }
        },
        getDemandHeatList(type) {
            this.loadObj.scrollListDataBottom = true
            let data = this.qs.stringify({
                quarter: this.quarter,
                year: this.year,
            })
            // 综合
            apiList.getDemandHeatList(data, (res) => {
                if (res.chart) {
                    let chartData = res.chart
                    let heatBarData = [],
                        lyqd = {}
                    if (this.quarter == 1) {
                        heatBarData[0] = ['需求来源', '1月', '2月', '3月']
                    } else if (this.quarter == 2) {
                        heatBarData[0] = ['需求来源', '4月', '5月', '6月']
                    } else if (this.quarter == 3) {
                        heatBarData[0] = ['需求来源', '7月', '8月', '9月']
                    } else if (this.quarter == 4) {
                        heatBarData[0] = ['需求来源', '10月', '11月', '12月']
                    }
                    this.legendTop = []
                    this.legendBottom = []
                    this.ggbb_lyqd = utils.getDictItemsFromCache('ggbb_lyqd')
                    this.ggbb_lyqd.forEach((qd, i) => {
                        lyqd[qd.value] = [
                            qd.name,
                            undefined,
                            undefined,
                            undefined,
                        ]
                        if (i + 1 <= this.ggbb_lyqd.length / 2) {
                            this.legendTop.push({
                                name: qd.name,
                            })
                        } else {
                            this.legendBottom.push({
                                name: qd.name,
                            })
                        }
                    })
                    chartData.forEach((item) => {
                        let index = 1
                        if ([1, 4, 7, 10].includes(item.x)) {
                            index = 1
                        } else if ([2, 5, 8, 11].includes(item.x)) {
                            index = 2
                        } else if ([3, 6, 9, 12].includes(item.x)) {
                            index = 3
                        }
                        lyqd[item.legend][index] = item.y
                    })

                    for (let qdValue in lyqd) {
                        heatBarData.push(lyqd[qdValue])
                    }

                    this.heatBarData = heatBarData
                    if (type) {
                        this.initBarChart()
                    } else {
                        this.heatBarOption.dataset.source = this.heatBarData
                        this.heatBarOption.legend[0].data = this.legendTop
                        this.heatBarOption.legend[1].data = this.legendBottom
                        this.heatBarChart.setOption(this.heatBarOption)
                    }
                }

                this.scrollListDataBottom = res.demandRank || []
                this.loadObj.scrollListDataBottom = false
            })
        },
        initBarChart() {
            const chartDom = document.getElementById('heat-bar-chart')
            this.heatBarChart = echarts.init(chartDom)
            this.heatBarOption = {
                dataset: {
                    source: this.heatBarData,
                },
                grid: {
                    //图表离外层盒子的距离
                    top: '32%',
                    bottom: '2%',
                    left: '1%',
                    right: '2%',
                    containLabel: true,
                },
                xAxis: {
                    type: 'category',
                    boundaryGap: true,
                    axisTick: false,
                    axisLine: {
                        lineStyle: {
                            color: 'rgba(154,199,220, 0.2)',
                        },
                    },
                    axisLabel: {
                        color: '#D7F1FF',
                    },
                },
                yAxis: {
                    type: 'value',
                    // min: 0,
                    // splitNumber: 5,
                    // interval: 1,
                    axisLabel: {
                        color: '#D7F1FF',
                        formatter: (val) => {
                            if ((val >= 1 && parseInt(val, 10) === val) || val == 0) {
                                return val
                            } else {
                                return
                            }
                        }
                    },
                    axisLine: {
                        lineStyle: {
                            color: 'rgba(154,199,220, 0.2)',
                        },
                    },
                    splitLine: {
                        lineStyle: {
                            color: 'rgba(154,199,220, 0.2)',
                        },
                    },
                },
                tooltip: {
                    trigger: 'axis',
                    backgroundColor: 'rgba(6, 47, 107, 1)',
                    borderColor: 'rgba(2, 115, 233, 1)',
                    textStyle: {
                        color: '#fff',
                    },
                },
                legend: [
                    {
                        left: 'center',
                        data: this.legendTop,
                        inactiveColor: '#333333',
                        borderRadius: 6,
                        itemWidth: 14,
                        itemHeight: 6,
                        itemGap: 40,
                        textStyle: {
                            color: '#B1E3FF',
                        },
                    },
                    {
                        left: 'center',
                        top: '14%',
                        data: this.legendBottom,
                        inactiveColor: '#333333',
                        borderRadius: 6,
                        itemWidth: 14,
                        itemHeight: 6,
                        itemGap: 40,
                        textStyle: {
                            color: '#B1E3FF',
                        },
                    },
                ],
                color: ['#59C06C', '#F5B351', '#2E84D0', '#FF97AE'],
                series: [
                    {
                        type: 'bar',
                        seriesLayoutBy: 'row',
                        barWidth: 8,
                        barGap: '80%',
                        itemStyle: {
                            borderRadius: 5,
                            color: new echarts.graphic.LinearGradient(
                                0,
                                0,
                                0,
                                1,
                                [
                                    { offset: 0, color: '#59C06C' },
                                    { offset: 1, color: 'rgba(89,192,108,0.3)' },
                                ]
                            ),
                        },
                    },
                    {
                        type: 'bar',
                        seriesLayoutBy: 'row',
                        barWidth: 8,
                        barGap: '80%',
                        itemStyle: {
                            borderRadius: 5,
                            color: new echarts.graphic.LinearGradient(
                                0,
                                0,
                                0,
                                1,
                                [
                                    { offset: 0, color: '#386A97' },
                                    { offset: 1, color: 'rgba(56,106,151,0.3)' },
                                ]
                            ),
                        },
                    },
                    {
                        type: 'bar',
                        seriesLayoutBy: 'row',
                        barWidth: 8,
                        barGap: '80%',
                        itemStyle: {
                            borderRadius: 5,
                            color: new echarts.graphic.LinearGradient(
                                0,
                                0,
                                0,
                                1,
                                [
                                    { offset: 0, color: '#F8B551' },
                                    { offset: 1, color: 'rgba(248,181,81,0.3)' },
                                ]
                            ),
                        },
                    },
                    {
                        type: 'bar',
                        seriesLayoutBy: 'row',
                        barWidth: 8,
                        barGap: '80%',
                        itemStyle: {
                            borderRadius: 5,
                            color: new echarts.graphic.LinearGradient(
                                0,
                                0,
                                0,
                                1,
                                [
                                    { offset: 0, color: '#FFBBC9' },
                                    { offset: 1, color: 'rgba(255,187,201,0.3)' },
                                ]
                            ),
                        },
                    },
                ],
            }
            this.heatBarOption &&
                this.heatBarChart.setOption(this.heatBarOption)
            window.addEventListener('resize', () => this.heatBarChart.resize())
        },
        getDictName(code, value) {
            return utils.getDictName(code, value)
        },
        handleNewsDetail(column) {
            this.handleDetail(
                'reformNewsSingle',
                column.id
            )
            // if (column.isUrl) {
            //     window.open(column.url, '_blank')
            // } else {
            //     this.handleDetail(
            //         'reformNewsSingle'
            //     )
            // }
        },
        loadNews() {
            this.loadObj.scrollBoradData = true
            let data = {
                pageBean: { pageSize: -1, page: 1 },
                querys: [
                    {
                        group: 'main',
                        operation: 'EQUAL',
                        parentGroup: '',
                        property: 'n.OPERATE_TYPE_',
                        relation: 'AND',
                        value: '2',
                    },
                    {
                        group: 'main',
                        operation: 'EQUAL',
                        parentGroup: '',
                        property: 'n.EXCELLENT_',
                        relation: 'AND',
                        value: '3',
                    },
                ],
            }
            apiList.getNews(data, (res) => {
                this.scrollBoradData = res.rows
                this.loadObj.scrollBoradData = false
            })
        },
        getNewsDetail(type, row) {
            this.currentTabComponent = dialogConfig.dialogOption[type]
                .componentName
                ? dialogConfig.dialogOption[type].componentName
                : type // 动态组件名称
            if (row) {
                dialogConfig.dialogOption[type].option.dialogTitle =
                    row.title
            }
            this.tableOptions = {
                ...dialogConfig.dialogOption[type].dataOptions,
                id: row.id,
            } //table的查询参数
            this.dialogOption = dialogConfig.dialogOption[type].option //弹窗配置参数
            this.showEasy = true
        },
        openSubDialog(type, dataOptions) {
            this.currentTabComponent = dialogConfig.dialogOption[type]
                .componentName
                ? dialogConfig.dialogOption[type].componentName
                : type // 动态组件名称
            if (dataOptions) {
                this.tableOptions = {
                    ...dialogConfig.dialogOption[type].dataOptions,
                    ...dataOptions
                }
            } else {
                this.tableOptions = dialogConfig.dialogOption[type].dataOptions //table的查询参数
            }
            this.dialogOption = dialogConfig.dialogOption[type].option //弹窗配置参数
            this.showEasy = true
        },
        initLineChart() {
            const chartDom = document.getElementById('deploymentTime')
            this.deployTimeChart = echarts.init(chartDom)
            this.deployTimeOption = {
                grid: {
                    //图表离外层盒子的距离
                    top: '5%',
                    bottom: '6%',
                    left: 0,
                    right: '6%',
                    containLabel: true,
                },
                tooltip: {
                    trigger: 'axis',
                    backgroundColor: 'rgba(6, 47, 107, 1)',
                    borderColor: 'rgba(2, 115, 233, 1)',
                    textStyle: {
                        color: '#fff',
                    },
                },
                // legend: {
                //     data: ['市级', '国家级'],
                //     inactiveColor: '#333333',
                //     itemWidth: 20,
                //     itemHeight: 6,
                //     textStyle: {
                //         color: '#B1E3FF',
                //     },
                // },
                xAxis: {
                    type: 'category',
                    boundaryGap: false,
                    axisTick: false,
                    axisLine: {
                        lineStyle: {
                            color: 'rgba(154,199,220, 0.2)',
                        },
                    },
                    axisLabel: {
                        color: '#D7F1FF',
                    },
                    data: this.deploymentTimeYear,
                },
                yAxis: {
                    type: 'value',
                    min: 0,
                    splitNumber: 5,
                    axisLabel: {
                        color: '#D7F1FF',
                        formatter: (val) => {
                            if ((val >= 1 && parseInt(val, 10) === val) || val == 0) {
                                return val
                            } else {
                                return
                            }
                        }
                    },
                    axisLine: {
                        lineStyle: {
                            color: 'rgba(154,199,220, 0.2)',
                        },
                    },
                    splitLine: {
                        lineStyle: {
                            color: 'rgba(154,199,220, 0.2)',
                        },
                    },
                },
                color: ['#00FFFF', '#CE01E0'],
                series: [
                    // {
                    //     name: '市级',
                    //     data: this.deploymentTimeData1,
                    //     type: 'line',
                    //     symbol: 'emptyCircle',
                    //     symbolSize: 4,
                    //     areaStyle: {
                    //         color: {
                    //             type: 'linear',
                    //             x: 0,
                    //             y: 0,
                    //             x2: 0,
                    //             y2: 1,
                    //             colorStops: [
                    //                 {
                    //                     offset: 0,
                    //                     color: 'rgba(0,255,255,1)', // 0% 处的颜色
                    //                 },
                    //                 {
                    //                     offset: 0.4,
                    //                     color: 'rgba(0,255,255, 0.2)', // 0% 处的颜色
                    //                 },
                    //                 {
                    //                     offset: 1,
                    //                     color: 'rgba(0,255,255,0)', // 100% 处的颜色
                    //                 },
                    //             ],
                    //             global: false, // 缺省为 false
                    //         },
                    //     },
                    // },
                    {
                        name: '国家级',
                        data: this.deploymentTimeData2,
                        type: 'line',
                        symbol: 'emptyCircle',
                        symbolSize: 4,
                        areaStyle: {
                            color: {
                                type: 'linear',
                                x: 0,
                                y: 0,
                                x2: 0,
                                y2: 1,
                                colorStops: [
                                    {
                                        offset: 0,
                                        color: 'rgba(206, 1, 224, 1)', // 0% 处的颜色
                                    },
                                    {
                                        offset: 0.4,
                                        color: 'rgba(206, 1, 224, 0.2)', // 0% 处的颜色
                                    },
                                    {
                                        offset: 1,
                                        color: 'rgba(206, 1, 224, 0)', // 100% 处的颜色
                                    },
                                ],
                                global: false, // 缺省为 false
                            },
                        },
                    },
                ],
            }
            this.deployTimeOption &&
                this.deployTimeChart.setOption(this.deployTimeOption)
        },
        initReformBrand() {
            const chartDom = document.getElementById('reform-brand')
            this.reformBrandChart = echarts.init(chartDom)
            this.reformBrandOption = {
                grid: {
                    //图表离外层盒子的距离
                    top: '24%',
                    bottom: 0,
                    left: 0,
                    right: 0,
                    containLabel: true,
                },
                tooltip: {
                    trigger: 'axis',
                    backgroundColor: 'rgba(6, 47, 107, 1)',
                    borderColor: 'rgba(2, 115, 233, 1)',
                    textStyle: {
                        color: '#fff',
                    },
                    formatter: function (params) {
                        let tipString = params[0].axisValue + "<br />";
                        let seriesName = ['获全国性肯定评价', '获全市推广', '获中央媒体深度专题报道']
                        for (let i = 0, length = params.length; i < length; i++) {
                            tipString += `<div style="width: 240px;justify-content: space-between;align-items: center;display:flex;">
                                            <span>
                                                <span style="display:inline-block;margin-right:5px;border-radius:10px;width:9px;height:9px;background:${params[i].color}"></span>
                                                <span style="font-size: 14px;">${seriesName[i]}</span>
                                            </span>
                                            <span style="font-size: 14px;font-weight:bold;">${params[i].value}</span>
                                        </div>
                                        `;
                        }
                        return tipString;
                    }
                },
                legend: {
                    data: ['全国肯定', '全市推广', '央媒报道'],
                    inactiveColor: '#333333',
                    borderRadius: 6,
                    itemWidth: 20,
                    itemHeight: 6,
                    textStyle: {
                        color: '#B1E3FF',
                    },
                },
                xAxis: {
                    type: 'category',
                    boundaryGap: true,
                    axisTick: false,
                    axisLine: {
                        lineStyle: {
                            color: 'rgba(154,199,220, 0.2)',
                        },
                    },
                    axisLabel: {
                        color: '#D7F1FF',
                    },
                    data: this.xAxisData,
                },
                yAxis: {
                    type: 'value',
                    min: 0,
                    splitNumber: 3,
                    axisLabel: {
                        color: '#D7F1FF',
                        formatter: (val) => {
                            if ((val >= 1 && parseInt(val, 10) === val) || val == 0) {
                                return val
                            } else {
                                return
                            }
                        }
                    },
                    axisLine: {
                        lineStyle: {
                            color: 'rgba(154,199,220, 0.2)',
                        },
                    },
                    splitLine: {
                        lineStyle: {
                            color: 'rgba(154,199,220, 0.2)',
                        },
                    },
                },
                color: ['#59C06C', '#64b4ff', '#FFB51F'],
                series: [
                    {
                        name: '全国肯定',
                        data: this.brandChartData1,
                        type: 'bar',
                        barWidth: 6,
                        itemStyle: {
                            borderRadius: 5,
                        },
                    },
                    {
                        name: '全市推广',
                        data: this.brandChartData2,
                        type: 'bar',
                        barWidth: 6,
                        itemStyle: {
                            borderRadius: 5,
                        },
                    },
                    // {
                    //     name: '央媒报道',
                    //     data: this.brandChartData3,
                    //     type: 'line',
                    //     symbol: 'emptyCircle',
                    //     symbolSize: 4,
                    //     areaStyle: {
                    //         color: {
                    //             type: 'linear',
                    //             x: 0,
                    //             y: 0,
                    //             x2: 0,
                    //             y2: 1,
                    //             colorStops: [
                    //                 {
                    //                     offset: 0,
                    //                     color: 'rgba(255, 181, 31, 1)', // 0% 处的颜色
                    //                 },
                    //                 {
                    //                     offset: 0.4,
                    //                     color: 'rgba(255, 181, 31, 0.2)', // 0% 处的颜色
                    //                 },
                    //                 {
                    //                     offset: 1,
                    //                     color: 'rgba(255, 181, 31, 0)', // 100% 处的颜色
                    //                 },
                    //             ],
                    //             global: false, // 缺省为 false
                    //         },
                    //     },
                    // },
                ],
            }
            this.reformBrandOption &&
                this.reformBrandChart.setOption(this.reformBrandOption)
        },
        // 切换地图分类按钮
        changeMapBtn(key) {
            this.activeBtnKey = key
            if (key == 'composite') {
                this.handleMapArea(this.compositeMapData, key)
            } else if (key == 'workable') {
                this.handleMapArea(this.workableMapData, key)
            } else if (key == 'brand') {
                this.handleMapArea(this.brandMapData, key)
            } else if (key == 'satisfaction') {
                this.handleMapArea(this.satisfactionMapData, key)
            } else if (key == 'risk') {
                this.handleMapArea(this.riskMapData, key)
            }
        },

        // 按钮切换内容
        changeBtnTab(item) {
            this.activeBtn = item
        },
        // 准备地图数据
        preMapData(data) {
            // this.handleMapArea(this.mapDataAll, 'synGrade')
            this.handleMapArea(this.mapDataKide, 'allGrade')
            // this.handleMapArea(this.mapDataKide, 'nationalProjectGrade')

            // this.kindIndex = 1;
            // this.$nextTick(() => {
            //      this.$refs.mySwiper.swiper.autoplay.start()
            // })
            // this.swiper.slideNext()
            this.changeMapType()
            this.initSwiper();
            // this.timer = setInterval(() => {
            //     this.changeMapType()
            // }, 5000)

        },
        changeMapType() {
            // console.log(this.kindIndex)
            // let data
            // if (this.kindIndex == 0) {
            //     data = this.mapDataAll
            // } else {
            //     data = this.mapDataKide
            // }
            let data = this.mapDataKide
            let ljxqGrade = data.filter(item => item.unitCode === '500191000000')
            let gxqGrade = data.filter(item => item.unitCode === '500193000000')
            console.log(ljxqGrade, gxqGrade);
            this.ljxqGrade = ljxqGrade[0][this.mapKeyArr[this.kindIndex]]
            this.gxqGrade = gxqGrade[0][this.mapKeyArr[this.kindIndex]]
            this.handleMapArea(data, this.mapKeyArr[this.kindIndex])

            // this.kindIndex = this.kindIndex + 1

            // if (this.kindIndex == 7) {
            //     this.kindIndex = 0
            // }
        },
        handleMapArea(markData, key) {
            this.optionCQ.series[0].data = this.convertData(
                cq.features,
                markData,
                key
            )
            this.optionMain.series[0].data = this.convertData(
                main9.features,
                markData,
                key,
                true
            )

            this.myChartCQ.setOption(this.optionCQ)
            this.myChartMain.setOption(this.optionMain)
            if (this.swiper) {
                this.swiper.slideNext()
            }
        },
        initMapCQ() {
            let dom = document.getElementById('cq-contianer')
            let width = getComputedStyle(dom).getPropertyValue('width').replace('px', '')
            let height = getComputedStyle(dom).getPropertyValue('height').replace('px', '')
            width = parseInt(width, 10)
            height = parseInt(height, 10)
            this.myChartCQ = echarts.init(
                dom,
                null,
                {
                    renderer: 'svg',
                    width,
                    height
                }
            )
            // 注册 echarts 地图

            echarts.registerMap('cq', cq)
            var markPointData = []
            let map = 'cq',
                top = "38%",
                left = '-16%',
                zoom = 1.2,
                aspectScale = 1,
                center = [106.5049, 29], // 地图中心位置， 此处的纬度与下面的center相差1度是形成阴影的距离，可自己随意调整
                layoutCenter = ['50%', '50%']
            this.optionCQ = {
                series: [
                    {
                        name: '重庆',
                        type: 'map', //配置显示方式为用户自定义
                        map,
                        zoom, // 地图比例
                        zlevel: 100,
                        center, // 地图中心位置， 此处的纬度与下面的center相差1度是形成阴影的距离，可自己随意调整
                        aspectScale,
                        roam: false,
                        scaleLimit: {
                            min: 0.6,
                            max: 4
                        },
                        itemStyle: {
                            normal: {
                                borderWidth: 1, //设置外层边框
                                borderColor: '#2ddcfd',
                            },
                        },
                        emphasis: {
                            disabled: true,
                        },
                        top,
                        left,
                        data: this.convertData(
                            cq.features,
                            fakeData.btnkey1,
                            'risk'
                        ),
                    },
                ],
            }
            this.myChartCQ.setOption(this.optionCQ)
            this.myChartCQ.on('click', (params) => {
                let code = params.value
                if (!code) {
                    code = this.getAreaCode(params.name, cq)
                }
                this.$router.push({
                    path: '/DistrictReformSubView',
                    query: {
                        name: params.name,
                        code: code,
                    },
                })
                let tooltip = document.getElementsByClassName('data-tooltip')
                Array.from(tooltip).forEach((item) => {
                    item.remove()
                })
            })
        },
        openDialog(position) {
            if (!this.mapDialogShow) this.mapDialogShow = true
            this.mapDialogleft = position.clientX + 10
            this.mapDialogTop = position.clientY + 10
        },
        initMapMain() {
            this.myChartMain = echarts.init(
                document.getElementById('main9-contianer'),
                null,
                {
                    renderer: 'svg',
                }
            )
            // 注册 echarts 地图
            echarts.registerMap('main9', main9)
            var markPointData = []
            let top = 24,
                left = 45,
                zoom = 1.2,
                map = 'main9',
                aspectScale = 1,
                layoutCenter = ['50%', '50%'],
                center = [106.204962, 29.533155] // 地图中心位置， 此处的纬度与下面的center相差1度是形成阴影的距离，可自己随意调整
            this.optionMain = {
                geo: [
                    {
                        map,
                        zoom,
                        zlevel: 0,
                        aspectScale,
                        itemStyle: {
                            normal: {
                                borderWidth: 0,
                            },
                        },
                        emphasis: {
                            disabled: true,
                        },
                        tooltip: {
                            show: false,
                        },
                        top,
                        left,
                        // layoutCenter
                    },
                ],
                series: [
                    {
                        name: '重庆主城',
                        type: 'map',
                        map,
                        zoom, // 地图比例
                        zlevel: 100,
                        // center, // 地图中心位置， 此处的纬度与下面的center相差1度是形成阴影的距离，可自己随意调整
                        aspectScale,
                        itemStyle: {
                            normal: {
                                borderWidth: 1, //设置外层边框
                                borderColor: 'white',
                            },
                        },
                        emphasis: {
                            disabled: true,
                            itemStyle: {
                                areaColor: 'yellow',
                            },
                        },
                        top,
                        left,
                        data: this.convertData(
                            main9.features,
                            fakeData.btnkey1,
                            'risk',
                            true
                        ),
                    },
                ],
            }
            this.myChartMain.setOption(this.optionMain)
            this.myChartMain.on('click', (params) => {
                let code = params.value
                if (!code) {
                    code = this.getAreaCode(params.name, main9)
                }
                this.$router.push({
                    path: '/DistrictReformSubView',
                    query: {
                        name: params.name,
                        code: code,
                    },
                })
                let tooltip = document.querySelectorAll('.data-tooltip')
                Array.from(tooltip).forEach((item) => {
                    item.remove()
                })
            })
        },

        getAreaCode(name, dataType) {
            let code
            dataType.features.find(item => {
                if (item.properties.name == name) {
                    code = item.properties.code
                }
            })
            return code
        },
        resize(delay) {
            // 动态计算表格的高度，自适应当前容器
            setTimeout(() => {
                let dom = document.getElementById('cq-contianer')
                if (!dom) return
                let width = getComputedStyle(dom).getPropertyValue('width').replace('px', '')
                let height = getComputedStyle(dom).getPropertyValue('height').replace('px', '')
                width = parseInt(width, 10)
                height = parseInt(height, 10)
                this.myChartCQ.resize({
                    width: width,
                    height: height
                })
                this.myChartMain.resize()
                this.deployTimeChart.resize()
                this.reformBrandChart.resize()
            }, delay || 0)
        },
    },
}