interface IOption {
    title: string
    prop: string
    type: string
    value: any
    span?: number
    dateOption?: any
    options?: any[]
    queryHandler?: any
    placeholder?: string
    allowCreate?: boolean
    number?: boolean
    minWidth?: number

    [key: string]: any
}

interface COption {
    title: string
    prop: string
    minWidth: number
    render?: boolean
    formatter?: any
    sortable?: boolean

    [key: string]: any
}

interface TableOptions {
    categoryChange: () => Promise<void>
}

export function useTableOptionConfig({ categoryChange }: TableOptions) {
    const customOptionList: IOption[] = []
    const fixedOptionList: IOption[] = [
        {
            title: '供方名称',
            prop: 'se.SUPPLIER_NAME_',
            type: 'input',
            span: 4,
            value: ''
        },
        {
            title: '合同签署状态',
            prop: 'contractSignStatus',
            type: 'select',
            span: 4,
            value: '',
            options: [
                { name: '未签署', value: '0' },
                { name: '签署中', value: '1' },
                { name: '已签署', value: '2' },
                { name: '已作废', value: '3' },
            ]
        },
        {
            title: '签署时间',
            prop: 'contractSignDate',
            type: 'date',
            dateOption: {
                type: 'datetimerange',
                format: 'YYYY-MM-DD HH:mm:ss',
                valueFormat: 'YYYY-MM-DD HH:mm:ss',
                defaultTime: [new Date(0, 0, 0, 0, 0, 0), new Date(0, 0, 0, 23, 59, 59)]
            },
            span: 6,
            value: []
        }
    ]
    const columnsList: COption[] = [
        {
            title: '供方名称',
            prop: 'companyName',
            minWidth: 160,
            sortable: true
        },
        {
            title: '供应商等级',
            prop: 'gradingName',
            minWidth: 120,
            sortable: true
        },
        {
            title: '供应商类型',
            prop: 'catName',
            minWidth: 120,
            sortable: true
        },
        {
            title: '签署时间',
            prop: 'contractSignDate',
            minWidth: 120,
            sortable: true
        },
        {
            title: '合同签署状态',
            prop: 'contractSignStatus',
            minWidth: 120,
            sortable: true,
            render:true
        },
    ]
    return {
        customOptionList,
        fixedOptionList,
        columnsList
    }
}
