import { dictionaryEscape, getDictionaryByCode } from '@/utils/dictionary'

interface IOption {
    title: string
    prop: string
    type: string
    value: any
    span?: number
    dateOption?: any
    options?: any[]
    queryHandler?: any
    placeholder?: string
    allowCreate?: boolean
    number?: boolean
    minWidth?: number

    [key: string]: any
}

interface COption {
    title: string
    prop: string
    minWidth: number
    render?: boolean
    formatter?: any
    sortable?: boolean

    [key: string]: any
}

interface TableOptions {
    categoryChange: () => Promise<void>
}

export function useTableOptionConfig({ categoryChange }: TableOptions) {
    const customOptionList: IOption[] = [
        
    ]
    const fixedOptionList: IOption[] = [
        {
            title: '姓名',
            prop: 'fullname',
            type: 'input',
            span: 4,
            value: ''
        },
    ]
    const columnsList: COption[] = [
        {
            title: '企业名称',
            prop: 'enterpriseName',
            minWidth: 160,
            sortable: true
        },
        {
            title: '姓名',
            prop: 'fullname',
            minWidth: 120,
            sortable: true
        },
        {
            title: '联系方式',
            prop: 'mobile',
            minWidth: 120,
            sortable: true
        },
        {
            title: '职务',
            prop: 'duties',
            minWidth: 120,
            sortable: true
        },
        {
            title: '性别',
            prop: 'sex',
            minWidth: 120,
            sortable: true
        },
        {
            title: '出生日期',
            prop: 'birthday',
            minWidth: 120,
            sortable: true
        },
        {
            title: '学历',
            prop: 'education',
            minWidth: 120,
            sortable: true
        },
        {
            title: '邮箱',
            prop: 'email',
            minWidth: 120,
            sortable: true
        },
        {
            title: '创建时间',
            prop: 'createTime',
            minWidth: 120,
            sortable: true
        }
    ]
    return {
        customOptionList,
        fixedOptionList,
        columnsList
    }
}
