import { dictionaryEscape, getDictionaryByCode } from '@/utils/dictionary'

interface IOption {
    title: string
    prop: string
    type: string
    value: any
    span?: number
    dateOption?: any
    options?: any[]
    queryHandler?: any
    placeholder?: string
    allowCreate?: boolean
    number?: boolean
    minWidth?: number

    [key: string]: any
}

interface COption {
    title: string
    prop: string
    minWidth: number
    render?: boolean
    formatter?: any
    sortable?: boolean

    [key: string]: any
}

interface TableOptions {
    categoryChange: () => Promise<void>
}

export function useTableOptionConfig({ categoryChange }: TableOptions) {
    const customOptionList: IOption[] = [
        {
            title: '评价体系名称',
            prop: 'valuationConfigurationName',
            type: 'input',
            value: ''
        },
        {
            title: '评价结论',
            prop: 'assessmentResult',
            type: 'select',
            options: [
                { name: '合格', value: '1' },
                { name: '可改善', value: '2' },
                { name: '不合格', value: '3' },
            ],
            value: '',
            span: 4
        },
        {
            title: '考核年度',
            prop: 'assessmentYear',
            type: 'date',
            dateOption: {
                type: 'year',
                format: 'YYYY',
                valueFormat: 'YYYY',
            },
            span: 4,
            value: ''
        }
    ]
    const fixedOptionList: IOption[] = [
        {
            title: '供方名称',
            prop: 'supplierName',
            type: 'input',
            span: 4,
            value: ''
        },
        {
            title: '考核类型',
            prop: 'assessmentType',
            type: 'select',
            options: [
                { name: '年度考核', value: '3' },
                { name: '季度考核', value: '2' },
                { name: '月度考核', value: '1' }
            ],
            value: '',
            span: 4
        },
        {
            title: '考核评级',
            prop: 'level',
            type: 'select',
            options: [
                { name: '优秀', value: '1' },
                { name: '良好', value: '2' },
                { name: '合格', value: '3' },
                { name: '可改善', value: '4' },
                { name: '不合格', value: '5' }
            ],
            value: '',
            span: 4
        },
        {
            title: '状态',
            prop: 'eva.STATUS_',
            type: 'select',
            options: [
                { name: '待评分', value: '2' },
                { name: '评分中', value: '3' },
                { name: '待评价', value: '4' },
                { name: '已完成', value: '1' },
                { name: '取消/关闭', value: '5' }
            ],
            value: '',
            span: 4
        },
    ]
    const columnsList: COption[] = [
        {
            title: '供方编码',
            prop: 'supplierNumber',
            minWidth: 120,
            sortable: true
        },
        {
            title: '供方名称',
            prop: 'supplierName',
            minWidth: 120,
            sortable: true
        },
        {
            title: '评价体系名称',
            prop: 'valuationConfigurationName',
            minWidth: 120,
            sortable: true
        },
        {
            title: '考核年度',
            prop: 'assessmentYear',
            minWidth: 120,
            render: true,
            sortable: true
        },
        {
            title: '考核类型',
            prop: 'assessmentType',
            minWidth: 120,
            render: true,
            sortable: true
        },
        {
            title: '考核周期',
            prop: 'assessment',
            minWidth: 120,
            render: true,
            sortable: true
        },
        {
            title: '总分值',
            prop: 'totalScore',
            minWidth: 120,
            sortable: true
        },
        {
            title: '考核得分',
            prop: 'operationScore',
            minWidth: 120,
            sortable: true
        },
        {
            title: '考核评级',
            prop: 'level',
            minWidth: 120,
            sortable: true,
            render: true
        },
        {
            title: '评价结论',
            prop: 'assessmentResult',
            minWidth: 120,
            render: true,
            sortable: true
        },
        
        {
            title: '状态',
            prop: 'status',
            minWidth: 120,
            sortable: true,
            render: true
        }
    ]
    return {
        customOptionList,
        fixedOptionList,
        columnsList
    }
}
