package com.artfess.uc.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @Author: wsf
 * @Description: 消息操作类型枚举
 * @DateTime: 2025/6/17 14:42
 **/

@Getter
@AllArgsConstructor
public enum MsgTypeEnum {

    ADD("ADD", "新增"),
    DELETE("DELETE", "删除"),
    UPDATE("UPDATE", "更新");

    /**
     * 类型编码
     */
    private final String code;

    /**
     * 类型描述
     */
    private final String description;

    /**
     * 根据 code 获取枚举
     */
    public static MsgTypeEnum fromCode(String code) {
        for (MsgTypeEnum type : values()) {
            if (type.getCode().equalsIgnoreCase(code)) {
                return type;
            }
        }
        return null;
    }
}
