package com.artfess.portal.kh.model;

import com.artfess.base.entity.AutoFillModel;
import com.artfess.base.entity.BizDelModel;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.FieldRepeat;
import com.artfess.base.valid.UpdateGroup;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableLogic;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Null;
import java.math.BigDecimal;

/**
 * 考核指标库
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2024-02-20
 */
@Data
@FieldRepeat(fields={"code"}, message = "指标编码已重复")
@ApiModel(value="KhIndicatorsLibrary对象", description="考核指标库")
public class KhIndicatorsLibrary extends BizDelModel<KhIndicatorsLibrary> {

    private static final long serialVersionUID = 1L;

    @NotNull(message = "修改必须指定id",groups = {UpdateGroup.class})
    @Null(message = "新增不能指定id",groups = {AddGroup.class})
    @TableId(value = "id_", type = IdType.ASSIGN_ID)
    private String id;

    @NotBlank(message = "请选择指标科目", groups = {AddGroup.class, UpdateGroup.class})
    @ApiModelProperty(value = "指标科目ID")
    @TableField("subject_id_")
    private String subjectId;

    @NotBlank(message = "请选择指标性质", groups = {AddGroup.class, UpdateGroup.class})
    @ApiModelProperty(value = "指标性质【字典】（1：量化指标，2：非量化指标）")
    @TableField("nature_")
    private String nature;

    @ApiModelProperty(value = "目标值（非量化指标为空）")
    @TableField("target_value_")
    private BigDecimal targetValue;

    @ApiModelProperty(value = "默认值（非量化指标为空）")
    @TableField("default_value_")
    private BigDecimal defaultValue;

    @NotBlank(message = "请输入指标名称", groups = {AddGroup.class, UpdateGroup.class})
    @ApiModelProperty(value = "指标名称")
    @TableField("name_")
    private String name;

    @NotBlank(message = "请输入指标编码", groups = {AddGroup.class, UpdateGroup.class})
    @ApiModelProperty(value = "指标编码", notes = "使用拼音首字母（后台有现成接口）")
    @TableField("code_")
    private String code;

    @NotBlank(message = "请选择指标考核对象类型", groups = {AddGroup.class, UpdateGroup.class})
    @ApiModelProperty(value = "指标考核对象类型【字典】（ogn：单位，dept：部门，user：人员，post：岗位，other：其它）")
    @TableField("obj_type_")
    private String objType;

    @ApiModelProperty(value = "指标定义(考核说明)")
    @TableField("contents_")
    private String contents;

    @ApiModelProperty(value = "计算方法（评分标准）")
    @TableField("mode_")
    private String mode;

    @ApiModelProperty(value = "计量单位")
    @TableField("unit_")
    private String unit;

    @ApiModelProperty(value = "租户ID")
    @TableField("tenant_id_")
    private String tenantId;

}
