package com.artfess.portal.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.portal.persistence.manager.SysRedisCacheManager;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.Map;

/**
 * @Program: edp
 * @Date: 2021/3/10
 * @Author: ZQF
 * @Description: Redis 缓存
 */
@RestController
@RequestMapping("/sys/sysRedisCache/v1")
@Api(tags = "Redis 缓存")
@ApiGroup(group = {ApiGroupConsts.GROUP_SYSTEM})
public class SysRedisCacheController {

    @Resource
    SysRedisCacheManager sysRedisCacheManager;

    @RequestMapping(value = "getAllCache", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "查询Redis所有缓存信息", httpMethod = "POST", notes = "查询Redis所有缓存信息")
    public Map<String, Object> getAllCache(@ApiParam(name = "key", value = "查询参数") @RequestParam(required = false) String key) throws Exception {
        return sysRedisCacheManager.getAllCache(key);
    }

//    @RequestMapping(value="deleteCache", method= RequestMethod.POST, produces = { "application/json; charset=utf-8" })
//    @ApiOperation(value = "删除", httpMethod = "POST", notes = "删除")
//    public CommonResult<String> deleteCache(@ApiParam(name="key",value="Redis key")@RequestParam String key) throws Exception {
//        return new CommonResult<>(true, sysRedisCacheManager.deleteCache(key));
//    }

}
