package com.artfess.portal.controller;

import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.sysConfig.persistence.manager.PortalAppParamManager;
import com.artfess.sysConfig.persistence.model.PortalAppParam;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 应用参数 前端控制器
 *
 * @author zst
 * @company 阿特菲斯信息技术有限公司
 * @since 2020-10-13
 */
@RestController
@RequestMapping("/portalAppParam/v1/")
public class PortalAppParamController extends BaseController<PortalAppParamManager, PortalAppParam> {

    @RequestMapping("/isAppHasDesc")
    @ApiOperation(value = "判断app是否拥有说明", httpMethod = "GET", notes = "判断app是否拥有说明")
    public CommonResult<Boolean> isAppHasDesc(@ApiParam(required = true, name = "应用ID", value = "appId") @RequestParam String appId) throws Exception {
        boolean b = baseService.existsByAppId(appId);
        return new CommonResult<Boolean>(true, "获取成功", b);
    }

    @RequestMapping("/getByAppId")
    @ApiOperation(value = "通过应用ID获取", httpMethod = "GET", notes = "通过应用ID获取")
    public CommonResult<List<PortalAppParam>> getByAppId(@ApiParam(required = true, name = "应用ID", value = "appId") @RequestParam String appId) throws Exception {
        return new CommonResult<List<PortalAppParam>>(true, "获取成功", baseService.getbyAppId(appId));
    }

}
