package com.artfess.portal.kh.manager.impl;

import com.artfess.base.context.BaseContext;
import com.artfess.base.enums.DelStatusEnum;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.util.BeanUtils;
import com.artfess.portal.kh.dao.KhSubjectDao;
import com.artfess.portal.kh.manager.KhSubjectManager;
import com.artfess.portal.kh.model.KhSubject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 考核科目信息 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2024-02-20
 */
@Service
public class KhSubjectManagerImpl extends BaseManagerImpl<KhSubjectDao, KhSubject> implements KhSubjectManager {

    @Autowired
    private BaseContext baseContext;

    @Override
    public List<KhSubject> getTree(KhSubject entity) {
        QueryWrapper<KhSubject> queryWrapper = new QueryWrapper();
        if (StringUtils.isNotBlank(entity.getCode())) {
            queryWrapper.like("code_", entity.getCode());
        }

        if (StringUtils.isNotBlank(entity.getName())) {
            queryWrapper.like("name_", entity.getName());
        }
        List<String> currentAndChildOrgIds = baseContext.getCurrentAndChildOrgIds();
        queryWrapper.in("create_org_id_", currentAndChildOrgIds);
        queryWrapper.eq("is_dele_", DelStatusEnum.N.getType());
        queryWrapper.orderByAsc("sn_");
        List<KhSubject> sysList = this.baseMapper.selectList(queryWrapper);
        List<KhSubject> tree = BeanUtils.listToTree(sysList);
        return tree;
    }
}
