package com.artfess.application.job;

import com.artfess.base.util.AppUtil;
import com.artfess.job.model.BaseJob;
import com.artfess.sysConfig.persistence.manager.SysErrorLogsManager;
import com.artfess.sysConfig.persistence.manager.SysLoginLogsManager;
import com.artfess.sysConfig.persistence.manager.SysLogsManager;
import com.artfess.sysConfig.persistence.manager.SysLogsSettingsManager;
import com.artfess.sysConfig.persistence.model.SysLogsSettings;
import org.quartz.JobExecutionContext;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 系统日志定时删除操作
 * 添加定时任务类
 * com.artfess.portal.job.SysLogsJob
 * @author liyanggui
 *
 */
public class SysLogsJob extends BaseJob {
	@Override
	public void executeJob(JobExecutionContext context) throws Exception {
		SysLogsManager sysLogsManager = AppUtil.getBean(SysLogsManager.class);
		SysLoginLogsManager sysLoginLogsManager = AppUtil.getBean(SysLoginLogsManager.class);
		SysErrorLogsManager sysErrorLogsManager = AppUtil.getBean(SysErrorLogsManager.class);
		SysLogsSettingsManager sysLogsSettingsManager = AppUtil.getBean(SysLogsSettingsManager.class);
		List<SysLogsSettings> allList = sysLogsSettingsManager.list();
		if(null != allList && allList.size() > 0){
			List<Map<String, Object>> optLogsParams = new ArrayList<Map<String,Object>>();
			List<Map<String, Object>> errorLogsParams = new ArrayList<Map<String,Object>>();
			List<Map<String, Object>> loginLogsParams = new ArrayList<Map<String,Object>>();
			for(SysLogsSettings settings : allList){
				if(null != settings && "1".equals(settings.getStatus())){
					//操作日志
					if(settings.getLogType() == 3){
						Map<String, Object> map = new HashMap<String, Object>();
						map.put("executionTime", LocalDateTime.now().minusDays(settings.getSaveDays()));
						map.put("moduleType", settings.getModuleType());
						optLogsParams.add(map);
					}
					//登录日志
					if(settings.getLogType() == 1){
						Map<String, Object> map = new HashMap<String, Object>();
						map.put("executionTime", LocalDateTime.now().minusDays(settings.getSaveDays()));
						loginLogsParams.add(map);
					}
					//异常日志
					if(settings.getLogType() == 2){
						Map<String, Object> map = new HashMap<String, Object>();
						map.put("executionTime", LocalDateTime.now().minusDays(settings.getSaveDays()));
						errorLogsParams.add(map);
					}
				}
			}
			//删除操作日志
			if(optLogsParams.size() > 0){
				sysLogsManager.removeByEexcutionTime(optLogsParams);
			}
			//删除登录日志
			if(loginLogsParams.size() > 0){
				sysLoginLogsManager.removeByEexcutionTime(loginLogsParams);
			}
			//删除错误日志
			if(errorLogsParams.size() > 0){
				sysErrorLogsManager.removeByEexcutionTime(errorLogsParams);
			}

		}
	}
}
