/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.gyl.supplierApply.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.controller.BaseController;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.valid.AddGroup;
import com.artfess.gyl.supplierApply.dto.EnterpriseDto;
import com.artfess.gyl.supplierApply.manager.BizSupplierEnterpriseManager;
import com.artfess.gyl.supplierApply.model.BizSupplierEnterprise;
import com.artfess.gyl.supplierApply.vo.EnterprisePageVo;
import com.artfess.gyl.supplierApply.vo.EnterpriseVo;
import com.artfess.gyl.supplierApply2.vo.FillingProgressVo;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.model.IUser;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.lang.reflect.InvocationTargetException;
import java.util.Objects;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/bizSupplierEnterprise/v1/"})
@Api(tags={"\u5408\u683c\u4f9b\u5e94\u5546\u8868"})
@ApiGroup(group={"group_biz_gyl"})
public class BizSupplierEnterpriseController
extends BaseController<BizSupplierEnterpriseManager, BizSupplierEnterprise> {
    @PostMapping(value={"/saveModel"})
    @ApiOperation(value="\u4fdd\u5b58-\u5408\u683c\u4f9b\u5e94\u5546")
    public CommonResult<String> saveModel(@ApiParam(name="model", value="\u5b9e\u4f53\u4fe1\u606f") @Validated(value={AddGroup.class}) @RequestBody EnterpriseDto dto) {
        Boolean result = ((BizSupplierEnterpriseManager)this.baseService).saveModel(dto);
        if (!result.booleanValue()) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, null);
        }
        return CommonResult.success((Object)((Object)dto), (String)"\u4fdd\u5b58\u6210\u529f");
    }

    @GetMapping(value={"/getInfo/{id}"})
    @ApiOperation(value="\u67e5\u8be2-\u5408\u683c\u4f9b\u5e94\u5546\u8be6\u60c5")
    public EnterpriseVo getInfo(@ApiParam(name="id", value="\u5b9e\u4f53id") @PathVariable String id) {
        return ((BizSupplierEnterpriseManager)this.baseService).getInfo(id);
    }

    @PostMapping(value={"/queryPage"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2-\u5408\u683c\u4f9b\u5e94\u5546\u5217\u8868")
    public PageList<EnterprisePageVo> queryPage(@ApiParam(name="queryFilter", value="\u5206\u9875\u67e5\u8be2\u4fe1\u606f") @RequestBody QueryFilter<BizSupplierEnterprise> queryFilter, @ApiParam(name="role", value="\u4f9b\u5e94\u5546\u8fd8\u662f\u4f01\u4e1a\u67e5\u8be2\uff081\u4f01\u4e1a\uff0c2\u4f9b\u5e94\u5546\uff09") @RequestParam String role) throws InvocationTargetException, IllegalAccessException {
        IUser user = ContextUtil.getCurrentUser();
        queryFilter.addFilter("se.IS_DELE_", (Object)"0", QueryOP.EQUAL);
        if (!Objects.requireNonNull(user).isAdmin()) {
            if ("1".equals(role)) {
                queryFilter.addFilter("se.ENTERPRISE_ID_", (Object)ContextUtil.getCurrentOrgId(), QueryOP.EQUAL);
            }
            if ("2".equals(role)) {
                queryFilter.addFilter("se.SUPPLIER_ID_", (Object)ContextUtil.getCurrentOrgId(), QueryOP.EQUAL);
            }
        }
        return ((BizSupplierEnterpriseManager)this.baseService).queryPage(queryFilter);
    }

    @GetMapping(value={"/getFillingProgress"})
    @ApiOperation(value="\u67e5\u8be2\u8be6\u60c5\u83dc\u5355")
    public FillingProgressVo getFillingProgress(@RequestParam String id) {
        return ((BizSupplierEnterpriseManager)this.baseService).getFillingProgress(id);
    }
}

