package com.artfess.gyl.supplierEva.model;

import com.artfess.base.entity.BizDelModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.Max;
import javax.validation.constraints.Min;

/**
 * 供应商绩效考核配置分值区间设定表
 *
 * @author huqi
 * @since 2025-11-11
 */
@Data
@TableName("biz_supplier_performance_evaluation_interval")
@ApiModel(value="BizSupplierPerformanceEvaluationInterval对象", description="供应商绩效考核配置分值区间设定表")
public class BizSupplierPerformanceEvaluationInterval extends BizDelModel<BizSupplierPerformanceEvaluationInterval> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "评审配置ID")
    @TableField("PERFORMANCE_EVALUATION_CONFIGURATION_ID_")
    private String performanceEvaluationConfigurationId;

    @ApiModelProperty(value = "最大分值（包含最小值）")
    @TableField("MAX_SCORE_")
    @Max(value = 100, message = "最大分值不能超过100")
    private Integer maxScore;

    @ApiModelProperty(value = "最小分值（包含最大值）")
    @TableField("MIN_SCORE_")
    @Min(value = 0, message = "最小分值不能小于0")
    private Integer minScore;

    @ApiModelProperty(value = "等级(1：优秀，2：良好，3：合格，4：可改善，5：不合格)")
    @TableField("LEVEL_")
    private String level;

    @ApiModelProperty(value = "排序号")
    @TableField("SEQ_")
    private Integer seq;

    @ApiModelProperty(value = "备注")
    @TableField("REMARKS_")
    private String remarks;
}
