package com.artfess.gyl.supplierApply2.model;

import com.artfess.base.entity.AutoFillFullModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 生产及检验设备表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wubin
 * @since 2025-11-11
 */
@Data
@ApiModel(value="BizSupplierProductionInspectionEquipment2对象", description="生产及检验设备表")
public class BizSupplierProductionInspectionEquipment2 extends AutoFillFullModel<BizSupplierProductionInspectionEquipment2> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "供应商准入ID")
    @TableField("SUPPLIER_ENTERPRISE_ID_")
    private String supplierEnterpriseId;

    @ApiModelProperty(value = "设备类型（1生产设备，2监测设备）")
    @TableField("DEVICE_TYPE_")
    private String deviceType;

    @ApiModelProperty(value = "生产监测/设备名称、型号")
    @TableField("NAME_")
    private String name;

    @ApiModelProperty(value = "产能/精度")
    @TableField("CAPACITY_")
    private String capacity;

    @ApiModelProperty(value = "数量")
    @TableField("NUM_")
    private String num;

    @ApiModelProperty(value = "生产厂家")
    @TableField("MANUFACTURER_")
    private String manufacturer;

    @ApiModelProperty(value = "使用年限")
    @TableField("SERVICE_LIFE_")
    private String serviceLife;

    @ApiModelProperty(value = "是否已删，1已删除，0未删除")
    @TableField("IS_DELE_")
    private String isDele;

    @ApiModelProperty(value = "版本号")
    @TableField("VERSION_")
    private Long version;

    @ApiModelProperty(value = "租户ID")
    @TableField("TENANT_ID_")
    private String tenantId;
}
