package com.artfess.gyl.supplierAccess.manager.impl;

import com.artfess.base.exception.ApplicationException;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.BeanUtils;
import com.artfess.gyl.supplierAccess.dto.BizSupplierAccessConfigurationDto;
import com.artfess.gyl.base.manager.*;
import com.artfess.gyl.base.model.*;
import com.artfess.gyl.supplierAccess.dao.BizSupplierAccessConfigurationDao;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.gyl.supplierAccess.manager.*;
import com.artfess.gyl.supplierAccess.model.*;
import com.artfess.gyl.supplierAccess.vo.BizSupplierAccessConfigurationVo;
import com.artfess.gyl.thirdParty.manager.BizCategoryManager;
import com.artfess.gyl.thirdParty.model.BizCategory;
import com.artfess.sysConfig.persistence.manager.SysIdentityManager;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 供应商准入配置表 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wubin
 * @since 2025-11-07
 */
@Service
public class BizSupplierAccessConfigurationManagerImpl extends BaseManagerImpl<BizSupplierAccessConfigurationDao, BizSupplierAccessConfiguration> implements BizSupplierAccessConfigurationManager {

    @Resource
    private BizSupplierAccessBasicManager supplierAccessBasicManager;

    @Resource
    private BizSupplierAccessProcessManager supplierAccessProcessManager;

    @Resource
    private BizSupplierAccessQualificationManager supplierAccessQualificationManager;

    @Resource
    private BizSupplierAccessConfigurationMaterialCategoryManager supplierAccessConfigurationMaterialCategoryManager;

    @Resource
    private BizSupplierMaterialCategoryManager supplierMaterialCategoryManager;

    @Resource
    private BizCategoryManager categoryManager;

    @Resource
    private SysIdentityManager sysIdentityManager;

    @Transactional(rollbackFor = Exception.class)
    @Override
    public Boolean saveModel(BizSupplierAccessConfigurationDto supplierAccessConfigurationDto) {
        Boolean result = false;
        BizSupplierAccessConfiguration supplierAccessConfiguration = BizSupplierAccessConfigurationDto.parse(supplierAccessConfigurationDto);
        validateModel(supplierAccessConfiguration);
        supplierAccessConfiguration.setIsDele("0");
        String currentOrgId = ContextUtil.getCurrentOrgId();
        String currentOrgCode = ContextUtil.getCurrentOrgCode();
        supplierAccessConfiguration.setEnterpriseId(currentOrgId);
        supplierAccessConfiguration.setEnterpriseCode(currentOrgCode);
        String code = sysIdentityManager.nextId("gyszrpzbm");
        supplierAccessConfiguration.setCode(code);
        //保存供应商准入配置主表
        result = save(supplierAccessConfiguration);
        if (!result){
            return false;
        }
        String id = supplierAccessConfiguration.getId();
        supplierAccessConfigurationDto.setEnterpriseId(currentOrgId);
        supplierAccessConfigurationDto.setEnterpriseCode(currentOrgCode);
        supplierAccessConfigurationDto.setId(id);
        supplierAccessConfigurationDto.setCode(code);
        saveModelSub(supplierAccessConfigurationDto);
        return true;
    }

    /**
     * 保存准入配置子表
     * @param supplierAccessConfigurationDto
     */
    @Transactional(rollbackFor = Exception.class)
    public void saveModelSub(BizSupplierAccessConfigurationDto supplierAccessConfigurationDto){
        //保存 基本情况调查配置
        String supplierAccessId = supplierAccessConfigurationDto.getId();
        BizSupplierAccessBasic basic = supplierAccessConfigurationDto.getBasic();
        basic.setIsDele("0");
        basic.setSupplierAccessId(supplierAccessId);
        supplierAccessBasicManager.save(basic);
        //保存 准入资质配置
        List<BizSupplierAccessQualification> qualificationList = new ArrayList<>();
        Map<String, List<BizSupplierAccessQualification>> qualificationMap = supplierAccessConfigurationDto.getQualificationMap();
        qualificationList.addAll(BeanUtils.isEmpty(qualificationMap.get("required")) ? new ArrayList<>() : qualificationMap.get("required"));
        qualificationList.addAll(BeanUtils.isEmpty(qualificationMap.get("unnecessary")) ? new ArrayList<>() : qualificationMap.get("unnecessary"));
        for (BizSupplierAccessQualification supplierAccessQualification : qualificationList) {
            supplierAccessQualification.setSupplierAccessId(supplierAccessId);
            supplierAccessQualification.setIsDele("0");
            supplierAccessQualification.setEnterpriseId(supplierAccessConfigurationDto.getEnterpriseId());
            supplierAccessQualification.setEnterpriseCode(supplierAccessConfigurationDto.getEnterpriseCode());
        }
        supplierAccessQualificationManager.saveBatch(qualificationList);
        //保存 业务流程配置
        BizSupplierAccessProcess process = supplierAccessConfigurationDto.getProcess();
        process.setSupplierAccessId(supplierAccessId);
        process.setIsDele("0");
        supplierAccessProcessManager.save(process);
        //保存 供应商准入配置&基础物料分类关联
        List<String> gategoryIds = supplierAccessConfigurationDto.getGategoryIds();
        List<BizSupplierAccessConfigurationMaterialCategory> categoryList = new ArrayList<>();
        for (String gategoryId : gategoryIds) {
            BizSupplierAccessConfigurationMaterialCategory category = new BizSupplierAccessConfigurationMaterialCategory();
            category.setSupplierAccessId(supplierAccessId);
            category.setCategoryId(gategoryId);
            categoryList.add(category);
        }
        supplierAccessConfigurationMaterialCategoryManager.saveBatch(categoryList);
    }

    @Override
    public BizSupplierAccessConfigurationVo getInfo(String id) {
        BizSupplierAccessConfiguration supplierAccessConfiguration = get(id);
        BizSupplierAccessConfigurationVo vo = new BizSupplierAccessConfigurationVo();
        vo.copy(supplierAccessConfiguration);
        //查询 基本情况调查配置
        BizSupplierAccessBasic basic = supplierAccessBasicManager.getOne(new LambdaQueryWrapper<BizSupplierAccessBasic>()
                .eq(BizSupplierAccessBasic::getSupplierAccessId, id)
                .eq(BizSupplierAccessBasic::getIsDele,"0"));
        vo.setBasic(basic);
        //查询 准入资质配置
        List<BizSupplierAccessQualification> qualificationList = supplierAccessQualificationManager.list(new LambdaQueryWrapper<BizSupplierAccessQualification>()
                .eq(BizSupplierAccessQualification::getSupplierAccessId, id)
                .eq(BizSupplierAccessQualification::getIsDele,"0"));
        Map<String, List<BizSupplierAccessQualification>> qualificationMap = qualificationList
                .stream()
                .collect(Collectors.groupingBy(BizSupplierAccessQualification::getRequired));
        vo.setQualificationMap(qualificationMap);
        //查询 业务流程配置
        BizSupplierAccessProcess process = supplierAccessProcessManager.getOne(new LambdaQueryWrapper<BizSupplierAccessProcess>()
                .eq(BizSupplierAccessProcess::getSupplierAccessId, id)
                .eq(BizSupplierAccessProcess::getIsDele,"0"));
        vo.setProcess(process);
        //查询 供应商准入配置&基础物料分类关联
        List<BizSupplierAccessConfigurationMaterialCategory> categoryList = supplierAccessConfigurationMaterialCategoryManager.list(new LambdaQueryWrapper<BizSupplierAccessConfigurationMaterialCategory>()
                .eq(BizSupplierAccessConfigurationMaterialCategory::getSupplierAccessId, id)
                .eq(BizSupplierAccessConfigurationMaterialCategory::getIsDele, "0"));
        List<String> categoryIds = categoryList.stream().map(c -> c.getCategoryId()).collect(Collectors.toList());
        List<String> categoryNames = new ArrayList<>();
        for (String categoryId : categoryIds) {
            BizCategory category = categoryManager.get(categoryId);
            categoryNames.add(category.getCatName());
        }
        vo.setGategoryIds(categoryIds);
        vo.setGategoryNameList(categoryNames);
        return vo;
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public Boolean updateModel(BizSupplierAccessConfigurationDto supplierAccessConfigurationDto) {
        Boolean result = false;
        BizSupplierAccessConfiguration supplierAccessConfiguration = BizSupplierAccessConfigurationDto.parse(supplierAccessConfigurationDto);
        String supplierAccessId = supplierAccessConfiguration.getId();
        String currentOrgId = ContextUtil.getCurrentOrgId();
        String currentOrgCode = ContextUtil.getCurrentOrgCode();
        supplierAccessConfiguration.setEnterpriseId(currentOrgId);
        supplierAccessConfiguration.setEnterpriseCode(currentOrgCode);
        validateModel(supplierAccessConfiguration);
        //修改 供应商准入配置主表
        result = updateById(supplierAccessConfiguration);
        if (!result){
            return false;
        }
        //删除 旧准入配置子表
        batchDeleteSub(new String[] {supplierAccessId});
        //保存 新准入配置主表
        saveModelSub(supplierAccessConfigurationDto);
        return true;
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public Boolean batchDelete(String[] ids) {
        //删除子表
        batchDeleteSub(ids);
        //删除准入配置主表
        return this.removeByIds(Arrays.asList(ids));
    }

    @Override
    public PageList<BizSupplierAccessConfigurationVo> queryPage(QueryFilter<BizSupplierAccessConfiguration> queryFilter) {
        PageList<BizSupplierAccessConfiguration> pageList = this.query(queryFilter);
        PageList<BizSupplierAccessConfigurationVo> resultPage = new PageList<>();
        resultPage.setPage(pageList.getPage());
        resultPage.setPageSize(pageList.getPageSize());
        resultPage.setTotal(pageList.getTotal());
        List<BizSupplierAccessConfigurationVo> resultList = new ArrayList<>();
        List<BizSupplierAccessConfiguration> rows = pageList.getRows();
        for (BizSupplierAccessConfiguration row : rows) {
            BizSupplierAccessConfigurationVo vo = new BizSupplierAccessConfigurationVo();
            vo.copy(row);
            //查询 供应商准入配置&基础物料分类关联
            List<BizSupplierAccessConfigurationMaterialCategory> categoryList = supplierAccessConfigurationMaterialCategoryManager.list(new LambdaQueryWrapper<BizSupplierAccessConfigurationMaterialCategory>()
                    .eq(BizSupplierAccessConfigurationMaterialCategory::getSupplierAccessId, row.getId())
                    .eq(BizSupplierAccessConfigurationMaterialCategory::getIsDele, "0"));
            List<String> categoryNameList = new ArrayList<>();
            for (BizSupplierAccessConfigurationMaterialCategory category : categoryList) {
                String categoryId = category.getCategoryId();
                BizCategory bizCategory = categoryManager.get(categoryId);
                if (BeanUtils.isEmpty(bizCategory)){
                    continue;
                }
                String categoryName = bizCategory.getCatName();
                categoryNameList.add(categoryName);
            }
            String categoryNames = String.join(",", categoryNameList);
            vo.setGategoryNames(categoryNames);
            resultList.add(vo);
        }
        resultPage.setRows(resultList);
        return resultPage;
    }

    /**
     * 批量删除准入配置子表
     * @param ids 准入配置主表 ids
     */
    @Transactional(rollbackFor = Exception.class)
    public void batchDeleteSub(String[] ids){
        //删除 基本情况调查配置
        supplierAccessBasicManager.remove(new LambdaQueryWrapper<BizSupplierAccessBasic>()
                .in(BizSupplierAccessBasic::getSupplierAccessId,ids)
                .eq(BizSupplierAccessBasic::getIsDele,"0"));
        //删除 准入资质配置（删除旧数据，保存新数据）
        supplierAccessQualificationManager.remove(new LambdaQueryWrapper<BizSupplierAccessQualification>()
                .in(BizSupplierAccessQualification::getSupplierAccessId,ids)
                .eq(BizSupplierAccessQualification::getIsDele,"0"));

        //删除 业务流程配置
        supplierAccessProcessManager.remove(new LambdaQueryWrapper<BizSupplierAccessProcess>()
                .in(BizSupplierAccessProcess::getSupplierAccessId,ids)
                .eq(BizSupplierAccessProcess::getIsDele,"0"));
        //删除 供应商准入配置&基础物料分类关联（删除旧数据，保存新数据）
        supplierAccessConfigurationMaterialCategoryManager.remove(new LambdaQueryWrapper<BizSupplierAccessConfigurationMaterialCategory>()
                .in(BizSupplierAccessConfigurationMaterialCategory::getSupplierAccessId,ids)
                .eq(BizSupplierAccessConfigurationMaterialCategory::getIsDele,"0"));
    }

    private void validateModel(BizSupplierAccessConfiguration supplierAccessConfiguration){
        if (BeanUtils.isEmpty(supplierAccessConfiguration)){
            throw new ApplicationException("保存的对象为空！");
        }
        if (BeanUtils.isEmpty(supplierAccessConfiguration.getName())){
            throw new ApplicationException("配置名称为空！");
        }
    }
}
