package com.artfess.gyl.base.manager.impl;

import com.artfess.base.exception.ApplicationException;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.StringUtil;
import com.artfess.file.model.DefaultFile;
import com.artfess.file.persistence.manager.FileManager;
import com.artfess.gyl.base.model.*;
import com.artfess.gyl.base.dao.BizSupplierQualificationDatabaseDao;
import com.artfess.gyl.base.manager.BizSupplierQualificationDatabaseManager;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import org.apache.http.util.Asserts;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 供应商资质库表，（供应商修改资质库文件提交后，是新添加一条数据，版本加1），新建的资质版本默认为1，这样就可以和供应商的 服务实现类
 *
 * @author 系统管理员
 * @since 2025-11-08
 */
@Service
public class BizSupplierQualificationDatabaseManagerImpl extends BaseManagerImpl<BizSupplierQualificationDatabaseDao, BizSupplierQualificationDatabase> implements BizSupplierQualificationDatabaseManager {
    @Resource
    private FileManager fileManager;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public boolean save(BizSupplierQualificationDatabase entity){
        List<DefaultFile> files = entity.getFiles();
        Asserts.notNull(files,"需上传的资质附件不能为空");
        if (entity.getTimeLimit() == null){
           entity.setTimeLimit(1);
       }
        boolean save = super.save(entity);
        if (!save) {
            return false;
        }
        //更新附件
        List<String> fileIds = files.stream().map(DefaultFile::getId).collect(Collectors.toList());
        //更新附件
        fileManager.updateFileBizIdByIds(fileIds,entity.getId());
        return true;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public boolean updateById(BizSupplierQualificationDatabase entity){
        List<DefaultFile> files = entity.getFiles();
        Asserts.notNull(files,"需上传的资质附件不能为空");
        if (entity.getTimeLimit() == 1){
            entity.setValidUntil(null);
        }else {
            if (entity.getValidUntil() == null){
                throw new ApplicationException("请输入有效截止期");
            }
        }
        boolean update = super.updateById(entity);
        if (!update) {
            return false;
        }
        //删除不在改范围内的附件
        List<String> fileIds = files.stream().map(DefaultFile::getId).collect(Collectors.toList());
        fileManager.removeFileByBizId(entity.getId(),fileIds);
        //更新附件
        fileManager.updateFileBizIdByIds(fileIds,entity.getId());
        return true;
    }

    @Override
    @Transactional(readOnly = true)
    public BizSupplierQualificationDatabase getById(Serializable id) {
        BizSupplierQualificationDatabase entity = super.getById(id);
        //查询附件
        if (entity !=null){
            List<DefaultFile> defaultFiles = fileManager.queryFileByBizId(entity.getId());
            if (CollectionUtils.isNotEmpty(defaultFiles)){
                entity.setFiles(defaultFiles);
            }
        }
        return entity;
    }

    @Override
    public PageList<BizSupplierQualificationDatabase> queryByPage(QueryFilter<BizSupplierQualificationDatabase> queryFilter) {
        IPage<BizSupplierQualificationDatabase> iPage = baseMapper.queryByPage(convert2IPage(queryFilter.getPageBean()), convert2Wrapper(queryFilter, currentModelClass()));
        return new PageList<>(iPage);
    }
}
