package com.artfess.gyl.base.dao;

import com.artfess.gyl.base.model.BizSupplierGradingConfiguration;
import com.artfess.gyl.base.model.BizSupplierQualificationDatabase;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import org.apache.ibatis.annotations.Param;

/**
 * 供应商资质库表，（供应商修改资质库文件提交后，是新添加一条数据，版本加1），新建的资质版本默认为1，这样就可以和供应商的 Mapper 接口
 *
 * @author 系统管理员
 * @since 2025-11-08
 */
public interface BizSupplierQualificationDatabaseDao extends BaseMapper<BizSupplierQualificationDatabase> {

    /**
     * 分页查询
     * @param convert2IPage
     * @param convert2Wrapper
     * @return
     */
    IPage<BizSupplierQualificationDatabase> queryByPage(IPage<BizSupplierQualificationDatabase> convert2IPage, @Param(Constants.WRAPPER) Wrapper<BizSupplierQualificationDatabase> convert2Wrapper);
}
