/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.table.meta.impl;

import com.artfess.base.util.BeanUtils;
import com.artfess.table.colmap.MySQLColumnMap;
import com.artfess.table.colmap.PostgreSQLColumnMap;
import com.artfess.table.meta.impl.BaseTableMeta;
import com.artfess.table.model.Column;
import com.artfess.table.model.Table;
import com.artfess.table.model.impl.DefaultTable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.util.Assert;

public class PostgreSQLTableMeta
extends BaseTableMeta {
    private final String SQL_GET_COLUMNS = "SELECT \tTABLE_NAME, COLUMN_NAME, tmp.column_comment, tmp.is_primary, IS_NULLABLE, DATA_TYPE, udt_name, CHARACTER_MAXIMUM_LENGTH LENGTH, (NUMERIC_PRECISION-NUMERIC_SCALE) PRECISIONS, NUMERIC_SCALE SCALE FROM \tinformation_schema. COLUMNS C INNER JOIN ( \tSELECT \tA .attname, col_description (A .attrelid, A .attnum) AS column_comment, ( \tCASE WHEN ( SELECT COUNT (*) FROM pg_constraint  WHERE conrelid = A .attrelid AND conkey [ 1 ]= attnum  AND contype = 'p'  ) > 0 THEN  'Y'  ELSE  'N'  END ) AS is_primary \tFROM  pg_attribute A \tINNER JOIN pg_class b ON A .attrelid = b.oid \tWHERE \t\tb.relname = '%s' \tAND A .attstattarget = '-1' ) tmp ON C . COLUMN_NAME = tmp.attname WHERE \ttable_schema = 'public' AND TABLE_NAME = '%s'";
    private final String SQL_GET_COLUMNS_BATCH = "SELECT \tTABLE_NAME, COLUMN_NAME, tmp.column_comment, tmp.is_primary, IS_NULLABLE, DATA_TYPE, udt_name, CHARACTER_MAXIMUM_LENGTH LENGTH, (NUMERIC_PRECISION-NUMERIC_SCALE) PRECISIONS, NUMERIC_SCALE SCALE FROM \tinformation_schema. COLUMNS C INNER JOIN ( \tSELECT \tA .attname, col_description (A .attrelid, A .attnum) AS column_comment, ( \tCASE WHEN ( SELECT COUNT (*) FROM pg_constraint  WHERE conrelid = A .attrelid AND conkey [ 1 ]= attnum  AND contype = 'p'  ) > 0 THEN  'Y'  ELSE  'N'  END ) AS is_primary \tFROM  pg_attribute A \tINNER JOIN pg_class b ON A .attrelid = b.oid \tWHERE \t\tb.relname in (%s) \tAND A .attstattarget = '-1' ) tmp ON C . COLUMN_NAME = tmp.attname WHERE \ttable_schema = 'public' AND TABLE_NAME in (%s)";
    private final String sqlComment = "select relname as table_name,cast(obj_description(relfilenode,'pg_class') as varchar) as table_comment from pg_class c where relname ='%s' ";
    private final String sqlAllTable = "select relname as table_name,cast(obj_description(relfilenode,'pg_class') as varchar) as table_comment from pg_class c where relname in (select tablename from pg_tables where schemaname='public' and position('_2' in tablename)=0 %s) ORDER BY oid";

    @Override
    public Table getTableByName(String tableName) {
        Table model = this.getTableModel(tableName);
        List<Column> columnList = this.getColumnsByTableName(tableName);
        model.setColumnList(columnList);
        return model;
    }

    @Override
    public Map<String, String> getTablesByName(String tableName) {
        String whereClause = "";
        if (StringUtils.isNotEmpty((String)tableName)) {
            whereClause = String.format(" AND tablename LIKE '%%%s%%'", tableName);
        }
        String sql = String.format("select relname as table_name,cast(obj_description(relfilenode,'pg_class') as varchar) as table_comment from pg_class c where relname in (select tablename from pg_tables where schemaname='public' and position('_2' in tablename)=0 %s) ORDER BY oid", whereClause);
        List list = this.jdbcTemplate.query(sql, (RowMapper)new RowMapper<Map<String, String>>(){

            public Map<String, String> mapRow(ResultSet rs, int row) throws SQLException {
                String tableName = rs.getString("table_name");
                String comments = rs.getString("table_comment");
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("name", tableName);
                map.put("comments", comments);
                return map;
            }
        });
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        for (int i = 0; i < list.size(); ++i) {
            Map tmp = (Map)list.get(i);
            String name = (String)tmp.get("name");
            String comments = (String)tmp.get("comments");
            comments = PostgreSQLTableMeta.getComments(comments, name);
            map.put(name, comments);
        }
        return map;
    }

    @Override
    public Map<String, String> getTablesByName(List<String> names) {
        String whereClause = "";
        if (BeanUtils.isNotEmpty(names)) {
            StringBuffer sb = new StringBuffer();
            for (String name : names) {
                sb.append("'");
                sb.append(name);
                sb.append("',");
            }
            sb.deleteCharAt(sb.length() - 1);
            whereClause = String.format(" and tablename in (%s)", sb.toString().toLowerCase());
        }
        String sql = String.format("select relname as table_name,cast(obj_description(relfilenode,'pg_class') as varchar) as table_comment from pg_class c where relname in (select tablename from pg_tables where schemaname='public' and position('_2' in tablename)=0 %s) ORDER BY oid", whereClause);
        List list = this.jdbcTemplate.query(sql, (RowMapper)new RowMapper<Map<String, String>>(){

            public Map<String, String> mapRow(ResultSet rs, int row) throws SQLException {
                String tableName = rs.getString("table_name");
                String comments = rs.getString("table_comment");
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("tableName", tableName);
                map.put("tableComment", comments);
                return map;
            }
        });
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        for (int i = 0; i < list.size(); ++i) {
            Map tmp = (Map)list.get(i);
            String name = (String)tmp.get("tableName");
            String comments = (String)tmp.get("tableComment");
            map.put(name, comments);
        }
        return map;
    }

    private Table getTableModel(final String tableName) {
        Assert.notNull((Object)tableName, (String)"\u8868\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        String sql = String.format("select relname as table_name,cast(obj_description(relfilenode,'pg_class') as varchar) as table_comment from pg_class c where relname ='%s' ", tableName.toLowerCase());
        Table table = (Table)this.jdbcTemplate.queryForObject(sql, (RowMapper)new RowMapper<Table>(){

            public Table mapRow(ResultSet rs, int row) throws SQLException {
                DefaultTable table = new DefaultTable();
                String comments = rs.getString("table_comment");
                comments = PostgreSQLTableMeta.getComments(comments, tableName);
                table.setTableName(tableName);
                table.setComment(comments);
                return table;
            }
        });
        if (BeanUtils.isEmpty((Object)table)) {
            table = new DefaultTable();
        }
        return table;
    }

    private List<Column> getColumnsByTableName(String tableName) {
        String sql = String.format("SELECT \tTABLE_NAME, COLUMN_NAME, tmp.column_comment, tmp.is_primary, IS_NULLABLE, DATA_TYPE, udt_name, CHARACTER_MAXIMUM_LENGTH LENGTH, (NUMERIC_PRECISION-NUMERIC_SCALE) PRECISIONS, NUMERIC_SCALE SCALE FROM \tinformation_schema. COLUMNS C INNER JOIN ( \tSELECT \tA .attname, col_description (A .attrelid, A .attnum) AS column_comment, ( \tCASE WHEN ( SELECT COUNT (*) FROM pg_constraint  WHERE conrelid = A .attrelid AND conkey [ 1 ]= attnum  AND contype = 'p'  ) > 0 THEN  'Y'  ELSE  'N'  END ) AS is_primary \tFROM  pg_attribute A \tINNER JOIN pg_class b ON A .attrelid = b.oid \tWHERE \t\tb.relname = '%s' \tAND A .attstattarget = '-1' ) tmp ON C . COLUMN_NAME = tmp.attname WHERE \ttable_schema = 'public' AND TABLE_NAME = '%s'", tableName, tableName);
        List list = this.jdbcTemplate.query(sql, (RowMapper)new PostgreSQLColumnMap());
        for (Column model : list) {
            model.setTableName(tableName);
        }
        return list;
    }

    private Map<String, List<Column>> getColumnsByTableName(List<String> tableNames) {
        HashMap<String, List<Column>> map = new HashMap<String, List<Column>>();
        if (tableNames != null && tableNames.size() == 0) {
            return map;
        }
        StringBuffer buf = new StringBuffer();
        for (String str : tableNames) {
            buf.append("'" + str + "',");
        }
        buf.deleteCharAt(buf.length() - 1);
        String names = buf.toString();
        String sql = String.format("SELECT \tTABLE_NAME, COLUMN_NAME, tmp.column_comment, tmp.is_primary, IS_NULLABLE, DATA_TYPE, udt_name, CHARACTER_MAXIMUM_LENGTH LENGTH, (NUMERIC_PRECISION-NUMERIC_SCALE) PRECISIONS, NUMERIC_SCALE SCALE FROM \tinformation_schema. COLUMNS C INNER JOIN ( \tSELECT \tA .attname, col_description (A .attrelid, A .attnum) AS column_comment, ( \tCASE WHEN ( SELECT COUNT (*) FROM pg_constraint  WHERE conrelid = A .attrelid AND conkey [ 1 ]= attnum  AND contype = 'p'  ) > 0 THEN  'Y'  ELSE  'N'  END ) AS is_primary \tFROM  pg_attribute A \tINNER JOIN pg_class b ON A .attrelid = b.oid \tWHERE \t\tb.relname in (%s) \tAND A .attstattarget = '-1' ) tmp ON C . COLUMN_NAME = tmp.attname WHERE \ttable_schema = 'public' AND TABLE_NAME in (%s)", names, names);
        List Columns = this.jdbcTemplate.query(sql, (RowMapper)new MySQLColumnMap());
        for (Column column : Columns) {
            String tableName = column.getTableName();
            if (map.containsKey(tableName)) {
                ((List)map.get(tableName)).add(column);
                continue;
            }
            ArrayList<Column> cols = new ArrayList<Column>();
            cols.add(column);
            map.put(tableName, cols);
        }
        return map;
    }

    public static String getComments(String comments, String defaultValue) {
        if (StringUtils.isEmpty((String)comments)) {
            return defaultValue;
        }
        int idx = comments.indexOf("InnoDB free");
        if (idx > -1) {
            comments = StringUtils.remove((String)comments.substring(0, idx).trim(), (String)";");
        }
        if (StringUtils.isEmpty((String)comments)) {
            comments = defaultValue;
        }
        return comments;
    }

    @Override
    public List<Table> getTableModelByName(String tableName) throws Exception {
        String whereClause = "";
        if (StringUtils.isNotEmpty((String)tableName)) {
            whereClause = String.format(" AND TABLE_NAME LIKE '%%%s%%'", tableName);
        }
        String sql = String.format("select relname as table_name,cast(obj_description(relfilenode,'pg_class') as varchar) as table_comment from pg_class c where relname in (select tablename from pg_tables where schemaname='public' and position('_2' in tablename)=0 %s) ORDER BY oid", whereClause);
        RowMapper<Table> rowMapper = new RowMapper<Table>(){

            public Table mapRow(ResultSet rs, int row) throws SQLException {
                DefaultTable table = new DefaultTable();
                table.setTableName(rs.getString("TABLE_NAME"));
                String comments = rs.getString("TABLE_COMMENT");
                comments = PostgreSQLTableMeta.getComments(comments, table.getTableName());
                table.setComment(comments);
                return table;
            }
        };
        List tables = this.jdbcTemplate.query(sql, (RowMapper)rowMapper);
        ArrayList<String> tableNames = new ArrayList<String>();
        for (Table model : tables) {
            tableNames.add(model.getTableName());
        }
        Map<String, List<Column>> tableColumnsMap = this.getColumnsByTableName(tableNames);
        for (Map.Entry<String, List<Column>> entry : tableColumnsMap.entrySet()) {
            for (Table model : tables) {
                if (!model.getTableName().equalsIgnoreCase(entry.getKey())) continue;
                model.setColumnList(entry.getValue());
            }
        }
        return tables;
    }

    @Override
    public String getAllTableSql() {
        return String.format(this.sqlAllTable, "");
    }

    @Override
    public List<Map<String, Object>> getTablesByNameIndex(String tableName) {
        return null;
    }
}

