/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.poi.editor;

import com.artfess.poi.ExcelContext;
import com.artfess.poi.editor.AbstractRegionEditor;
import com.artfess.poi.editor.CellEditor;
import com.artfess.poi.util.ExcelUtil;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.ss.util.CellRangeAddress;

public class ColumnEditor
extends AbstractRegionEditor<ColumnEditor> {
    private int col = 0;
    private int startRow = 0;

    public ColumnEditor(int col, int startRow, ExcelContext context) {
        super(context);
        this.col = col;
        this.startRow = startRow;
    }

    public ColumnEditor(int col, ExcelContext context) {
        this(col, 0, context);
    }

    public ColumnEditor value(Object[] rowData) {
        this.value(rowData, this.startRow);
        return this;
    }

    public ColumnEditor value(Object[] rowData, int startRow) {
        if (startRow < 0) {
            startRow = 0;
        }
        this.insertData(rowData, this.col, startRow);
        return this;
    }

    public ColumnEditor autoWidth() {
        this.workingSheet.autoSizeColumn((int)((short)this.col), false);
        this.workingSheet.setColumnWidth(this.col, this.workingSheet.getColumnWidth(this.col) + 1000);
        return this;
    }

    public ColumnEditor height(float[] heights) {
        CellEditor cellEditorLeft = this.newLeftCellEditor();
        cellEditorLeft.height(heights);
        return this;
    }

    public CellEditor cell(int row, int ... rows) {
        CellEditor cellEditor = new CellEditor(row, this.col, this.ctx);
        for (int r : rows) {
            cellEditor.add(r, this.col);
        }
        return cellEditor;
    }

    private void insertData(Object[] rowData, int col, int startRow) {
        int i = 0;
        for (Object obj : rowData) {
            CellEditor cellEditor = new CellEditor(startRow + i, col, this.ctx);
            cellEditor.value(obj);
            i = (short)(i + 1);
        }
    }

    @Override
    protected CellEditor newBottomCellEditor() {
        int lastRowNum = ExcelUtil.getLastRowNum(this.workingSheet);
        CellEditor cellEditor = new CellEditor(this.ctx);
        cellEditor.add(lastRowNum, this.col);
        return cellEditor;
    }

    @Override
    protected CellEditor newCellEditor() {
        int firstRowNum;
        CellEditor cellEditor = new CellEditor(this.ctx);
        int lastRowNum = ExcelUtil.getLastRowNum(this.workingSheet);
        for (int i = firstRowNum = this.startRow; i <= lastRowNum; ++i) {
            HSSFRow row = this.getRow(i);
            cellEditor.add(row.getRowNum(), this.col);
        }
        return cellEditor;
    }

    @Override
    protected CellEditor newLeftCellEditor() {
        return this.newCellEditor();
    }

    @Override
    protected CellEditor newRightCellEditor() {
        return this.newCellEditor();
    }

    @Override
    protected CellEditor newTopCellEditor() {
        int firstRowNum = this.startRow;
        CellEditor cellEditor = new CellEditor(this.ctx);
        cellEditor.add(firstRowNum, this.col);
        return cellEditor;
    }

    @Override
    protected CellRangeAddress getCellRange() {
        int firstRowNum = this.startRow;
        int lastRowNum = ExcelUtil.getLastRowNum(this.workingSheet);
        return new CellRangeAddress(firstRowNum, lastRowNum, this.col, this.col);
    }

    protected int getCol() {
        return this.col;
    }
}

