/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.poi.util;

import com.alibaba.fastjson.JSON;
import com.artfess.base.annotation.Excel;
import com.artfess.poi.DefaultExcelStyle;
import com.artfess.poi.style.font.BoldWeight;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.hssf.usermodel.DVConstraint;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFDataValidation;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.ss.util.CellRangeAddressList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ResourceUtils;
import org.springframework.util.StringUtils;

public class ExcelUtils<T> {
    public static final String EXCEL2003 = ".xls";
    private static final Logger log = LoggerFactory.getLogger(ExcelUtils.class);
    public Class<T> clazz;

    public ExcelUtils(Class<T> clazz) {
        this.clazz = clazz;
    }

    public List<T> importExcel(String sheetName, InputStream input) throws Exception {
        ArrayList<Object> list = new ArrayList<Object>();
        Workbook workbook = WorkbookFactory.create((InputStream)input);
        Sheet sheet = !StringUtils.isEmpty((Object)sheetName) ? workbook.getSheet(sheetName) : workbook.getSheetAt(0);
        int rows = sheet.getPhysicalNumberOfRows();
        if (rows > 0) {
            Field[] allFields = this.clazz.getDeclaredFields();
            HashMap<Integer, Field> fieldsMap = new HashMap<Integer, Field>();
            for (Field field : allFields) {
                if (!field.isAnnotationPresent(Excel.class)) continue;
                Excel attr = field.getAnnotation(Excel.class);
                int col = ExcelUtils.getExcelCol(attr.column());
                field.setAccessible(true);
                fieldsMap.put(col, field);
            }
            for (int i = 2; i < rows; ++i) {
                Row row = sheet.getRow(i);
                if (null == row) continue;
                int cellNum = sheet.getRow(0).getPhysicalNumberOfCells();
                Object entity = null;
                for (int j = 0; j < cellNum; ++j) {
                    Cell cell = row.getCell(j);
                    if (cell == null) continue;
                    row.getCell(j).setCellType(CellType.STRING);
                    cell = row.getCell(j);
                    String c = cell.getStringCellValue();
                    if (StringUtils.isEmpty((Object)c) || "NULL".equals(c)) continue;
                    entity = entity == null ? (Object)this.clazz.newInstance() : entity;
                    Field field = (Field)fieldsMap.get(j);
                    if (null == field) continue;
                    Class<?> fieldType = field.getType();
                    if (String.class == fieldType) {
                        field.set(entity, String.valueOf(c).trim());
                        continue;
                    }
                    if (Integer.TYPE == fieldType || Integer.class == fieldType) {
                        field.set(entity, Integer.parseInt(c));
                        continue;
                    }
                    if (Long.TYPE == fieldType || Long.class == fieldType) {
                        field.set(entity, Long.valueOf(c));
                        continue;
                    }
                    if (Float.TYPE == fieldType || Float.class == fieldType) {
                        field.set(entity, Float.valueOf(c));
                        continue;
                    }
                    if (Short.TYPE == fieldType || Short.class == fieldType) {
                        field.set(entity, Short.valueOf(c));
                        continue;
                    }
                    if (Double.TYPE == fieldType || Double.class == fieldType) {
                        field.set(entity, Double.valueOf(c));
                        continue;
                    }
                    if (Character.TYPE == fieldType) {
                        if (c == null || c.length() <= 0) continue;
                        field.set(entity, Character.valueOf(c.charAt(0)));
                        continue;
                    }
                    if (cell.getCellType() == CellType.NUMERIC) {
                        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                        cell.setCellValue(sdf.format(cell.getNumericCellValue()));
                        c = sdf.format(cell.getNumericCellValue());
                        field.set(entity, LocalDate.parse(c));
                        continue;
                    }
                    if (BigDecimal.class != fieldType) continue;
                    c = cell.getStringCellValue();
                    field.set(entity, new BigDecimal(c));
                }
                if (entity == null) continue;
                try {
                    list.add(entity);
                    continue;
                }
                catch (Exception e) {
                    log.error("\u5bfc\u5165\u5931\u8d25\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a{},\u6570\u636e\u4fe1\u606f\uff1a{}", (Object)e.getMessage(), JSON.toJSON(entity));
                }
            }
        }
        return list;
    }

    public void exportExcel(HttpServletResponse response, HttpServletRequest request, List<T> list, String sheetName) {
        try {
            HSSFWorkbook workbook = this.createHssfWorkbook(response, request, list, sheetName);
            String filename = this.encodingFilename(sheetName);
            this.downloadExcel(workbook, filename, response);
        }
        catch (Exception e) {
            log.error("\u5173\u95edflush\u5931\u8d25{}", (Throwable)e);
        }
    }

    private HSSFWorkbook createHssfWorkbook(HttpServletResponse response, HttpServletRequest request, List<T> list, String sheetName) {
        Field[] allFields = this.clazz.getDeclaredFields();
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Field field : allFields) {
            if (!field.isAnnotationPresent(Excel.class)) continue;
            fields.add(field);
        }
        HSSFWorkbook workbook = new HSSFWorkbook();
        int sheetSize = 65536;
        double sheetNo = Math.ceil(list.size() / sheetSize);
        int index = 0;
        while ((double)index <= sheetNo) {
            HSSFSheet sheet = workbook.createSheet();
            sheet.createFreezePane(0, 1, 0, 1);
            if (sheetNo == 0.0) {
                workbook.setSheetName(index, sheetName);
            } else {
                workbook.setSheetName(index, sheetName + index);
            }
            HSSFRow row = sheet.createRow(0);
            HSSFCell cell = row.createCell(0);
            for (int i = 0; i < fields.size(); ++i) {
                HSSFFont font;
                Field field = (Field)fields.get(i);
                Excel attr = field.getAnnotation(Excel.class);
                int col = ExcelUtils.getExcelCol(attr.column());
                cell = row.createCell(col);
                cell.setCellType(CellType.STRING);
                HSSFCellStyle cellStyle = workbook.createCellStyle();
                cellStyle.setAlignment(HorizontalAlignment.CENTER);
                cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
                if (attr.name().indexOf("\u6ce8\uff1a") >= 0) {
                    font = workbook.createFont();
                    font.setColor((short)10);
                    cellStyle.setFont(font);
                    cellStyle.setFillForegroundColor(HSSFColor.HSSFColorPredefined.YELLOW.getIndex());
                    sheet.setColumnWidth(i, 6000);
                } else {
                    font = workbook.createFont();
                    font.setBold(BoldWeight.BOLD.getWeight());
                    cellStyle.setFont(font);
                    cellStyle.setFillForegroundColor(HSSFColor.HSSFColorPredefined.YELLOW.getIndex());
                    sheet.setColumnWidth(i, 3766);
                }
                DefaultExcelStyle defaultExcelStyle = new DefaultExcelStyle();
                cellStyle.setFillPattern(defaultExcelStyle.getFillPattern());
                cellStyle.setWrapText(true);
                cell.setCellStyle(cellStyle);
                cell.setCellValue(attr.name());
                if (!attr.prompt().trim().equals("")) {
                    ExcelUtils.setHSSFPrompt(sheet, "", attr.prompt(), 1, 100, col, col);
                }
                if (attr.combo().length <= 0) continue;
                ExcelUtils.setHSSFValidation(sheet, attr.combo(), 1, 100, col, col);
            }
            int startNo = index * sheetSize;
            int endNo = Math.min(startNo + sheetSize, list.size());
            HSSFCellStyle cs = workbook.createCellStyle();
            cs.setAlignment(HorizontalAlignment.CENTER);
            cs.setVerticalAlignment(VerticalAlignment.CENTER);
            for (int i = startNo; i < endNo; ++i) {
                row = sheet.createRow(i + 1 - startNo);
                T vo = list.get(i);
                for (int j = 0; j < fields.size(); ++j) {
                    Field field = (Field)fields.get(j);
                    field.setAccessible(true);
                    Excel attr = field.getAnnotation(Excel.class);
                    try {
                        if (!attr.isExport()) continue;
                        cell = row.createCell(ExcelUtils.getExcelCol(attr.column()));
                        cell.setCellStyle(cs);
                        try {
                            if (String.valueOf(field.get(vo)).length() > 10) {
                                throw new Exception("\u957f\u5ea6\u8d85\u8fc710\u4f4d\u5c31\u4e0d\u7528\u8f6c\u6570\u5b57\u4e86");
                            }
                            BigDecimal bc = new BigDecimal(String.valueOf(field.get(vo)));
                            cell.setCellType(CellType.NUMERIC);
                            cell.setCellType(CellType.STRING);
                            cell.setCellValue(bc.doubleValue());
                        }
                        catch (Exception e) {
                            cell.setCellType(CellType.STRING);
                            if (vo == null) {
                                cell.setCellValue("");
                                continue;
                            }
                            cell.setCellValue(field.get(vo) == null ? "" : String.valueOf(field.get(vo)));
                        }
                        continue;
                    }
                    catch (Exception e) {
                        log.error("\u5bfc\u51faExcel\u5931\u8d25{}", (Throwable)e);
                    }
                }
            }
            ++index;
        }
        return workbook;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downloadExcel(HSSFWorkbook workBook, String fileName, HttpServletResponse response) throws IOException {
        String filedisplay = URLEncoder.encode(fileName, "utf-8");
        response.setContentType("APPLICATION/OCTET-STREAM");
        response.setHeader("Access-Control-Expose-Headers", "Content-Disposition");
        response.addHeader("Content-Disposition", "attachment;filename=" + filedisplay);
        response.addHeader("filename", filedisplay);
        try (ServletOutputStream os = null;){
            os = response.getOutputStream();
            workBook.write((OutputStream)os);
            os.flush();
            os.close();
        }
    }

    public static int getExcelCol(String col) {
        col = col.toUpperCase();
        int count = -1;
        char[] cs = col.toCharArray();
        for (int i = 0; i < cs.length; ++i) {
            count = (int)((double)count + (double)(cs[i] - 64) * Math.pow(26.0, cs.length - 1 - i));
        }
        return count;
    }

    public static HSSFSheet setHSSFPrompt(HSSFSheet sheet, String promptTitle, String promptContent, int firstRow, int endRow, int firstCol, int endCol) {
        DVConstraint constraint = DVConstraint.createCustomFormulaConstraint((String)"DD1");
        CellRangeAddressList regions = new CellRangeAddressList(firstRow, endRow, firstCol, endCol);
        HSSFDataValidation data_validation_view = new HSSFDataValidation(regions, (DataValidationConstraint)constraint);
        data_validation_view.createPromptBox(promptTitle, promptContent);
        sheet.addValidationData((DataValidation)data_validation_view);
        return sheet;
    }

    public static HSSFSheet setHSSFValidation(HSSFSheet sheet, String[] textlist, int firstRow, int endRow, int firstCol, int endCol) {
        DVConstraint constraint = DVConstraint.createExplicitListConstraint((String[])textlist);
        CellRangeAddressList regions = new CellRangeAddressList(firstRow, endRow, firstCol, endCol);
        HSSFDataValidation data_validation_list = new HSSFDataValidation(regions, (DataValidationConstraint)constraint);
        sheet.addValidationData((DataValidation)data_validation_list);
        return sheet;
    }

    public String encodingFilename(String filename) {
        Date now = new Date();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        filename = filename + "_" + dateFormat.format(now) + EXCEL2003;
        return filename;
    }

    public String getfile() throws FileNotFoundException {
        return ResourceUtils.getURL((String)"classpath:").getPath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getByte(HttpServletResponse response, HttpServletRequest request, List<T> list, String fileName) {
        HSSFWorkbook workbook = this.createHssfWorkbook(response, request, list, fileName);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            workbook.write((OutputStream)bos);
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                bos.close();
                workbook.close();
            }
            catch (IOException iOException) {}
        }
        byte[] bytes = bos.toByteArray();
        return bytes;
    }

    public List<T> importQuestionExcel(String sheetName, InputStream input) throws Exception {
        ArrayList<Object> list = new ArrayList<Object>();
        Workbook workbook = WorkbookFactory.create((InputStream)input);
        Sheet sheet = !StringUtils.isEmpty((Object)sheetName) ? workbook.getSheet(sheetName) : workbook.getSheetAt(0);
        int rows = sheet.getPhysicalNumberOfRows();
        if (rows > 0) {
            Field[] allFields = this.clazz.getDeclaredFields();
            HashMap<Integer, Field> fieldsMap = new HashMap<Integer, Field>();
            for (Field field : allFields) {
                if (!field.isAnnotationPresent(Excel.class)) continue;
                Excel attr = field.getAnnotation(Excel.class);
                int col = ExcelUtils.getExcelCol(attr.column());
                field.setAccessible(true);
                fieldsMap.put(col, field);
            }
            for (int i = 2; i < rows; ++i) {
                Row row = sheet.getRow(i);
                if (null == row) continue;
                int cellNum = sheet.getRow(0).getPhysicalNumberOfCells();
                Object entity = null;
                for (int j = 0; j < cellNum; ++j) {
                    Cell cell = row.getCell(j);
                    if (cell == null) continue;
                    row.getCell(j).setCellType(CellType.STRING);
                    cell = row.getCell(j);
                    String c = cell.getStringCellValue();
                    if (StringUtils.isEmpty((Object)c) || "NULL".equals(c)) continue;
                    entity = entity == null ? (Object)this.clazz.newInstance() : entity;
                    Field field = (Field)fieldsMap.get(j);
                    if (null == field) continue;
                    Class<?> fieldType = field.getType();
                    if (String.class == fieldType) {
                        field.set(entity, String.valueOf(c).trim());
                        continue;
                    }
                    if (Integer.TYPE == fieldType || Integer.class == fieldType) {
                        field.set(entity, Integer.parseInt(c));
                        continue;
                    }
                    if (Long.TYPE == fieldType || Long.class == fieldType) {
                        field.set(entity, Long.valueOf(c));
                        continue;
                    }
                    if (Float.TYPE == fieldType || Float.class == fieldType) {
                        field.set(entity, Float.valueOf(c));
                        continue;
                    }
                    if (Short.TYPE == fieldType || Short.class == fieldType) {
                        field.set(entity, Short.valueOf(c));
                        continue;
                    }
                    if (Double.TYPE == fieldType || Double.class == fieldType) {
                        field.set(entity, Double.valueOf(c));
                        continue;
                    }
                    if (Character.TYPE == fieldType) {
                        if (c == null || c.length() <= 0) continue;
                        field.set(entity, Character.valueOf(c.charAt(0)));
                        continue;
                    }
                    if (cell.getCellType() == CellType.NUMERIC) {
                        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                        cell.setCellValue(sdf.format(cell.getNumericCellValue()));
                        c = sdf.format(cell.getNumericCellValue());
                        field.set(entity, LocalDate.parse(c));
                        continue;
                    }
                    if (BigDecimal.class != fieldType) continue;
                    c = cell.getStringCellValue();
                    field.set(entity, new BigDecimal(c));
                }
                if (entity == null) continue;
                try {
                    list.add(entity);
                    continue;
                }
                catch (Exception e) {
                    log.error("\u5bfc\u5165\u5931\u8d25\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a{},\u6570\u636e\u4fe1\u606f\uff1a{}", (Object)e.getMessage(), JSON.toJSON(entity));
                }
            }
        }
        return list;
    }
}

