/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.file.util;

import com.artfess.base.exception.BaseException;
import com.artfess.file.util.ConverterUtils;
import com.artofsolving.jodconverter.openoffice.connection.OpenOfficeConnection;
import com.artofsolving.jodconverter.openoffice.connection.SocketOpenOfficeConnection;
import com.artofsolving.jodconverter.openoffice.converter.StreamOpenOfficeDocumentConverter;
import java.io.File;
import java.net.ConnectException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.io.FilenameUtils;
import org.artofsolving.jodconverter.OfficeDocumentConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class OfficeToPdf {
    private static final Logger log = LoggerFactory.getLogger(OfficeToPdf.class);
    @Value(value="${file.office.ip-addr}")
    String ipAddr;
    @Value(value="${file.office.port:9193}")
    String port;
    @Resource
    ConverterUtils converterUtils;

    public boolean openOfficeToPDF(String inputFilePath, String outputFilePath) {
        return this.office2pdf(inputFilePath, outputFilePath);
    }

    public boolean openOfficeToPDF(String inputFilePath, String outputFilePath, boolean remoteStatus) {
        if (remoteStatus) {
            return this.office2pdf(inputFilePath, outputFilePath);
        }
        return this.localOffice2pdf(inputFilePath, outputFilePath);
    }

    public void converterFile(File inputFile, String outputFilePath_end, String inputFilePath, String outputFilePath) {
        File outputFile = new File(outputFilePath_end);
        if (!outputFile.exists()) {
            outputFile.getParentFile().mkdirs();
        }
        String[] portsArray = this.port.split(",");
        List portList = Arrays.stream(portsArray).map(String::trim).filter(s -> !s.isEmpty()).map(Integer::parseInt).collect(Collectors.toList());
        Collections.shuffle(portList);
        boolean isConnected = false;
        Iterator iterator = portList.iterator();
        while (iterator.hasNext()) {
            int port = (Integer)iterator.next();
            try {
                log.info("\u5c1d\u8bd5\u8fde\u63a5 OpenOffice \u670d\u52a1\uff0cIP: {}, \u7aef\u53e3: {}", (Object)this.ipAddr, (Object)port);
                SocketOpenOfficeConnection connection = new SocketOpenOfficeConnection(this.ipAddr, port);
                connection.connect();
                StreamOpenOfficeDocumentConverter converter = new StreamOpenOfficeDocumentConverter((OpenOfficeConnection)connection);
                converter.convert(inputFile, outputFile);
                isConnected = true;
                break;
            }
            catch (ConnectException e) {
                log.warn("\u8fde\u63a5\u7aef\u53e3\u5931\u8d25\uff1a{}", (Object)port);
            }
            catch (Exception e) {
                log.error("\u8f6c\u6362\u51fa\u9519\uff0c\u7aef\u53e3\uff1a{}", (Object)port, (Object)e);
            }
        }
        if (!isConnected) {
            throw new BaseException("\u672a\u80fd\u8fde\u63a5\u5230\u4efb\u4f55\u53ef\u7528\u7684 OpenOffice \u7aef\u53e3.");
        }
    }

    public boolean office2pdf(String inputFilePath, String outputFilePath) {
        boolean flag = false;
        if (null != inputFilePath) {
            File inputFile = new File(inputFilePath);
            if (null == outputFilePath) {
                String outputFilePath_end = OfficeToPdf.getOutputFilePath(inputFilePath);
                if (inputFile.exists()) {
                    this.converterFile(inputFile, outputFilePath_end, inputFilePath, outputFilePath);
                    flag = true;
                }
            } else if (inputFile.exists()) {
                this.converterFile(inputFile, outputFilePath, inputFilePath, outputFilePath);
                flag = true;
            }
        } else {
            flag = false;
        }
        return flag;
    }

    public static void converterFile(File inputFile, String outputFilePath_end, String inputFilePath, String outputFilePath, OfficeDocumentConverter converter) {
        File outputFile = new File(outputFilePath_end);
        if (!outputFile.exists()) {
            outputFile.getParentFile().mkdirs();
        }
        String outputExtension = FilenameUtils.getExtension((String)outputFile.getName());
        try {
            converter.convert(inputFile, outputFile);
        }
        catch (NullPointerException e) {
            throw new BaseException("\u672a\u627e\u5230\u670d\u52a1\u7aef\u7684\u9644\u4ef6\u9884\u89c8\u7ec4\u4ef6.", (Throwable)e);
        }
    }

    public boolean localOffice2pdf(String inputFilePath, String outputFilePath) {
        boolean flag = false;
        OfficeDocumentConverter converter = this.converterUtils.getDocumentConverter();
        if (null != inputFilePath) {
            File inputFile = new File(inputFilePath);
            if (null == outputFilePath) {
                String outputFilePath_end = OfficeToPdf.getOutputFilePath(inputFilePath);
                if (inputFile.exists()) {
                    OfficeToPdf.converterFile(inputFile, outputFilePath_end, inputFilePath, outputFilePath, converter);
                    flag = true;
                }
            } else if (inputFile.exists()) {
                OfficeToPdf.converterFile(inputFile, outputFilePath, inputFilePath, outputFilePath, converter);
                flag = true;
            }
        } else {
            flag = false;
        }
        return flag;
    }

    public static String getOutputFilePath(String inputFilePath) {
        String outputFilePath = inputFilePath.replaceAll("." + OfficeToPdf.getPostfix(inputFilePath), ".pdf");
        return outputFilePath;
    }

    public static String getPostfix(String inputFilePath) {
        return inputFilePath.substring(inputFilePath.lastIndexOf(".") + 1);
    }
}

