/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.file.util;

import com.artfess.base.exception.BaseException;
import com.artfess.base.util.CommonUtil;
import com.artfess.base.util.StringUtil;
import io.minio.BucketExistsArgs;
import io.minio.GetObjectArgs;
import io.minio.GetObjectResponse;
import io.minio.GetPresignedObjectUrlArgs;
import io.minio.MakeBucketArgs;
import io.minio.MinioClient;
import io.minio.PutObjectArgs;
import io.minio.RemoveObjectArgs;
import io.minio.errors.ErrorResponseException;
import io.minio.errors.InsufficientDataException;
import io.minio.errors.InternalException;
import io.minio.errors.InvalidResponseException;
import io.minio.errors.ServerException;
import io.minio.errors.XmlParserException;
import io.minio.http.Method;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.time.LocalDate;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;

public class MinioUtil {
    private static final Logger log = LoggerFactory.getLogger(MinioUtil.class);
    private static String fileDownUrl = "http://192.168.0.11:8155/bizAccessory/v1//minIoDown?name={name}&bizPath=default";
    private static String minioUrl;
    private static String minioName;
    private static String minioPass;
    private static String bucketName;
    private static MinioClient minioClient;

    public static void setMinioUrl(String minioUrl) {
        MinioUtil.minioUrl = minioUrl;
    }

    public static void setMinioName(String minioName) {
        MinioUtil.minioName = minioName;
    }

    public static void setMinioPass(String minioPass) {
        MinioUtil.minioPass = minioPass;
    }

    public static void setBucketName(String bucketName) {
        MinioUtil.bucketName = bucketName;
    }

    public static String getMinioUrl() {
        return minioUrl;
    }

    public static String getBucketName() {
        return bucketName;
    }

    public static String uploadRelative(MultipartFile file, String bizPath, String fileName, String customBucket) throws Exception {
        String file_url = "";
        String newBucket = bucketName;
        if (StringUtil.isNotEmpty((String)customBucket)) {
            newBucket = customBucket;
        }
        BucketExistsArgs bucketExistsArgs = (BucketExistsArgs)((BucketExistsArgs.Builder)BucketExistsArgs.builder().bucket(newBucket)).build();
        MinioUtil.initMinio(minioUrl, minioName, minioPass);
        if (minioClient.bucketExists(bucketExistsArgs)) {
            log.info("Bucket already exists.");
        } else {
            MakeBucketArgs makeBucketArgs = (MakeBucketArgs)((MakeBucketArgs.Builder)MakeBucketArgs.builder().bucket(newBucket)).build();
            minioClient.makeBucket(makeBucketArgs);
            log.info("create a new bucket as \u3010" + newBucket + "\u3011\uff01");
        }
        InputStream stream = file.getInputStream();
        String objectName = "";
        if (StringUtils.isEmpty((CharSequence)fileName)) {
            String orgName = file.getOriginalFilename();
            orgName = CommonUtil.getFileName((String)orgName);
            if (!bizPath.endsWith("/")) {
                bizPath = bizPath.concat("/");
            }
            objectName = bizPath + orgName.substring(0, orgName.lastIndexOf(".")) + "_" + System.currentTimeMillis() + orgName.substring(orgName.indexOf("."));
        } else {
            if (fileName.startsWith("/")) {
                fileName = fileName.substring(1);
            }
            if (!bizPath.endsWith("/")) {
                bizPath = bizPath.concat("/");
            }
            objectName = bizPath + fileName;
        }
        if (objectName.startsWith("/")) {
            objectName = objectName.substring(1);
        }
        PutObjectArgs putObjectArgs = (PutObjectArgs)((PutObjectArgs.Builder)((PutObjectArgs.Builder)PutObjectArgs.builder().bucket(newBucket)).object(objectName)).stream(stream, (long)stream.available(), -1L).contentType(file.getContentType()).build();
        minioClient.putObject(putObjectArgs);
        stream.close();
        if (!minioUrl.endsWith("/")) {
            minioUrl = minioUrl.concat("/");
        }
        if (!newBucket.endsWith("/")) {
            newBucket = newBucket.concat("/");
        }
        if (newBucket.startsWith("/")) {
            newBucket = newBucket.substring(1);
        }
        file_url = newBucket + objectName;
        return file_url;
    }

    public static String getMinIoUrl(String bizPath, String fileName) {
        String newBucket = bucketName;
        String objectName = bizPath + "/" + fileName.substring(0, fileName.lastIndexOf(".")) + fileName.substring(fileName.indexOf("."));
        if (!newBucket.endsWith("/")) {
            newBucket = newBucket.concat("/");
        }
        if (newBucket.startsWith("/")) {
            newBucket = newBucket.substring(1);
        }
        String url = fileDownUrl.replace("{name}", fileName);
        return url;
    }

    public static InputStream getInputSteam(String customBucket, String fileName, boolean isRelative) {
        GetObjectResponse inputStream = null;
        try {
            MinioUtil.initMinio(minioUrl, minioName, minioPass);
            String newBucket = bucketName;
            if (StringUtil.isNotEmpty((String)customBucket)) {
                newBucket = customBucket;
            }
            if (!isRelative) {
                fileName = fileName.replace(minioUrl, "");
                fileName = fileName.replace(newBucket, "");
            }
            inputStream = minioClient.getObject((GetObjectArgs)((GetObjectArgs.Builder)((GetObjectArgs.Builder)GetObjectArgs.builder().bucket("gyl")).object(fileName)).build());
        }
        catch (Exception e) {
            log.info("\u6587\u4ef6\u83b7\u53d6\u5931\u8d25" + e.getMessage());
            return inputStream;
        }
        return inputStream;
    }

    public static String ipUpload(MultipartFile file, String bizPath, String fileName, String customBucket) throws Exception {
        String file_url = "";
        String newBucket = bucketName;
        if (StringUtil.isNotEmpty((String)customBucket)) {
            newBucket = customBucket;
        }
        MinioUtil.initMinio(minioUrl, minioName, minioPass);
        BucketExistsArgs bucketExistsArgs = (BucketExistsArgs)((BucketExistsArgs.Builder)BucketExistsArgs.builder().bucket(newBucket)).build();
        if (minioClient.bucketExists(bucketExistsArgs)) {
            log.info("Bucket already exists.");
        } else {
            MakeBucketArgs makeBucketArgs = (MakeBucketArgs)((MakeBucketArgs.Builder)MakeBucketArgs.builder().bucket(newBucket)).build();
            minioClient.makeBucket(makeBucketArgs);
            log.info("create a new bucket as \u3010" + newBucket + "\u3011\uff01");
        }
        InputStream stream = file.getInputStream();
        String objectName = "";
        if (StringUtils.isEmpty((CharSequence)fileName)) {
            String orgName = file.getOriginalFilename();
            orgName = CommonUtil.getFileName((String)orgName);
            if (!bizPath.endsWith("/")) {
                bizPath = bizPath.concat("/");
            }
            objectName = bizPath + orgName.substring(0, orgName.lastIndexOf(".")) + "_" + System.currentTimeMillis() + orgName.substring(orgName.indexOf("."));
        } else {
            if (fileName.startsWith("/")) {
                fileName = fileName.substring(1);
            }
            if (!bizPath.endsWith("/")) {
                bizPath = bizPath.concat("/");
            }
            objectName = bizPath + fileName;
        }
        if (objectName.startsWith("/")) {
            objectName = objectName.substring(1);
        }
        PutObjectArgs putObjectArgs = (PutObjectArgs)((PutObjectArgs.Builder)((PutObjectArgs.Builder)PutObjectArgs.builder().bucket(newBucket)).object(objectName)).stream(stream, (long)stream.available(), -1L).contentType(file.getContentType()).build();
        minioClient.putObject(putObjectArgs);
        stream.close();
        if (!minioUrl.endsWith("/")) {
            minioUrl = minioUrl.concat("/");
        }
        if (!newBucket.endsWith("/")) {
            newBucket = newBucket.concat("/");
        }
        if (newBucket.startsWith("/")) {
            newBucket = newBucket.substring(1);
        }
        file_url = minioUrl + newBucket + objectName;
        return file_url;
    }

    public static String upload(MultipartFile file, String bizPath, String fileName, String customBucket) throws Exception {
        String file_url = "";
        String newBucket = bucketName;
        if (StringUtil.isNotEmpty((String)customBucket)) {
            newBucket = customBucket;
        }
        MinioUtil.initMinio(minioUrl, minioName, minioPass);
        BucketExistsArgs bucketExistsArgs = (BucketExistsArgs)((BucketExistsArgs.Builder)BucketExistsArgs.builder().bucket(newBucket)).build();
        if (minioClient.bucketExists(bucketExistsArgs)) {
            log.info("Bucket already exists.");
        } else {
            MakeBucketArgs makeBucketArgs = (MakeBucketArgs)((MakeBucketArgs.Builder)MakeBucketArgs.builder().bucket(newBucket)).build();
            minioClient.makeBucket(makeBucketArgs);
            log.info("create a new bucket as \u3010" + newBucket + "\u3011\uff01");
        }
        InputStream stream = file.getInputStream();
        String objectName = "";
        if (StringUtils.isEmpty((CharSequence)fileName)) {
            String orgName = file.getOriginalFilename();
            orgName = CommonUtil.getFileName((String)orgName);
            if (!bizPath.endsWith("/")) {
                bizPath = bizPath.concat("/");
            }
            objectName = bizPath + orgName.substring(0, orgName.lastIndexOf(".")) + "_" + System.currentTimeMillis() + orgName.substring(orgName.indexOf("."));
        } else {
            if (fileName.startsWith("/")) {
                fileName = fileName.substring(1);
            }
            if (!bizPath.endsWith("/")) {
                bizPath = bizPath.concat("/");
            }
            objectName = bizPath + fileName;
        }
        if (objectName.startsWith("/")) {
            objectName = objectName.substring(1);
        }
        PutObjectArgs putObjectArgs = (PutObjectArgs)((PutObjectArgs.Builder)((PutObjectArgs.Builder)PutObjectArgs.builder().bucket(newBucket)).object(objectName)).stream(stream, (long)stream.available(), -1L).contentType(file.getContentType()).build();
        minioClient.putObject(putObjectArgs);
        stream.close();
        if (!newBucket.endsWith("/")) {
            newBucket = newBucket.concat("/");
        }
        file_url = newBucket + objectName;
        return file_url;
    }

    public static String uploadByInputStream(InputStream stream, String relativePath, String customBucket) throws Exception {
        LocalDate now = LocalDate.now();
        String newBucket = bucketName;
        if (StringUtil.isNotEmpty((String)customBucket)) {
            newBucket = customBucket;
        }
        MinioUtil.initMinio(minioUrl, minioName, minioPass);
        BucketExistsArgs bucketExistsArgs = (BucketExistsArgs)((BucketExistsArgs.Builder)BucketExistsArgs.builder().bucket(newBucket)).build();
        if (minioClient.bucketExists(bucketExistsArgs)) {
            log.info("Bucket already exists.");
        } else {
            MakeBucketArgs makeBucketArgs = (MakeBucketArgs)((MakeBucketArgs.Builder)MakeBucketArgs.builder().bucket(newBucket)).build();
            minioClient.makeBucket(makeBucketArgs);
            log.info("create a new bucket as \u3010" + newBucket + "\u3011\uff01");
        }
        PutObjectArgs putObjectArgs = (PutObjectArgs)((PutObjectArgs.Builder)((PutObjectArgs.Builder)PutObjectArgs.builder().bucket(newBucket)).object(relativePath)).stream(stream, (long)stream.available(), -1L).contentType("application/octet-stream").build();
        minioClient.putObject(putObjectArgs);
        stream.close();
        return minioUrl + newBucket + "/" + relativePath;
    }

    public static String uploadByInputStream(InputStream stream, String relativePath) throws Exception {
        return MinioUtil.uploadByInputStream(stream, relativePath, bucketName);
    }

    public static String upload(MultipartFile file, String bizPath) throws Exception {
        return MinioUtil.upload(file, bizPath, null, null);
    }

    public static String upload(MultipartFile file, String bizPath, String fileName) throws Exception {
        return MinioUtil.upload(file, bizPath, fileName, null);
    }

    public static InputStream getMinioFile(String customBucket, String filePath, boolean isRelative) {
        GetObjectResponse inputStream = null;
        try {
            MinioUtil.initMinio(minioUrl, minioName, minioPass);
            String newBucket = bucketName;
            if (StringUtil.isNotEmpty((String)customBucket)) {
                newBucket = customBucket;
            }
            if (!isRelative) {
                filePath = filePath.replace(minioUrl, "");
                filePath = filePath.replace(newBucket, "");
            }
            GetObjectArgs getObjectArgs = (GetObjectArgs)((GetObjectArgs.Builder)((GetObjectArgs.Builder)GetObjectArgs.builder().bucket(newBucket)).object(filePath)).build();
            inputStream = minioClient.getObject(getObjectArgs);
        }
        catch (Exception e) {
            log.error("\u6587\u4ef6\u83b7\u53d6\u5931\u8d25" + e.getMessage());
        }
        return inputStream;
    }

    public static InputStream getMinioFile(String filePath, boolean isRelative) {
        return MinioUtil.getMinioFile(bucketName, filePath, isRelative);
    }

    public static void removeObject(String customBucket, String fileName, boolean isRelative) {
        try {
            MinioUtil.initMinio(minioUrl, minioName, minioPass);
            String newBucket = bucketName;
            if (StringUtil.isNotEmpty((String)customBucket)) {
                newBucket = customBucket;
            }
            if (!isRelative) {
                if (!minioUrl.endsWith("/")) {
                    minioUrl = minioUrl.concat("/");
                }
                if (newBucket.startsWith("/")) {
                    newBucket = newBucket.substring(1);
                }
                fileName = fileName.replace(minioUrl + newBucket, "");
            }
            RemoveObjectArgs removeObjectsArgs = (RemoveObjectArgs)((RemoveObjectArgs.Builder)((RemoveObjectArgs.Builder)RemoveObjectArgs.builder().bucket(bucketName)).object(fileName)).build();
            minioClient.removeObject(removeObjectsArgs);
        }
        catch (Exception e) {
            log.error("\u6587\u4ef6\u5220\u9664\u5931\u8d25" + e.getMessage());
        }
    }

    public static void removeObject(String fileName, boolean isRelative) {
        MinioUtil.removeObject(bucketName, fileName, isRelative);
    }

    public static boolean downFile(String customBucket, String fileName, OutputStream out, boolean isRelative) {
        GetObjectResponse inputStream = null;
        try {
            int len;
            MinioUtil.initMinio(minioUrl, minioName, minioPass);
            String newBucket = bucketName;
            if (StringUtil.isNotEmpty((String)customBucket)) {
                newBucket = customBucket;
            }
            if (!isRelative) {
                fileName = fileName.replace(minioUrl, "");
                fileName = fileName.replace(newBucket, "");
            }
            GetObjectArgs getObjectArgs = (GetObjectArgs)((GetObjectArgs.Builder)((GetObjectArgs.Builder)GetObjectArgs.builder().bucket(newBucket)).object(fileName)).build();
            inputStream = minioClient.getObject(getObjectArgs);
            byte[] b = new byte[0x100000];
            while ((len = inputStream.read(b)) != -1) {
                out.write(b, 0, len);
            }
            out.close();
            inputStream.close();
        }
        catch (Exception e) {
            log.error("\u6587\u4ef6\u83b7\u53d6\u5931\u8d25" + e.getMessage());
            return false;
        }
        return true;
    }

    public static String getPresignedObjectUrl2upload(String filePath) {
        String objectUrl = null;
        MinioUtil.initMinio(minioUrl, minioName, minioPass);
        GetPresignedObjectUrlArgs getPresignedObjectUrlArgs = (GetPresignedObjectUrlArgs)((GetPresignedObjectUrlArgs.Builder)((GetPresignedObjectUrlArgs.Builder)GetPresignedObjectUrlArgs.builder().method(Method.GET).bucket(bucketName)).object(filePath)).expiry(600).build();
        try {
            objectUrl = minioClient.getPresignedObjectUrl(getPresignedObjectUrlArgs);
        }
        catch (ErrorResponseException e) {
            e.printStackTrace();
        }
        catch (InsufficientDataException e) {
            e.printStackTrace();
        }
        catch (InternalException e) {
            e.printStackTrace();
        }
        catch (InvalidKeyException e) {
            e.printStackTrace();
        }
        catch (InvalidResponseException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (XmlParserException e) {
            e.printStackTrace();
        }
        catch (ServerException e) {
            e.printStackTrace();
        }
        return objectUrl;
    }

    public static boolean checkFile(String customBucket, String fileName, boolean isRelative) {
        GetObjectResponse inputStream = null;
        try {
            int len;
            MinioUtil.initMinio(minioUrl, minioName, minioPass);
            String newBucket = bucketName;
            if (StringUtil.isNotEmpty((String)customBucket)) {
                newBucket = customBucket;
            }
            if (!isRelative) {
                fileName = fileName.replace(minioUrl, "");
                fileName = fileName.replace(newBucket, "");
            }
            GetObjectArgs getObjectArgs = (GetObjectArgs)((GetObjectArgs.Builder)((GetObjectArgs.Builder)GetObjectArgs.builder().bucket(newBucket)).object(fileName)).build();
            inputStream = minioClient.getObject(getObjectArgs);
            int byteCount = 0;
            byte[] b = new byte[1024];
            while ((len = inputStream.read(b)) != -1) {
                byteCount += byteCount;
            }
            inputStream.close();
            return byteCount > 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("\u6587\u4ef6\u83b7\u53d6\u5931\u8d25" + e.getMessage());
            return false;
        }
    }

    private static MinioClient initMinio(String minioUrl, String minioName, String minioPass) {
        if (minioClient == null) {
            minioClient = MinioClient.builder().endpoint(minioUrl).credentials(minioName, minioPass).build();
        }
        return minioClient;
    }

    public static String previewFile(String bucketName, String fileName, Integer expires, Map<String, String> reqParams) {
        MinioUtil.initMinio(minioUrl, minioName, minioPass);
        if (null == expires) {
            expires = 86400;
        }
        if (StringUtils.isBlank((CharSequence)bucketName)) {
            bucketName = MinioUtil.getBucketName();
        }
        if (StringUtils.isBlank((CharSequence)fileName)) {
            throw new BaseException("\u6587\u4ef6\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        GetPresignedObjectUrlArgs args = (GetPresignedObjectUrlArgs)((GetPresignedObjectUrlArgs.Builder)((GetPresignedObjectUrlArgs.Builder)GetPresignedObjectUrlArgs.builder().method(Method.GET).bucket(bucketName)).object(fileName)).expiry(expires.intValue()).build();
        try {
            return minioClient.getPresignedObjectUrl(args);
        }
        catch (Exception e) {
            throw new BaseException("\u8bbf\u95eeminio\u51fa\u73b0\u5f02\u5e38");
        }
    }

    static {
        minioClient = null;
    }
}

