/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.file.persistence.manager.impl;

import cn.hutool.core.date.DateUnit;
import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSONObject;
import com.artfess.base.attachment.Attachment;
import com.artfess.base.attachment.AttachmentService;
import com.artfess.base.attachment.AttachmentServiceFactory;
import com.artfess.base.constants.CodePrefix;
import com.artfess.base.context.BaseContext;
import com.artfess.base.enums.FileTypeEnum;
import com.artfess.base.exception.ApplicationException;
import com.artfess.base.exception.BaseException;
import com.artfess.base.exception.RequiredException;
import com.artfess.base.feign.UCFeignService;
import com.artfess.base.handler.MultiTenantHandler;
import com.artfess.base.handler.MultiTenantIgnoreResult;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.model.CommonResult;
import com.artfess.base.util.AppUtil;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.FileUtil;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.base.util.UniqueIdUtil;
import com.artfess.base.util.ZipUtil;
import com.artfess.base.util.time.TimeUtil;
import com.artfess.file.attachmentService.FtpAttachmentServiceImpl;
import com.artfess.file.config.UploadResult;
import com.artfess.file.model.DefaultFile;
import com.artfess.file.params.FileStorageConfigDTO;
import com.artfess.file.params.FlowUploadPropertiesStorageDTO;
import com.artfess.file.persistence.dao.FileDao;
import com.artfess.file.persistence.manager.FileConfigManager;
import com.artfess.file.persistence.manager.FileManager;
import com.artfess.file.persistence.manager.FlowUploadPropertiesManager;
import com.artfess.file.service.FilePreview;
import com.artfess.file.service.FilePreviewFactory;
import com.artfess.file.util.AppFileUtil;
import com.artfess.file.util.FileUtils;
import com.artfess.file.util.MinioUtil;
import com.artfess.file.util.UploadM3u8;
import com.artfess.file.vo.FileReqVo;
import com.artfess.file.vo.MultipartCompleteParam;
import com.artfess.file.vo.MultipartInitParam;
import com.artfess.file.vo.MultipartInitRespVo;
import com.artfess.redis.util.RedisUtil;
import com.artfess.sysConfig.util.SysPropertyUtil;
import com.artfess.uc.api.model.IUser;
import com.artfess.uc.api.service.IUserService;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.DigestUtils;
import org.springframework.web.multipart.MultipartFile;

@Service(value="fileManager")
public class FileManagerImpl
extends BaseManagerImpl<FileDao, DefaultFile>
implements FileManager {
    private static final Logger log = LoggerFactory.getLogger(FileManagerImpl.class);
    @Resource
    UCFeignService ucFeignService;
    @Resource
    IUserService userService;
    @Resource
    BaseContext baseContext;
    @Resource
    FileConfigManager fileConfigManager;
    @Resource
    private FileDao fileDao;
    private static final String CHUNK_UPLOAD_PREFIX = "/file/v1/chunkUpload";
    @Resource
    FilePreviewFactory previewFactory;
    @Autowired
    private RedisUtil redisUtil;
    @Resource(name="bmpExecutorService")
    private ExecutorService executorService;
    private AttachmentService attachmentService;

    private void initCurrentHandler(String propertiesId) throws Exception {
        AttachmentServiceFactory attachmentHandlerFactory = (AttachmentServiceFactory)AppUtil.getBean(AttachmentServiceFactory.class);
        this.attachmentService = attachmentHandlerFactory.getCurrentServices(AppFileUtil.getSaveType(propertiesId));
    }

    private void initCurrentHandlerByBizCode(String bizCode) throws Exception {
        AttachmentServiceFactory attachmentHandlerFactory = (AttachmentServiceFactory)AppUtil.getBean(AttachmentServiceFactory.class);
        this.attachmentService = attachmentHandlerFactory.getCurrentServices(AppFileUtil.getFileSaveTypeByConfig(bizCode));
    }

    @Override
    public List<DefaultFile> getAllByExt(String[] allowFiles) {
        return ((FileDao)this.baseMapper).getAllByExt(allowFiles);
    }

    @Override
    public void updateFileBizIdByIds(List<String> idList, String bizId) {
        this.removeFileByBizId(bizId, idList);
        this.fileDao.updateFileDelAndBizIdByIds("0", bizId, null, idList);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateFilesByIds(List<DefaultFile> files, String bizId) {
        if (StringUtil.isEmpty((String)bizId)) {
            return;
        }
        if (CollectionUtils.isEmpty(files)) {
            LambdaQueryWrapper deleteWrapper = new LambdaQueryWrapper();
            deleteWrapper.eq(DefaultFile::getBizId, (Object)bizId);
            this.remove((Wrapper)deleteWrapper);
            return;
        }
        List newFileIds = files.stream().map(DefaultFile::getId).collect(Collectors.toList());
        LambdaQueryWrapper fileWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)fileWrapper.eq(DefaultFile::getBizId, (Object)bizId)).or()).in(DefaultFile::getId, newFileIds);
        List dbFiles = this.list((Wrapper)fileWrapper);
        Map<String, DefaultFile> newFileMap = files.stream().collect(Collectors.toMap(DefaultFile::getId, f -> f));
        for (DefaultFile dbFile : dbFiles) {
            if (newFileMap.containsKey(dbFile.getId())) {
                DefaultFile newFile = newFileMap.get(dbFile.getId());
                dbFile.setBizId(bizId);
                dbFile.setBizCode(newFile.getBizCode());
                continue;
            }
            dbFile.setIsDel(Short.valueOf("1"));
        }
        this.saveOrUpdateBatch(dbFiles);
    }

    @Override
    @Transactional
    public void updateFilesByIds(String fileId, String bizId, String bizCode) {
        LambdaQueryWrapper fileWrapper = new LambdaQueryWrapper();
        if (fileId == null) {
            fileWrapper.eq(DefaultFile::getBizId, (Object)bizId);
            this.remove((Wrapper)fileWrapper);
            return;
        }
        if (StringUtil.isEmpty((String)bizCode) || StringUtil.isEmpty((String)bizId)) {
            throw new BaseException(" \u4e1a\u52a1id\u3001\u4e1a\u52a1\u5206\u7ec4Code \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        fileWrapper.eq(DefaultFile::getBizId, (Object)bizId);
        fileWrapper.eq(DefaultFile::getBizCode, (Object)bizCode);
        fileWrapper.eq(DefaultFile::getIsDel, (Object)"0");
        this.remove((Wrapper)fileWrapper);
        this.fileDao.updateFileDelAndBizIdById("0", bizId, bizCode, fileId);
    }

    @Override
    public void removeFileByBizId(String bizId, List<String> idList) {
        UpdateWrapper deleOldFileUpdateWrapper = new UpdateWrapper();
        ((UpdateWrapper)deleOldFileUpdateWrapper.set((Object)"IS_DEL_", (Object)"1")).eq((Object)"BIZ_ID_", (Object)bizId);
        if (idList != null && idList.size() > 0) {
            deleOldFileUpdateWrapper.notIn((Object)"ID_", idList);
        }
        this.update((Wrapper)deleOldFileUpdateWrapper);
    }

    @Override
    public String minioUrl(String fileId) throws Exception {
        DefaultFile fileMode = this.get((Serializable)((Object)fileId));
        Assert.notNull((Object)((Object)fileMode), (String)"\u8981\u67e5\u770b\u7684\u6587\u4ef6\u4e0d\u5b58\u5728");
        String saveType = fileMode.getStoreType();
        if (!DefaultFile.SAVE_TYPE_MINIO.equals(saveType)) {
            throw new BaseException("\u4f60\u8981\u83b7\u53d6\u7684\u6587\u4ef6\u4e0d\u662f\u4f7f\u7528minio\u8fdb\u884c\u4fdd\u5b58\u7684");
        }
        AttachmentServiceFactory attachmentHandlerFactory = (AttachmentServiceFactory)AppUtil.getBean(AttachmentServiceFactory.class);
        this.attachmentService = attachmentHandlerFactory.getCurrentServices(saveType);
        return this.attachmentService.getUrl((Attachment)fileMode);
    }

    @Override
    public List<DefaultFile> queryFileByBizId(String bizId) {
        QueryWrapper defaultFileQueryWrapper = new QueryWrapper();
        ((QueryWrapper)defaultFileQueryWrapper.eq((Object)"BIZ_ID_", (Object)bizId)).eq((Object)"is_del_", (Object)0);
        return this.list((Wrapper)defaultFileQueryWrapper);
    }

    @Override
    public List<DefaultFile> queryFileByBizId(String bizId, String bizCode) {
        QueryWrapper defaultFileQueryWrapper = new QueryWrapper();
        ((QueryWrapper)defaultFileQueryWrapper.eq((Object)"BIZ_ID_", (Object)bizId)).eq((Object)"is_del_", (Object)0);
        if (bizCode != null) {
            defaultFileQueryWrapper.eq((Object)"BIZ_CODE_", (Object)bizCode);
        }
        return this.list((Wrapper)defaultFileQueryWrapper);
    }

    @Override
    @Transactional
    public void delSysFileByIds(String[] ids) throws Exception {
        DefaultFile file;
        String propertiesId = "";
        if (BeanUtils.isNotEmpty((Object)ids) && ids.length > 0 && BeanUtils.isNotEmpty((Object)((Object)(file = this.get((Serializable)((Object)ids[0])))))) {
            propertiesId = file.getProp6();
        }
        this.initCurrentHandler(propertiesId);
        for (String id : ids) {
            DefaultFile def;
            this.attachmentService.remove((Attachment)def, BeanUtils.isNotEmpty((Object)((Object)(def = this.get((Serializable)((Object)id))))) ? def.getProp6() : "");
            ((FileDao)this.baseMapper).deleteById((Serializable)((Object)id));
        }
    }

    @Override
    public UploadResult UploadFileForConfig(DefaultFile file, List<MultipartFile> files, String bizCode, String bizId, String bizType, IUser currentUser) throws Exception {
        Iterator<MultipartFile> it = files.iterator();
        this.initCurrentHandlerByBizCode(bizCode);
        FileStorageConfigDTO fileStorageConfig = this.fileConfigManager.getFileConfigByCode(bizCode);
        String fileFormates = fileStorageConfig.getFileKinds();
        Double allowSize = fileStorageConfig.getAllowSize();
        int allowMultiple = fileStorageConfig.getAllowMultiple();
        UploadResult result = new UploadResult();
        if (allowMultiple == 0 && files.size() > 1) {
            result.setSuccess(false);
            result.setMessage("\u7cfb\u7edf\u53ea\u80fd\u4e0a\u4f20\u4e00\u4e2a\u9644\u4ef6\uff01");
            return result;
        }
        short isdel = 0;
        while (it.hasNext()) {
            long len;
            double fileSize;
            DefaultFile sysFile;
            Boolean isAdd = false;
            String oldFilePath = "";
            if (StringUtil.isNotEmpty((String)file.getId())) {
                sysFile = this.get((Serializable)((Object)file.getId()));
                oldFilePath = sysFile.getFilePath();
            } else {
                isAdd = true;
                sysFile = new DefaultFile();
                sysFile.setId(UniqueIdUtil.getSuid());
            }
            MultipartFile f = it.next();
            if (StringUtil.isNotEmpty((String)file.getFileName()) && !file.getFileName().equals(f.getName())) {
                throw new RuntimeException("\u4e0a\u4f20\u540d\u79f0\u4e0e\u6587\u4ef6\u540d\u79f0\u4e0d\u7b26");
            }
            String oriFileName = f.getOriginalFilename();
            String extName = FileUtil.getFileExt((String)oriFileName);
            if (StringUtil.isNotEmpty((String)fileFormates)) {
                List<String> typeList = Arrays.asList(fileFormates.split(","));
                for (int i = 0; i < typeList.size(); ++i) {
                    if (!StringUtil.isNotEmpty((String)typeList.get(i))) continue;
                    typeList.set(i, typeList.get(i).toLowerCase());
                }
                if (typeList.indexOf(extName) < 0 && typeList.indexOf("." + extName) < 0) {
                    result.setSuccess(false);
                    result.setMessage("\u7cfb\u7edf\u4e0d\u5141\u8bb8\u8be5\u7c7b\u578b\u6587\u4ef6\u7684\u4e0a\u4f20\uff01:" + extName);
                    return result;
                }
            }
            if (allowSize != null && allowSize > 0.0 && (fileSize = (double)(len = f.getSize()) / 1048576.0) > allowSize) {
                result.setSuccess(false);
                result.setMessage("\u4e0a\u4f20\u6587\u4ef6\u3010" + oriFileName + "\u3011\u5927\u5c0f\u5df2\u8d85\u8fc7\u7cfb\u7edf\u9650\u5236\uff1a" + fileSize + "MB\uff01");
                return result;
            }
            String fileName = sysFile.getId() + "." + extName;
            String filePath = "";
            String creatorAccount = DefaultFile.FILE_UPLOAD_UNKNOWN;
            if (currentUser != null) {
                sysFile.setCreateBy(currentUser.getUserId());
                sysFile.setCreatorName(currentUser.getFullname());
                creatorAccount = currentUser.getAccount();
            } else {
                sysFile.setCreatorName(creatorAccount);
            }
            filePath = "pictureShow".equals(sysFile.getFileType()) ? AppFileUtil.createFilePath(creatorAccount + File.separator + "pictureShow", fileName) : AppFileUtil.createFilePath(currentUser.getAccount(), fileName);
            sysFile.setFileName(oriFileName.lastIndexOf(46) == -1 ? oriFileName : oriFileName.substring(0, oriFileName.lastIndexOf(46)));
            sysFile.setFilePath(filePath);
            sysFile.setBizCode(bizCode);
            sysFile.setBizId(bizId);
            sysFile.setBizType(bizType);
            sysFile.setIsZone(0);
            sysFile.setZoneTotal(1L);
            sysFile.setMd5Value(DigestUtils.md5DigestAsHex((InputStream)f.getInputStream()));
            sysFile.setServerLocalName(fileName);
            String rootPath = SysPropertyUtil.getByAlias((String)"file.upload");
            sysFile.setServerLocalPath(rootPath + filePath);
            sysFile.setCreateTime(LocalDateTime.now());
            sysFile.setExtensionName(extName);
            sysFile.setByteCount(f.getSize());
            sysFile.setIsDel(isdel);
            sysFile.setNote(FileUtil.getSize((double)f.getSize()));
            sysFile.setProp6(fileStorageConfig.getStorageId());
            sysFile.setStoreType(fileStorageConfig.getUploadType());
            AttachmentServiceFactory attachmentHandlerFactory = (AttachmentServiceFactory)AppUtil.getBean(AttachmentServiceFactory.class);
            this.attachmentService = attachmentHandlerFactory.getCurrentServices(sysFile.getStoreType());
            if (isAdd.booleanValue()) {
                sysFile.setBytes(f.getBytes());
                this.attachmentService.upload((Attachment)sysFile, f.getInputStream(), BeanUtils.isNotEmpty((Object)((Object)sysFile)) ? sysFile.getProp6() : "");
                if (!fileStorageConfig.getUploadType().equals(DefaultFile.SAVE_TYPE_DTABASE)) {
                    sysFile.setBytes(null);
                }
                super.create((Model)sysFile);
            } else {
                this.attachmentService.upload((Attachment)sysFile, f.getInputStream(), BeanUtils.isNotEmpty((Object)((Object)sysFile)) ? sysFile.getProp6() : "");
                this.update((Model)sysFile);
                boolean tag = true;
                String newFilePath = sysFile.getFilePath();
                if (StringUtil.isNotEmpty((String)newFilePath) && StringUtil.isNotEmpty((String)oldFilePath) && newFilePath.trim().equals(oldFilePath.trim())) {
                    tag = false;
                }
                if (tag) {
                    sysFile.setFilePath(oldFilePath);
                    this.attachmentService.remove((Attachment)sysFile, BeanUtils.isNotEmpty((Object)((Object)sysFile)) ? sysFile.getProp6() : "");
                }
            }
            result.setSuccess(true);
            result.setFileId(sysFile.getId());
            result.setFileName(oriFileName);
            result.setSize(sysFile.getByteCount());
            result.setUsername(sysFile.getCreatorName());
        }
        return result;
    }

    @Override
    @Transactional
    public UploadResult uploadFile(DefaultFile file, List<MultipartFile> files, String fileFormates, IUser currentUser, String flowKey) throws Exception {
        Iterator<MultipartFile> it = files.iterator();
        this.initCurrentHandler(flowKey);
        UploadResult result = new UploadResult();
        boolean mark = true;
        short isdel = 0;
        while (it.hasNext()) {
            DefaultFile sysFile;
            Boolean isAdd = false;
            String oldFilePath = "";
            if (StringUtil.isNotEmpty((String)file.getId())) {
                sysFile = this.get((Serializable)((Object)file.getId()));
                oldFilePath = sysFile.getFilePath();
            } else {
                isAdd = true;
                sysFile = new DefaultFile();
                sysFile.setId(UniqueIdUtil.getSuid());
            }
            MultipartFile f = it.next();
            if (StringUtil.isNotEmpty((String)file.getFileName()) && !file.getFileName().equals(f.getName())) {
                throw new RuntimeException("\u4e0a\u4f20\u540d\u79f0\u4e0e\u6587\u4ef6\u540d\u79f0\u4e0d\u7b26");
            }
            String oriFileName = f.getOriginalFilename();
            String extName = FileUtil.getFileExt((String)oriFileName);
            if (StringUtil.isNotEmpty((String)fileFormates)) {
                List<String> typeList = Arrays.asList(fileFormates.split(","));
                for (int i = 0; i < typeList.size(); ++i) {
                    if (!StringUtil.isNotEmpty((String)typeList.get(i))) continue;
                    typeList.set(i, typeList.get(i).toLowerCase());
                }
                if (typeList.indexOf(extName) < 0 && typeList.indexOf("." + extName) < 0) {
                    mark = false;
                }
            }
            if (mark) {
                FlowUploadPropertiesManager uploadPropertiesManager;
                FlowUploadPropertiesStorageDTO uploadProperties;
                String fileName = sysFile.getId() + "." + extName;
                String filePath = "";
                String creatorAccount = DefaultFile.FILE_UPLOAD_UNKNOWN;
                if (currentUser != null) {
                    sysFile.setCreateBy(currentUser.getUserId());
                    sysFile.setCreatorName(currentUser.getFullname());
                    creatorAccount = currentUser.getAccount();
                } else {
                    sysFile.setCreatorName(creatorAccount);
                }
                filePath = "pictureShow".equals(sysFile.getFileType()) ? AppFileUtil.createFilePath(creatorAccount + File.separator + "pictureShow", fileName) : AppFileUtil.createFilePath(currentUser.getAccount(), fileName);
                sysFile.setFileName(oriFileName.lastIndexOf(46) == -1 ? oriFileName : oriFileName.substring(0, oriFileName.lastIndexOf(46)));
                sysFile.setFilePath(filePath);
                sysFile.setCreateTime(LocalDateTime.now());
                sysFile.setExtensionName(extName);
                sysFile.setByteCount(f.getSize());
                sysFile.setIsDel(isdel);
                sysFile.setNote(FileUtil.getSize((double)f.getSize()));
                if (StringUtil.isNotEmpty((String)flowKey) && BeanUtils.isNotEmpty((Object)(uploadProperties = (uploadPropertiesManager = (FlowUploadPropertiesManager)AppUtil.getBean(FlowUploadPropertiesManager.class)).getByFlowKey(flowKey)))) {
                    sysFile.setProp6(uploadProperties.getId());
                }
                String saveType = null;
                if (StringUtil.isEmpty((String)file.getStoreType())) {
                    saveType = AppFileUtil.getSaveType(flowKey);
                    sysFile.setStoreType(saveType);
                } else {
                    saveType = file.getStoreType();
                    sysFile.setStoreType(saveType);
                }
                if (DefaultFile.SAVE_TYPE_MINIO.equals(saveType)) {
                    LocalDate now = LocalDate.now();
                    String showPath = now.getYear() + "-" + now.getMonthValue() + "/" + fileName;
                    sysFile.setFilePath(showPath);
                }
                AttachmentServiceFactory attachmentHandlerFactory = (AttachmentServiceFactory)AppUtil.getBean(AttachmentServiceFactory.class);
                this.attachmentService = attachmentHandlerFactory.getCurrentServices(saveType);
                if (isAdd.booleanValue()) {
                    sysFile.setBytes(f.getBytes());
                    this.attachmentService.upload((Attachment)sysFile, f.getInputStream(), BeanUtils.isNotEmpty((Object)((Object)sysFile)) ? sysFile.getProp6() : "");
                    if (!saveType.equals(DefaultFile.SAVE_TYPE_DTABASE)) {
                        sysFile.setBytes(null);
                    }
                    super.create((Model)sysFile);
                } else {
                    this.attachmentService.upload((Attachment)sysFile, f.getInputStream(), BeanUtils.isNotEmpty((Object)((Object)sysFile)) ? sysFile.getProp6() : "");
                    this.update((Model)sysFile);
                    boolean tag = true;
                    String newFilePath = sysFile.getFilePath();
                    if (StringUtil.isNotEmpty((String)newFilePath) && StringUtil.isNotEmpty((String)oldFilePath) && newFilePath.trim().equals(oldFilePath.trim())) {
                        tag = false;
                    }
                    if (tag) {
                        sysFile.setFilePath(oldFilePath);
                        this.attachmentService.remove((Attachment)sysFile, BeanUtils.isNotEmpty((Object)((Object)sysFile)) ? sysFile.getProp6() : "");
                    }
                }
                result.setSuccess(true);
                result.setFileId(sysFile.getId());
                result.setFileName(oriFileName);
                result.setSize(sysFile.getByteCount());
                result.setUsername(sysFile.getCreatorName());
                String suffixName = FileUtils.getSuffixFromFileName(oriFileName);
                String fileType = FileTypeEnum.getType((String)suffixName);
                if (FileTypeEnum.video.getType().equals(fileType)) {
                    long videoTime = FileUtils.getVideoTime(f);
                    result.setVideoTime(videoTime);
                } else if (FileTypeEnum.txt.getType().equals(fileType) && ".pdf".equals(suffixName)) {
                    result.setPdfFileId(UniqueIdUtil.getSuid());
                }
                result.setFileExt(suffixName);
                result.setFileType(fileType);
                continue;
            }
            result.setSuccess(false);
            result.setMessage("\u7cfb\u7edf\u4e0d\u5141\u8bb8\u8be5\u7c7b\u578b\u6587\u4ef6\u7684\u4e0a\u4f20\uff01:" + extName);
        }
        return result;
    }

    @Override
    public DefaultFile downloadFile(String fileId, OutputStream outStream) throws Exception {
        DefaultFile sysFile = this.get((Serializable)((Object)fileId));
        AttachmentServiceFactory attachmentHandlerFactory = (AttachmentServiceFactory)AppUtil.getBean(AttachmentServiceFactory.class);
        this.initCurrentHandler(BeanUtils.isNotEmpty((Object)((Object)sysFile)) ? sysFile.getProp6() : "");
        if (BeanUtils.isEmpty((Object)((Object)sysFile))) {
            return null;
        }
        this.attachmentService = this.attachmentService instanceof FtpAttachmentServiceImpl && DefaultFile.SAVE_TYPE_FOLDER.equals(sysFile.getStoreType()) ? attachmentHandlerFactory.getCurrentServices(DefaultFile.SAVE_TYPE_FOLDER) : attachmentHandlerFactory.getCurrentServices(sysFile.getStoreType());
        this.attachmentService.download((Attachment)sysFile, outStream, BeanUtils.isNotEmpty((Object)((Object)sysFile)) ? sysFile.getProp6() : "");
        return sysFile;
    }

    @Override
    @Transactional
    public void uploadFile(DefaultFile file, InputStream inputStream) throws Exception {
        this.initCurrentHandler(BeanUtils.isNotEmpty((Object)((Object)file)) ? file.getProp6() : "");
        String storeType = file.getStoreType();
        if (StringUtil.isEmpty((String)file.getId())) {
            file.setId(UniqueIdUtil.getSuid());
        }
        this.attachmentService.upload((Attachment)file, inputStream, BeanUtils.isNotEmpty((Object)((Object)file)) ? file.getProp6() : "");
        if (StringUtil.isEmpty((String)storeType)) {
            storeType = AppFileUtil.getSaveType(BeanUtils.isNotEmpty((Object)((Object)file)) ? file.getProp6() : "");
            file.setStoreType(storeType);
        }
        if (!DefaultFile.SAVE_TYPE_DTABASE.equals(storeType)) {
            file.setBytes(null);
        }
        super.create((Model)file);
    }

    @Override
    @Transactional
    public void setXbTypeId(List<String> fileId, String xbTypeId, String type) throws Exception {
        ((FileDao)this.baseMapper).setXbTypeId(fileId, xbTypeId, type);
    }

    @Override
    @Transactional
    public void updateFileExtraProp(List<DefaultFile> files) {
        if (BeanUtils.isNotEmpty(files)) {
            for (DefaultFile defaultFile : files) {
                ((FileDao)this.baseMapper).updateExtraProps(defaultFile);
            }
        }
    }

    @Override
    public byte[] getFileBytesById(String fileId) throws Exception {
        DefaultFile sysFile = this.get((Serializable)((Object)fileId));
        this.initCurrentHandler(BeanUtils.isNotEmpty((Object)((Object)sysFile)) ? sysFile.getProp6() : "");
        if (BeanUtils.isEmpty((Object)((Object)sysFile))) {
            return null;
        }
        return this.attachmentService.getFileBytes((Attachment)sysFile);
    }

    public DefaultFile get(Serializable id) {
        DefaultFile file = null;
        try (MultiTenantIgnoreResult setThreadLocalIgnore = MultiTenantHandler.setThreadLocalIgnore();){
            file = (DefaultFile)super.get(id);
        }
        catch (Exception e) {
            throw new BaseException(e.getMessage(), (Throwable)e);
        }
        return file;
    }

    @Override
    public void downloadFileToPath(DefaultFile file, String path) throws Exception {
        this.initCurrentHandler(BeanUtils.isNotEmpty((Object)((Object)file)) ? file.getProp6() : "");
        File dfile = new File(path);
        if (!dfile.exists()) {
            if (BeanUtils.isNotEmpty((Object)dfile.getParentFile()) && !dfile.getParentFile().exists()) {
                dfile.getParentFile().mkdir();
            }
            FileOutputStream out = new FileOutputStream(dfile);
            this.attachmentService.download((Attachment)file, (OutputStream)out, BeanUtils.isNotEmpty((Object)((Object)file)) ? file.getProp6() : "");
            out.flush();
            ((OutputStream)out).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CommonResult<String> importSignature(MultipartFile file, boolean isCover) {
        String rootRealPath = "";
        CommonResult message = new CommonResult(true, "\u5bfc\u5165\u6210\u529f\uff01");
        try {
            String unZipDir = TimeUtil.getCurrentTimeMillis() + "_" + this.baseContext.getCurrentUserId();
            rootRealPath = (FileUtil.getIoTmpdir() + "attachFiles/unZip/" + unZipDir).replace("/", File.separator);
            File folder = new File(rootRealPath);
            if (!folder.exists()) {
                folder.mkdirs();
            }
            ZipUtil.unZipFile((MultipartFile)file, (String)rootRealPath);
            File ignatureFloder = new File(rootRealPath);
            File[] fs = ignatureFloder.listFiles();
            IUser user = null;
            String account = this.baseContext.getCurrentUserAccout();
            if (StringUtil.isNotEmpty((String)account)) {
                user = this.userService.getUserByAccount(account);
            }
            ArrayNode accountFiles = JsonUtil.getMapper().createArrayNode();
            ExecutorService pool = Executors.newFixedThreadPool(fs.length);
            FileManager fileManager = (FileManager)AppUtil.getBean(FileManager.class);
            ArrayList<Future<Object>> list = new ArrayList<Future<Object>>();
            for (File signatureFile : fs) {
                if (signatureFile.isDirectory() || !signatureFile.getName().endsWith(".png")) continue;
                MyCallable c = new MyCallable(signatureFile, user, fileManager);
                Future<Object> f = pool.submit(c);
                list.add(f);
            }
            for (Future future : list) {
                UploadResult result = (UploadResult)future.get();
                if (!result.isSuccess()) continue;
                ObjectNode accountFile = JsonUtil.getMapper().createObjectNode();
                String[] names = result.getFileName().split("\\.");
                accountFile.put("account", names[0]);
                accountFile.put("fileId", result.getFileId());
                accountFiles.add((JsonNode)accountFile);
            }
            if (accountFiles.size() > 0) {
                ObjectNode signatureData = JsonUtil.getMapper().createObjectNode();
                signatureData.put("repeatConver", isCover);
                signatureData.set("signatureList", (JsonNode)accountFiles);
                CommonResult commonResult = this.ucFeignService.saveSignatureBatch(signatureData);
                if (!commonResult.getState().booleanValue()) {
                    String[] ids = new String[signatureData.size()];
                    for (int i = 0; i < accountFiles.size(); ++i) {
                        ids[i] = accountFiles.get(i).get("fileId").asText();
                    }
                    this.delSysFileByIds(ids);
                    CommonResult commonResult2 = new CommonResult(false, "\u5bfc\u5165\u5931\u8d25\uff1a" + commonResult.getMessage());
                    return commonResult2;
                }
            }
        }
        catch (Exception e) {
            message = new CommonResult(false, "\u5bfc\u5165\u5931\u8d25:" + e.getMessage());
        }
        finally {
            File fileDir = new File(rootRealPath);
            if (fileDir.exists()) {
                FileUtil.deleteDir((File)fileDir);
            }
        }
        return message;
    }

    @Override
    public DefaultFile queryByMd5AndSize(MultipartInitParam initParam) {
        if (StringUtil.isEmpty((String)initParam.getMd5())) {
            throw new RequiredException("\u6587\u4ef6hash\u503c\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (BeanUtils.isEmpty((Object)initParam.getSize())) {
            throw new RequiredException("\u6587\u4ef6\u957f\u5ea6\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)queryWrapper.eq((Object)"md5_value_", (Object)initParam.getMd5())).eq((Object)"byte_count_", (Object)initParam.getSize());
        List list = ((FileDao)this.baseMapper).selectList((Wrapper)queryWrapper);
        if (list != null && list.size() > 0) {
            if (list.size() == 1) {
                return (DefaultFile)((Object)list.get(0));
            }
            throw new ApplicationException("\u6709\u6587\u4ef6hash\u503c\u91cd\u590d\u7684\u6587\u4ef6\uff01");
        }
        DefaultFile sysFile = this.getDefaultFile(initParam);
        this.save((Object)sysFile);
        return sysFile;
    }

    @NotNull
    private DefaultFile getDefaultFile(MultipartInitParam initParam) {
        DefaultFile sysFile = new DefaultFile();
        sysFile.setId(UniqueIdUtil.getSuid());
        String oriFileName = initParam.getFilename();
        String extName = FileUtil.getFileExt((String)oriFileName);
        String fileName = sysFile.getId() + "." + extName;
        String suffixName = FileUtils.getSuffixFromFileName(oriFileName);
        String fileType = FileTypeEnum.getType((String)suffixName);
        sysFile.setFileType(fileType);
        String account = this.baseContext.getCurrentUserAccout();
        IUser currentUser = this.userService.getUserByAccount(account);
        String creatorAccount = DefaultFile.FILE_UPLOAD_UNKNOWN;
        if (currentUser != null) {
            sysFile.setCreateBy(currentUser.getUserId());
            sysFile.setCreatorName(currentUser.getFullname());
        } else {
            sysFile.setCreatorName(creatorAccount);
        }
        String filePath = "pictureShow".equals(sysFile.getFileType()) ? AppFileUtil.createFilePath(creatorAccount + File.separator + "pictureShow", fileName) : fileName;
        sysFile.setFileName(oriFileName.lastIndexOf(46) == -1 ? oriFileName : oriFileName.substring(0, oriFileName.lastIndexOf(46)));
        sysFile.setFilePath(filePath.replaceFirst("^/", ""));
        sysFile.setIsZone(1);
        sysFile.setZoneTotal(initParam.getZoneTotal());
        sysFile.setMd5Value(initParam.getMd5());
        sysFile.setServerLocalName(fileName);
        sysFile.setCreateTime(LocalDateTime.now());
        sysFile.setExtensionName(extName);
        sysFile.setByteCount(initParam.getSize());
        sysFile.setNote(FileUtil.getSize((double)initParam.getSize().longValue()));
        sysFile.setStoreType(initParam.getStoreType());
        return sysFile;
    }

    @Override
    public DefaultFile getFileInfo(FileReqVo fileReqVo) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"FILE_TYPE_", (Object)fileReqVo.getFileType());
        queryWrapper.eq((Object)"BIZ_ID_", (Object)fileReqVo.getBizId());
        DefaultFile defaultFile = (DefaultFile)((Object)((FileDao)this.baseMapper).selectOne((Wrapper)queryWrapper));
        return defaultFile;
    }

    @Override
    public MultipartInitRespVo initMultiPartUpload(MultipartInitParam requestParam) {
        long size = requestParam.getSize();
        if (0x500000L > requestParam.getPartSize()) {
            throw new BaseException("\u5206\u7247\u5927\u5c0f\u4e0d\u80fd\u5c0f\u4e8e5M");
        }
        long partCount = size % requestParam.getPartSize() != 0L ? size / requestParam.getPartSize() + 1L : size / requestParam.getPartSize();
        requestParam.setZoneTotal(partCount);
        DefaultFile fileRecord = this.queryByMd5AndSize(requestParam);
        if (null != fileRecord && !StringUtil.isEmpty((Long)fileRecord.getUploadZoneNum()) && !"1".equals(fileRecord.getMergeStatus())) {
            Date now = new Date();
            Instant instant = fileRecord.getCreateTime().atZone(ZoneId.systemDefault()).toInstant();
            Date date = Date.from(instant);
            long hour = DateUtil.between((Date)date, (Date)now, (DateUnit)DateUnit.HOUR);
            if (hour < 20L) {
                ArrayList<String> partList = new ArrayList<String>();
                int i = 1;
                while ((long)i <= fileRecord.getZoneTotal()) {
                    String chunk = "chunk_" + (i - 1);
                    partList.add("/file/v1/chunkUpload?uploadId=" + fileRecord.getServerLocalPath() + "&chunk=" + chunk);
                    ++i;
                }
                MultipartInitRespVo multipartInitBO = new MultipartInitRespVo();
                multipartInitBO.setUploadId(fileRecord.getServerLocalPath());
                multipartInitBO.setPartCount(fileRecord.getZoneTotal());
                multipartInitBO.setUploadUrlList(partList);
                String successChunk = this.getSuccessChunk(multipartInitBO.getUploadId());
                multipartInitBO.setSuccessChunk(successChunk);
                UploadResult result = this.getUploadResult(fileRecord);
                multipartInitBO.setUploadResult(result);
                return multipartInitBO;
            }
        }
        MultipartInitRespVo multipartInitBO = this.multipartUpload(requestParam, fileRecord);
        return multipartInitBO;
    }

    private MultipartInitRespVo multipartUpload(MultipartInitParam requestParam, DefaultFile fileRecord) {
        try {
            MultipartInitRespVo multipartInitBO = new MultipartInitRespVo();
            if (!StringUtil.isEmpty((String)fileRecord.getMergeStatus()) && "1".equals(fileRecord.getMergeStatus())) {
                UploadResult result = this.getUploadResult(fileRecord);
                multipartInitBO.setUploadResult(result);
            } else {
                AttachmentServiceFactory attachmentHandlerFactory = (AttachmentServiceFactory)AppUtil.getBean(AttachmentServiceFactory.class);
                this.attachmentService = attachmentHandlerFactory.getCurrentServices(requestParam.getStoreType());
                fileRecord.setContentType(requestParam.getContentType());
                String uploadId = this.attachmentService.initMultiPartUpload((Attachment)fileRecord);
                fileRecord.setServerLocalPath(uploadId);
                ((FileDao)this.baseMapper).updateById((Object)fileRecord);
                String redisKey = CodePrefix.MULTIPART_UPLOADID_KEY.getKey() + ":" + uploadId;
                Long time = 86400L;
                this.redisUtil.set(redisKey, (Object)fileRecord.getId(), time.longValue());
                HashMap<String, String> chunkMap = new HashMap<String, String>();
                ArrayList<String> partList = new ArrayList<String>();
                int i = 1;
                while ((long)i <= requestParam.getZoneTotal()) {
                    String uploadUrl = this.attachmentService.getChunkUrl((Attachment)fileRecord, Integer.valueOf(i), uploadId);
                    String chunk = "chunk_" + (i - 1);
                    chunkMap.put(chunk, uploadUrl);
                    partList.add("/file/v1/chunkUpload?uploadId=" + uploadId + "&chunk=" + chunk);
                    String chunkKey = CodePrefix.MULTIPART_UPLOADID_CHUNK_KEY.getKey() + ":" + uploadId + ":" + chunk;
                    this.redisUtil.set(chunkKey, (Object)uploadUrl, time.longValue());
                    ++i;
                }
                multipartInitBO.setPartCount(requestParam.getZoneTotal());
                multipartInitBO.setUploadId(uploadId);
                multipartInitBO.setUploadUrlList(partList);
                String successChunk = this.getSuccessChunk(uploadId);
                multipartInitBO.setSuccessChunk(successChunk);
                UploadResult result = this.getUploadResult(fileRecord);
                multipartInitBO.setUploadResult(result);
            }
            return multipartInitBO;
        }
        catch (Exception e) {
            log.error("\u5206\u7247\u521d\u59cb\u5316\u5931\u8d25\uff0c{}", (Object)e.getMessage());
            return null;
        }
    }

    @NotNull
    private UploadResult getUploadResult(DefaultFile fileRecord) {
        UploadResult result = new UploadResult();
        result.setSuccess(true);
        result.setFileId(fileRecord.getId());
        result.setFileName(fileRecord.getFileName());
        result.setSize(fileRecord.getByteCount());
        result.setUsername(fileRecord.getCreatorName());
        result.setFileExt(fileRecord.getExtensionName());
        result.setMergeStatus(fileRecord.getMergeStatus());
        result.setFileType(fileRecord.getFileType());
        return result;
    }

    private String getSuccessChunk(String uploadId) {
        Map allCaches = this.redisUtil.getAllCaches(CodePrefix.MULTIPART_UPLOADID_CHUNK_KEY.getKey() + ":" + uploadId + ":");
        StringBuffer sb = new StringBuffer();
        allCaches.forEach((key, value) -> {
            if (null == value) {
                return;
            }
            if ("1".equals(value.toString())) {
                sb.append(",");
                String chunkIndex = key.substring(key.lastIndexOf(":") + 1, key.length());
                sb.append(chunkIndex);
            }
        });
        if (sb.length() > 1) {
            return sb.substring(1);
        }
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean chunkUpload(MultipartFile file, String uploadId, String chunk) {
        String chunkKey = CodePrefix.MULTIPART_UPLOADID_CHUNK_KEY.getKey() + ":" + uploadId + ":" + chunk;
        String uploadUrl = (String)this.redisUtil.get(chunkKey, String.class);
        if (!StringUtil.isEmpty((String)uploadId) && "1".equals(uploadUrl)) {
            return true;
        }
        String redisKey = CodePrefix.MULTIPART_UPLOADID_KEY.getKey() + ":" + uploadId;
        String fileId = (String)this.redisUtil.get(redisKey, String.class);
        Assert.hasText((String)fileId, (String)"\u5206\u7247\u6587\u4ef6\u4e0d\u5b58\u5728");
        DefaultFile defaultFile = this.get((Serializable)((Object)fileId));
        Assert.notNull((Object)((Object)defaultFile), (String)"\u5206\u7247\u6587\u4ef6\u4e0d\u5b58\u5728");
        String msg = this.putMethod(uploadUrl, file);
        if (null == msg) {
            Long expire = this.redisUtil.getExpire(chunkKey);
            this.redisUtil.set(chunkKey, (Object)"1", (long)expire.intValue());
            String chunkNumKey = CodePrefix.MULTIPART_UPLOADID_CHUNKNUM_KEY.getKey() + ":" + uploadId;
            long incr = this.redisUtil.incr(chunkNumKey, 1L);
            defaultFile.setUploadZoneNum(incr);
        }
        boolean update = this.updateById((Object)defaultFile);
        return update;
    }

    @Override
    public UploadResult mergeMultipartUpload(MultipartCompleteParam param) {
        String redisKey = CodePrefix.MULTIPART_UPLOADID_KEY.getKey() + ":" + param.getUploadId();
        String fileId = (String)this.redisUtil.get(redisKey, String.class);
        Assert.hasText((String)fileId, (String)"\u5206\u7247\u6587\u4ef6\u4e0d\u5b58\u5728");
        DefaultFile defaultFile = this.get((Serializable)((Object)fileId));
        Assert.notNull((Object)((Object)defaultFile), (String)"\u5206\u7247\u6587\u4ef6\u4e0d\u5b58\u5728");
        if (defaultFile.getUploadZoneNum().equals(defaultFile.getZoneTotal())) {
            this.mergeMultipartUpload(param.getUploadId(), defaultFile);
        }
        UploadResult result = null;
        boolean update = this.updateById((Object)defaultFile);
        if (update) {
            result = new UploadResult();
            result.setSuccess(true);
            result.setFileId(defaultFile.getId());
            result.setFileName(defaultFile.getFileName());
            result.setSize(defaultFile.getByteCount());
            result.setUsername(defaultFile.getCreatorName());
            result.setFileExt(defaultFile.getExtensionName());
            result.setMergeStatus(defaultFile.getMergeStatus());
            result.setFileType(defaultFile.getFileType());
            if (FileTypeEnum.video.getType().equals(result.getFileType())) {
                this.executorService.execute(() -> {
                    UploadM3u8 uploadM3u8 = new UploadM3u8();
                    String url = uploadM3u8.uploadVideoToM3U8(defaultFile);
                    defaultFile.setProp4(url);
                    this.updateById((Object)defaultFile);
                    log.info("\u89c6\u5c4f\u8f6c\u6362\u6210\u529f!");
                });
            }
            if (FileTypeEnum.txt.getType().equals(result.getFileType()) && !"pdf".equals(result.getFileExt())) {
                this.executorService.execute(() -> {
                    HashMap map = new HashMap();
                    FilePreview filePreview = this.previewFactory.get(defaultFile);
                    filePreview.filePreviewHandle(defaultFile, map);
                });
            }
        }
        return result;
    }

    @Override
    public JSONObject minioUpload(MultipartFile file, String bizPath, HttpServletResponse response) throws Exception {
        JSONObject accessory = new JSONObject();
        String fileName = null;
        if (file.isEmpty() || file.getSize() == 0L) {
            throw new BaseException("\u6587\u4ef6\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank(fileName)) {
            fileName = file.getOriginalFilename();
        }
        accessory.put("name", (Object)fileName);
        String name = UUID.randomUUID().toString() + fileName.substring(fileName.lastIndexOf("."));
        if (StringUtils.isBlank((CharSequence)bizPath)) {
            bizPath = "default";
        }
        String url = MinioUtil.upload(file, bizPath, name, "xcjy");
        String ext = fileName.substring(fileName.lastIndexOf(".") + 1);
        accessory.put("type", (Object)ext);
        accessory.put("suffix", (Object)ext);
        accessory.put("url", (Object)url);
        accessory.put("isDele", (Object)"0");
        return accessory;
    }

    @Override
    public String minioPreviewFile(String bucketName, String fileName) throws Exception {
        String fileUrl = MinioUtil.previewFile(bucketName, fileName, null, null);
        return fileUrl;
    }

    @Override
    public String minioPreviewFile(String id) throws Exception {
        DefaultFile file = (DefaultFile)((Object)((FileDao)this.baseMapper).selectById((Serializable)((Object)id)));
        if (file != null) {
            String fileUrl = MinioUtil.previewFile(null, file.getFilePath(), null, null);
            return fileUrl;
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mergeMultipartUpload(String uploadId, DefaultFile defaultFile) {
        boolean status = false;
        try {
            String redisKey = CodePrefix.MULTIPART_UPLOADID_KEY.getKey() + ":" + uploadId;
            String fileId = (String)this.redisUtil.get(redisKey, String.class);
            if (StringUtil.isEmpty((String)fileId)) {
                throw new BaseException("\u5206\u7247\u4e0a\u4f20\u5931\u8d25\uff01");
            }
            String chunkListKeyPattern = CodePrefix.MULTIPART_UPLOADID_CHUNK_KEY.getKey() + ":" + uploadId + ":chunk_*";
            Map data = this.redisUtil.getAllCache(chunkListKeyPattern);
            if (null == data) {
                log.info(">>>>>>>>>>>{}\u7f13\u5b58\u8fc7\u671f\uff0c\u4e0d\u80fd\u5408\u5e76", (Object)uploadId);
                throw new BaseException("\u5206\u7247\u4e0a\u4f20\u5931\u8d25\uff01");
            }
            int realyPartNumber = defaultFile.getUploadZoneNum().intValue();
            AttachmentServiceFactory attachmentHandlerFactory = (AttachmentServiceFactory)AppUtil.getBean(AttachmentServiceFactory.class);
            this.attachmentService = attachmentHandlerFactory.getCurrentServices(defaultFile.getStoreType());
            status = this.attachmentService.mergeMultipartUpload((Attachment)defaultFile, uploadId, realyPartNumber);
            if (status) {
                defaultFile.setMergeStatus("1");
                this.redisUtil.del(new String[]{redisKey});
                this.redisUtil.delLike(chunkListKeyPattern);
            }
        }
        catch (Exception e) {
            log.error("\u5206\u7247\u5408\u5e76\u5931\u8d25\uff0c{}", (Object)e.fillInStackTrace().toString());
        }
        finally {
            log.info(">>>>>>>>>>>>\u5408\u5e76chunk,uploadId:{}, \u5408\u5e76\u7ed3\u679c\uff1a{}", (Object)uploadId, (Object)status);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String putMethod(String url, MultipartFile file) {
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        CloseableHttpResponse response = null;
        try {
            HttpPut httpPut = new HttpPut(url);
            ByteArrayEntity byteArrayEntity = new ByteArrayEntity(file.getBytes());
            httpPut.setEntity((HttpEntity)byteArrayEntity);
            response = httpClient.execute((HttpUriRequest)httpPut);
            log.info(">>>>>>>>>>>>>>" + url + "\u7684\u54cd\u5e94\u72b6\u6001\u4e3a:{}, resonPhrase: {}", (Object)response.getStatusLine().getStatusCode(), (Object)response.getStatusLine().getReasonPhrase());
            if (response.getStatusLine().getStatusCode() != 200) {
                String string = "\u4e0a\u4f20\u5931\u8d25";
                return string;
            }
            String string = null;
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
            String string = "\u4e0a\u4f20\u5931\u8d25";
            return string;
        }
        finally {
            try {
                if (httpClient != null) {
                    httpClient.close();
                }
                if (response != null) {
                    response.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    class MyCallable
    implements Callable<Object> {
        private Logger logger = LoggerFactory.getLogger(FileManagerImpl.class);
        private File file;
        private IUser user;
        private FileManager fileManager;

        MyCallable(File file, IUser user, FileManager fileManager) {
            this.file = file;
            this.user = user;
            this.fileManager = fileManager;
        }

        @Override
        public Object call() throws Exception {
            this.logger.info(">>>" + this.file.getName() + "\u7b7e\u7ae0\u9644\u4ef6\u4e0a\u4f20");
            LocalDateTime dateTmp1 = LocalDateTime.now();
            UploadResult result = this.upload();
            Thread.sleep(200L);
            LocalDateTime dateTmp2 = LocalDateTime.now();
            long time = TimeUtil.getTimeMillis((LocalDateTime)dateTmp2) - TimeUtil.getTimeMillis((LocalDateTime)dateTmp1);
            this.logger.info(">>>" + this.file.getName() + "\u7b7e\u7ae0\u9644\u4ef6\u4e0a\u4f20\u5b8c\u6210; \u82b1\u8d39\u65f6\u95f4\u4e3a\uff1a " + time);
            return result;
        }

        private UploadResult upload() {
            try {
                FileManager fileManager = (FileManager)AppUtil.getBean(FileManager.class);
                MultipartFile multipartFile = FileUtil.fileToMultipartFile((File)this.file);
                ArrayList<MultipartFile> files = new ArrayList<MultipartFile>();
                files.add(multipartFile);
                DefaultFile file = new DefaultFile();
                return fileManager.uploadFile(file, files, null, this.user, "");
            }
            catch (Exception e) {
                this.logger.info(">>>" + this.file.getName() + "\u7b7e\u7ae0\u9644\u4ef6\u4e0a\u4f20\u5931\u8d25\uff1a " + e.getMessage());
                return null;
            }
        }
    }
}

