/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.bpm.persistence.util;

import com.artfess.base.util.AppUtil;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.StringUtil;
import com.artfess.base.util.UniqueIdUtil;
import com.artfess.bpm.api.cmd.ActionCmd;
import com.artfess.bpm.api.cmd.TaskFinishCmd;
import com.artfess.bpm.api.constant.NodeType;
import com.artfess.bpm.api.context.ContextThreadUtil;
import com.artfess.bpm.api.model.process.inst.BpmProcessInstance;
import com.artfess.bpm.api.model.process.nodedef.BpmNodeDef;
import com.artfess.bpm.api.model.process.nodedef.ext.CallActivityNodeDef;
import com.artfess.bpm.api.model.process.nodedef.ext.SignNodeDef;
import com.artfess.bpm.api.model.process.nodedef.ext.SubProcessNodeDef;
import com.artfess.bpm.api.model.process.nodedef.ext.UserTaskNodeDef;
import com.artfess.bpm.api.model.process.task.NodeDefTransient;
import com.artfess.bpm.api.service.BpmDefinitionAccessor;
import com.artfess.bpm.model.def.SubProcessStartOrEndEventModel;
import com.artfess.bpm.persistence.dao.BpmExeStackRelationDao;
import com.artfess.bpm.persistence.manager.ActExecutionManager;
import com.artfess.bpm.persistence.manager.ActTaskManager;
import com.artfess.bpm.persistence.manager.BpmExeStackManager;
import com.artfess.bpm.persistence.manager.BpmExeStackRelationManager;
import com.artfess.bpm.persistence.manager.BpmProcessInstanceManager;
import com.artfess.bpm.persistence.model.ActExecution;
import com.artfess.bpm.persistence.model.ActTask;
import com.artfess.bpm.persistence.model.BpmExeStack;
import com.artfess.bpm.persistence.model.BpmExeStackRelation;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class BpmStackRelationUtil {
    public static List<NodeDefTransient> getInComeGateway(String defId, String nodeId, BpmExeStack fromStack) throws Exception {
        String isSubProcessMultiStartOrEndEvent;
        ArrayList<NodeDefTransient> listResult = new ArrayList<NodeDefTransient>();
        if (fromStack == null) {
            return null;
        }
        BpmDefinitionAccessor bpmDefinitionAccessor = (BpmDefinitionAccessor)AppUtil.getBean((String)"bpmDefinitionAccessor");
        ActionCmd cmd = ContextThreadUtil.getActionCmd();
        String currentEventType = cmd.getTransitVars("CurrentEventType") != null ? cmd.getTransitVars("CurrentEventType").toString() : null;
        String string = isSubProcessMultiStartOrEndEvent = cmd.getTransitVars("SubProcessMultiStartOrEndEvent") != null ? cmd.getTransitVars("SubProcessMultiStartOrEndEvent").toString() : null;
        if (isSubProcessMultiStartOrEndEvent != null) {
            SubProcessStartOrEndEventModel model = (SubProcessStartOrEndEventModel)cmd.getTransitVars("SubProcessMultiStartOrEndEventModel");
            String nodeType = model.getNoteType();
            BpmNodeDef bpmNodeDef = bpmDefinitionAccessor.getBpmNodeDef(fromStack.getPrcoDefId(), model.getNodeId());
            NodeDefTransient nodeDef = new NodeDefTransient(bpmNodeDef);
            nodeDef.setType(NodeType.fromKey(nodeType));
            listResult.add(nodeDef);
            return listResult;
        }
        if (currentEventType != null && currentEventType.equals("SubProcessStartOrEndEvent")) {
            SubProcessStartOrEndEventModel model = (SubProcessStartOrEndEventModel)cmd.getTransitVars("SubProcessStartOrEndEventModel");
            String nodeType = model.getNoteType();
            BpmNodeDef bpmNodeDef = bpmDefinitionAccessor.getBpmNodeDef(fromStack.getPrcoDefId(), model.getNodeId());
            NodeDefTransient nodeDef = new NodeDefTransient(bpmNodeDef);
            nodeDef.setType(NodeType.fromKey(nodeType));
            listResult.add(nodeDef);
            return listResult;
        }
        NodeDefTransient nodeDef = null;
        ArrayList<NodeDefTransient> histSearchNodeList = new ArrayList<NodeDefTransient>();
        BpmNodeDef bpmNodeDef = bpmDefinitionAccessor.getBpmNodeDef(defId, nodeId);
        List<BpmNodeDef> inComeList = bpmNodeDef.getIncomeNodes();
        String parentNodeId = fromStack.getNodeId();
        for (BpmNodeDef node : inComeList) {
            if (nodeDef != null) break;
            NodeType noteType = node.getType();
            if (!noteType.equals((Object)NodeType.EXCLUSIVEGATEWAY) && !noteType.equals((Object)NodeType.PARALLELGATEWAY) && !noteType.equals((Object)NodeType.INCLUSIVEGATEWAY)) continue;
            histSearchNodeList.add(new NodeDefTransient(node));
            nodeDef = BpmStackRelationUtil.getInComeDateWay(node, parentNodeId, histSearchNodeList);
        }
        return histSearchNodeList;
    }

    private static NodeDefTransient getInComeDateWay(BpmNodeDef node, String parentNodeId, List<NodeDefTransient> histSearchNodeList) {
        NodeDefTransient resultNode = null;
        List<BpmNodeDef> inList = node.getIncomeNodes();
        for (BpmNodeDef theNode : inList) {
            if (theNode.getNodeId().equals(parentNodeId)) {
                resultNode = new NodeDefTransient(node);
                break;
            }
            NodeType noteType = theNode.getType();
            if (!noteType.equals((Object)NodeType.EXCLUSIVEGATEWAY) && !noteType.equals((Object)NodeType.PARALLELGATEWAY) && !noteType.equals((Object)NodeType.INCLUSIVEGATEWAY)) continue;
            histSearchNodeList.add(new NodeDefTransient(theNode));
            resultNode = BpmStackRelationUtil.getInComeDateWay(theNode, parentNodeId, histSearchNodeList);
        }
        if (BeanUtils.isNotEmpty(histSearchNodeList) && resultNode == null) {
            for (NodeDefTransient item : histSearchNodeList) {
                if (!item.getNodeId().equals(node.getNodeId())) continue;
                histSearchNodeList.remove(item);
                break;
            }
        }
        if (resultNode != null && histSearchNodeList != null && histSearchNodeList.size() > 0) {
            resultNode = histSearchNodeList.get(0);
        }
        return resultNode;
    }

    public static boolean isHaveAndOrGateway(String bpmProcInstId, String ondeId, String direction) throws Exception {
        BpmExeStackRelationDao relationDao = (BpmExeStackRelationDao)AppUtil.getBean(BpmExeStackRelationDao.class);
        List<BpmExeStackRelation> list = relationDao.getListByProcInstId(bpmProcInstId);
        return BpmStackRelationUtil.isHaveAndOrGateway(bpmProcInstId, ondeId, direction, list);
    }

    public static boolean isHaveAndOrGateway(String bpmProcInstId, String nodeId, String direction, List<BpmExeStackRelation> list) throws Exception {
        BpmProcessInstanceManager instanceManager = (BpmProcessInstanceManager)AppUtil.getBean(BpmProcessInstanceManager.class);
        BpmExeStackRelation relation = null;
        for (BpmExeStackRelation bpmExeStackRelation : list) {
            Object toNodeId;
            String fromNodeId = bpmExeStackRelation.getFromNodeId();
            if (fromNodeId.equals(toNodeId = bpmExeStackRelation.getToNodeId())) continue;
            if ("pre".equals(direction)) {
                if (!((String)toNodeId).equals(nodeId)) continue;
                relation = bpmExeStackRelation;
                break;
            }
            if (!"after".equals(direction) || !fromNodeId.equals(nodeId)) continue;
            relation = bpmExeStackRelation;
            break;
        }
        if (relation == null) {
            return false;
        }
        String rnodeType = relation.getToNodeType();
        String noteType = relation.getFromNodeType();
        if ("after".equals(direction)) {
            rnodeType = relation.getFromNodeType();
            noteType = relation.getToNodeType();
        }
        if (noteType.equals(NodeType.PARALLELGATEWAY.getKey()) || noteType.equals(NodeType.INCLUSIVEGATEWAY.getKey()) || noteType.equals(NodeType.SUBSTARTGATEWAY.getKey()) || noteType.equals(NodeType.SUBENDGATEWAY.getKey()) || noteType.equals(NodeType.SUBMULTISTARTGATEWAY.getKey()) && !rnodeType.equals(NodeType.SIGNTASK.getKey())) {
            return true;
        }
        boolean hasHistoryNode = false;
        for (BpmExeStackRelation bpmExeStackRelation : list) {
            if (!bpmExeStackRelation.getToNodeType().equals(NodeType.PARALLELGATEWAY.getKey()) && !noteType.equals(NodeType.INCLUSIVEGATEWAY.getKey()) && !noteType.equals(NodeType.SUBSTARTGATEWAY.getKey()) && !noteType.equals(NodeType.SUBENDGATEWAY.getKey()) && !noteType.equals(NodeType.SUBMULTISTARTGATEWAY.getKey())) continue;
            hasHistoryNode = true;
            break;
        }
        if (!hasHistoryNode) {
            return false;
        }
        BpmProcessInstance instance = (BpmProcessInstance)instanceManager.get((Serializable)((Object)bpmProcInstId));
        String defId = instance.getProcDefId();
        BpmNodeDef bpmNodeDef = direction.equals("pre") ? BpmStackRelationUtil.getPreParallelBpmNodeDef(list, relation, defId) : BpmStackRelationUtil.getAfterParallelBpmNodeDef(list, relation, defId);
        return bpmNodeDef != null;
    }

    public static void createBpmExeStackRelation(String procInstId, BpmExeStack fromBpmExeStack, BpmExeStack toBpmExeStack) {
        BpmExeStackRelation bpmExeStackRelation;
        if (fromBpmExeStack == null) {
            return;
        }
        BpmExeStackRelationManager bpmExeStackRelationManager = (BpmExeStackRelationManager)AppUtil.getBean(BpmExeStackRelationManager.class);
        if (!fromBpmExeStack.getId().equals(toBpmExeStack.getId()) && BeanUtils.isEmpty((Object)((Object)(bpmExeStackRelation = bpmExeStackRelationManager.getById(procInstId, fromBpmExeStack.getId(), toBpmExeStack.getId()))))) {
            BpmExeStackRelation entity = new BpmExeStackRelation();
            entity.setRelationId(UniqueIdUtil.getSuid());
            entity.setFromStackId(fromBpmExeStack.getId());
            entity.setToStackId(toBpmExeStack.getId());
            entity.setToNodeId(toBpmExeStack.getNodeId());
            entity.setToNodeType(toBpmExeStack.getNodeType());
            entity.setFromNodeId(fromBpmExeStack.getNodeId());
            String fromNodeType = fromBpmExeStack.getNodeType();
            entity.setFromNodeType(fromNodeType);
            entity.setProcInstId(procInstId);
            bpmExeStackRelationManager.create((Model)entity);
        }
    }

    private static BpmNodeDef getPreParallelBpmNodeDef(List<BpmExeStackRelation> list, BpmExeStackRelation relation, String defId) throws Exception {
        BpmExeStackRelation bpmExeStackRelation2;
        if (relation == null) {
            return null;
        }
        BpmNodeDef bpmNodeDef = null;
        BpmDefinitionAccessor bpmDefinitionAccessor = (BpmDefinitionAccessor)AppUtil.getBean((String)"bpmDefinitionAccessor");
        String noteType = relation.getFromNodeType();
        if (noteType.equals(NodeType.PARALLELGATEWAY.getKey()) || noteType.equals(NodeType.INCLUSIVEGATEWAY.getKey()) || noteType.equals(NodeType.SUBSTARTGATEWAY.getKey()) || noteType.equals(NodeType.SUBENDGATEWAY.getKey()) || noteType.equals(NodeType.SUBMULTISTARTGATEWAY.getKey())) {
            bpmNodeDef = bpmDefinitionAccessor.getBpmNodeDef(defId, relation.getToNodeId());
            return bpmNodeDef;
        }
        ArrayList<BpmExeStackRelation> listNewBpmExeStacks = new ArrayList<BpmExeStackRelation>();
        String fromStackId = relation.getFromStackId();
        for (BpmExeStackRelation bpmExeStackRelation2 : list) {
            if (bpmExeStackRelation2.getFromNodeId().equals(bpmExeStackRelation2.getToNodeId()) || !bpmExeStackRelation2.getToStackId().equals(fromStackId) || listNewBpmExeStacks.contains((Object)bpmExeStackRelation2)) continue;
            listNewBpmExeStacks.add(bpmExeStackRelation2);
        }
        Iterator<BpmExeStackRelation> iterator = listNewBpmExeStacks.iterator();
        while (iterator.hasNext() && (bpmNodeDef = BpmStackRelationUtil.getPreParallelBpmNodeDef(list, bpmExeStackRelation2 = iterator.next(), defId)) == null) {
        }
        return bpmNodeDef;
    }

    private static BpmNodeDef getAfterParallelBpmNodeDef(List<BpmExeStackRelation> list, BpmExeStackRelation relation, String defId) throws Exception {
        BpmNodeDef bpmNodeDef;
        block3: {
            BpmExeStackRelation bpmExeStackRelation2;
            if (relation == null) {
                return null;
            }
            bpmNodeDef = null;
            BpmDefinitionAccessor bpmDefinitionAccessor = (BpmDefinitionAccessor)AppUtil.getBean((String)"bpmDefinitionAccessor");
            String noteType = relation.getToNodeType();
            if (noteType.equals(NodeType.PARALLELGATEWAY.getKey()) || noteType.equals(NodeType.INCLUSIVEGATEWAY.getKey()) || noteType.equals(NodeType.SUBSTARTGATEWAY.getKey()) || noteType.equals(NodeType.SUBENDGATEWAY.getKey()) || noteType.equals(NodeType.SUBMULTISTARTGATEWAY.getKey())) {
                bpmNodeDef = bpmDefinitionAccessor.getBpmNodeDef(defId, relation.getToNodeId());
                return bpmNodeDef;
            }
            ArrayList<BpmExeStackRelation> listNewBpmExeStacks = new ArrayList<BpmExeStackRelation>();
            String toStackId = relation.getToStackId();
            for (BpmExeStackRelation bpmExeStackRelation2 : list) {
                if (!bpmExeStackRelation2.getFromStackId().equals(toStackId) || listNewBpmExeStacks.contains((Object)bpmExeStackRelation2)) continue;
                listNewBpmExeStacks.add(bpmExeStackRelation2);
            }
            Iterator<BpmExeStackRelation> iterator = listNewBpmExeStacks.iterator();
            if (!iterator.hasNext()) break block3;
            bpmExeStackRelation2 = iterator.next();
            bpmNodeDef = BpmStackRelationUtil.getAfterParallelBpmNodeDef(list, bpmExeStackRelation2, defId);
        }
        return bpmNodeDef;
    }

    public static List<BpmNodeDef> getHistoryListBpmNodeDef(String bpmProcInstId, String ondeId, String direction) throws Exception {
        ArrayList<BpmNodeDef> listResult = new ArrayList<BpmNodeDef>();
        BpmExeStackRelationDao relationDao = (BpmExeStackRelationDao)AppUtil.getBean(BpmExeStackRelationDao.class);
        BpmProcessInstanceManager instanceManager = (BpmProcessInstanceManager)AppUtil.getBean(BpmProcessInstanceManager.class);
        List<BpmExeStackRelation> list = relationDao.getListByProcInstId(bpmProcInstId);
        BpmExeStackRelation relation = null;
        for (BpmExeStackRelation bpmExeStackRelation : list) {
            if ("pre".equals(direction) && bpmExeStackRelation.getToNodeId().equals(ondeId) && !bpmExeStackRelation.getFromNodeId().equals(bpmExeStackRelation.getToNodeId())) {
                relation = bpmExeStackRelation;
                break;
            }
            if (!"after".equals(direction) || !bpmExeStackRelation.getFromNodeId().equals(ondeId) || bpmExeStackRelation.getFromNodeId().equals(bpmExeStackRelation.getToNodeId())) continue;
            relation = bpmExeStackRelation;
            break;
        }
        if (relation == null) {
            return listResult;
        }
        BpmProcessInstance instance = (BpmProcessInstance)instanceManager.get((Serializable)((Object)bpmProcInstId));
        String defId = instance.getProcDefId();
        BpmDefinitionAccessor bpmDefinitionAccessor = (BpmDefinitionAccessor)AppUtil.getBean((String)"bpmDefinitionAccessor");
        List<BpmNodeDef> allNodeDef = bpmDefinitionAccessor.getAllNodeDef(defId);
        HashMap<String, BpmNodeDef> nodeMap = new HashMap<String, BpmNodeDef>();
        for (BpmNodeDef bpmNodeDef : allNodeDef) {
            nodeMap.put(bpmNodeDef.getNodeId(), bpmNodeDef);
        }
        HashMap<String, BpmNodeDef> resultMap = new HashMap<String, BpmNodeDef>();
        ArrayList<BpmExeStackRelation> resultRelation = new ArrayList<BpmExeStackRelation>();
        BpmStackRelationUtil.getHistoryListBpmNodeDef(list, relation, direction, nodeMap, resultMap, resultRelation);
        if (BeanUtils.isEmpty(resultRelation)) {
            return listResult;
        }
        Collections.sort(resultRelation, new Comparator<BpmExeStackRelation>(){

            @Override
            public int compare(BpmExeStackRelation opinion1, BpmExeStackRelation opinion2) {
                return opinion2.getCreatedTime().compareTo(opinion1.getCreatedTime());
            }
        });
        for (BpmExeStackRelation bpmExeStackRelation : resultRelation) {
            String nodeId = direction.equals("pre") ? bpmExeStackRelation.getFromNodeId() : bpmExeStackRelation.getToNodeId();
            if (!resultMap.containsKey(nodeId)) continue;
            listResult.add((BpmNodeDef)resultMap.get(nodeId));
        }
        return listResult;
    }

    private static void getHistoryListBpmNodeDef(List<BpmExeStackRelation> list, BpmExeStackRelation relation, String direction, Map<String, BpmNodeDef> nodeMap, Map<String, BpmNodeDef> resultMap, List<BpmExeStackRelation> resultRelation) throws Exception {
        String nodeId;
        if (relation == null || relation.getToNodeId().equals(relation.getFromNodeId())) {
            return;
        }
        String string = nodeId = direction.equals("pre") ? relation.getFromNodeId() : relation.getToNodeId();
        if (resultMap.containsKey(nodeId)) {
            return;
        }
        BpmNodeDef bpmNodeDef = nodeMap.get(nodeId);
        if (bpmNodeDef != null && (bpmNodeDef instanceof UserTaskNodeDef || bpmNodeDef instanceof SignNodeDef || bpmNodeDef instanceof CallActivityNodeDef)) {
            resultMap.put(bpmNodeDef.getNodeId(), bpmNodeDef);
            resultRelation.add(relation);
        }
        String fromStackId = relation.getFromStackId();
        String toStackId = relation.getToStackId();
        for (BpmExeStackRelation bpmExeStackRelation : list) {
            if (bpmExeStackRelation.getFromStackId().equals(bpmExeStackRelation.getToStackId())) continue;
            if (direction.equals("pre") && bpmExeStackRelation.getToStackId().equals(fromStackId)) {
                BpmStackRelationUtil.getHistoryListBpmNodeDef(list, bpmExeStackRelation, direction, nodeMap, resultMap, resultRelation);
                continue;
            }
            if (!direction.equals("after") || !bpmExeStackRelation.getFromStackId().equals(toStackId)) continue;
            BpmStackRelationUtil.getHistoryListBpmNodeDef(list, bpmExeStackRelation, direction, nodeMap, resultMap, resultRelation);
        }
    }

    public static boolean isHaveMultiGatewayByBetweenNode(String bpmProcInstId, String startNodeId, String endNodeId) throws Exception {
        List<BpmNodeDef> list = BpmStackRelationUtil.getHistoryListByBetweenNode(bpmProcInstId, startNodeId, endNodeId);
        for (BpmNodeDef bpmNodeDef : list) {
            SubProcessNodeDef subNodeDef;
            if (SubProcessNodeDef.class.getName().equals(bpmNodeDef.getClass().getName()) && (subNodeDef = (SubProcessNodeDef)bpmNodeDef).isParallel()) {
                return true;
            }
            String noteType = bpmNodeDef.getType().getKey();
            if (!noteType.equals(NodeType.SUBMULTISTARTGATEWAY.getKey()) && !noteType.equals(NodeType.SUBENDGATEWAY.getKey())) continue;
            return true;
        }
        return false;
    }

    public static List<BpmNodeDef> getHistoryListByBetweenNode(String bpmProcInstId, String startNodeId, String endNodeId) throws Exception {
        ArrayList<BpmNodeDef> list = new ArrayList<BpmNodeDef>();
        List<BpmNodeDef> listStartNodeIdPre = BpmStackRelationUtil.getHistoryListBpmNodeDef(bpmProcInstId, startNodeId, "after");
        List<BpmNodeDef> listEndNodeIdafter = BpmStackRelationUtil.getHistoryListBpmNodeDef(bpmProcInstId, endNodeId, "pre");
        for (BpmNodeDef startNode : listStartNodeIdPre) {
            for (BpmNodeDef endNode : listEndNodeIdafter) {
                if (!startNode.getNodeId().equals(endNode.getNodeId())) continue;
                list.add(startNode);
            }
        }
        return list;
    }

    public static boolean instancesRejectDirectAdjust(String rejectDirectExecutionId) {
        List<String> parentsId;
        ActExecutionManager actExecutionManager = (ActExecutionManager)AppUtil.getBean(ActExecutionManager.class);
        ActExecution currentExecution = (ActExecution)actExecutionManager.get((Serializable)((Object)rejectDirectExecutionId));
        TaskFinishCmd cmd = (TaskFinishCmd)ContextThreadUtil.getActionCmd();
        if (currentExecution == null) {
            return true;
        }
        Object rejectDirectParentId = cmd.getTransitVars("rejectDirectParentId");
        if (rejectDirectParentId != null && !rejectDirectParentId.toString().equals(currentExecution.getParentId()) && currentExecution.getParentId().equals(currentExecution.getProcInstId()) && BeanUtils.isNotEmpty(parentsId = actExecutionManager.getByParentsId(currentExecution.getParentId())) && parentsId.size() > 1) {
            for (String parentId : parentsId) {
                if (parentId.equals(currentExecution.getId())) continue;
                currentExecution.setParentId(parentId);
                actExecutionManager.update((Model)currentExecution);
                break;
            }
        }
        return true;
    }

    public static boolean parallelGatewayRejectDirectAdjust(String parentExecutionId) {
        List<String> parentsId;
        ActExecutionManager actExecutionManager = (ActExecutionManager)AppUtil.getBean(ActExecutionManager.class);
        ActExecution parentExecution = (ActExecution)actExecutionManager.get((Serializable)((Object)parentExecutionId));
        ActTaskManager actTaskManager = (ActTaskManager)AppUtil.getBean(ActTaskManager.class);
        if (parentExecution == null) {
            return true;
        }
        String actProcInstanceId = parentExecution.getProcInstId();
        TaskFinishCmd cmd = (TaskFinishCmd)ContextThreadUtil.getActionCmd();
        String rejectTargetNodeId = cmd.getDestination();
        String actionName = cmd.getActionName();
        if (StringUtil.isNotEmpty((String)rejectTargetNodeId) && !"reject".equals(actionName) && !"backToStart".equals(actionName) && BeanUtils.isNotEmpty(parentsId = actExecutionManager.getByParentsId(parentExecution.getId()))) {
            ActExecution currentExecution = (ActExecution)actExecutionManager.get((Serializable)((Object)parentsId.get(0)));
            if (parentExecution.isConcurrent() && !parentExecutionId.equals(parentExecution.getProcInstId())) {
                parentExecution.setActive(true);
                parentExecution.setActId(currentExecution.getActId());
                actExecutionManager.update((Model)parentExecution);
                List<ActTask> actTasks = actTaskManager.getByInstId(actProcInstanceId);
                if (BeanUtils.isNotEmpty(actTasks)) {
                    for (ActTask actTask : actTasks) {
                        if (actTask.getTaskDefKey() == null || !actTask.getTaskDefKey().equals(parentExecution.getActId())) continue;
                        actTask.setExecutionId(parentExecutionId);
                        actTaskManager.update((Model)actTask);
                    }
                }
                actExecutionManager.remove((Serializable)((Object)currentExecution.getId()));
            }
        }
        return true;
    }

    public static boolean singleInstancesRejectAdjust(String rejectSingleExecutionId) {
        ActExecutionManager actExecutionManager = (ActExecutionManager)AppUtil.getBean(ActExecutionManager.class);
        BpmExeStackManager bpmExeStackManager = (BpmExeStackManager)AppUtil.getBean(BpmExeStackManager.class);
        ActTaskManager actTaskManager = (ActTaskManager)AppUtil.getBean(ActTaskManager.class);
        ActExecution currentExecution = (ActExecution)actExecutionManager.get((Serializable)((Object)rejectSingleExecutionId));
        if (currentExecution == null) {
            return true;
        }
        String actProcInstanceId = currentExecution.getProcInstId();
        bpmExeStackManager.multipleInstancesRejectAdjustOnActTask(rejectSingleExecutionId);
        bpmExeStackManager.multipleInstancesRejectAdjustOnActExecution(actProcInstanceId);
        if (actExecutionManager.get((Serializable)((Object)currentExecution.getId())) == null) {
            currentExecution.setParentId(actProcInstanceId);
            currentExecution.setScope(true);
            currentExecution.setConcurrent(false);
            actExecutionManager.create((Model)currentExecution);
            List<ActTask> actTasks = actTaskManager.getByInstId(actProcInstanceId);
            if (BeanUtils.isNotEmpty(actTasks)) {
                for (ActTask actTask : actTasks) {
                    actTask.setExecutionId(currentExecution.getId());
                    actTaskManager.update((Model)actTask);
                }
            }
        }
        return true;
    }

    public static boolean multipleInstancesRejectAdjust(String rejectAfterExecutionId) {
        ActExecutionManager actExecutionManager = (ActExecutionManager)AppUtil.getBean(ActExecutionManager.class);
        BpmExeStackManager bpmExeStackManager = (BpmExeStackManager)AppUtil.getBean(BpmExeStackManager.class);
        ActExecution currentExecution = (ActExecution)actExecutionManager.get((Serializable)((Object)rejectAfterExecutionId));
        if (currentExecution == null) {
            return true;
        }
        String nodeId = currentExecution.getActId();
        String actProcInstanceId = currentExecution.getProcInstId();
        bpmExeStackManager.multipleInstancesRejectAdjustOnBpmTask(rejectAfterExecutionId);
        bpmExeStackManager.multipleInstancesRejectAdjustOnActTask(rejectAfterExecutionId);
        bpmExeStackManager.multipleInstancesRejectAdjustOnActExecution(actProcInstanceId);
        currentExecution = (ActExecution)actExecutionManager.get((Serializable)((Object)actProcInstanceId));
        currentExecution.setActId(nodeId);
        actExecutionManager.update((Model)currentExecution);
        return true;
    }

    public static List<BpmNodeDef> getAfterListNode(String defId, String nodeId) throws Exception {
        ArrayList<BpmNodeDef> listResult = new ArrayList<BpmNodeDef>();
        return BpmStackRelationUtil.getAfterListNode(defId, nodeId, listResult);
    }

    private static List<BpmNodeDef> getAfterListNode(String defId, String nodeId, List<BpmNodeDef> listResult) throws Exception {
        BpmDefinitionAccessor bpmDefinitionAccessor = (BpmDefinitionAccessor)AppUtil.getBean((String)"bpmDefinitionAccessor");
        BpmNodeDef nodeDef = bpmDefinitionAccessor.getBpmNodeDef(defId, nodeId);
        List<BpmNodeDef> listOut = nodeDef.getOutcomeNodes();
        for (BpmNodeDef outNode : listOut) {
            if (outNode.getType().getKey().equals(NodeType.USERTASK.getKey())) {
                listResult.add(outNode);
                continue;
            }
            BpmStackRelationUtil.getAfterListNode(defId, outNode.getNodeId(), listResult);
        }
        return listResult;
    }
}

