package com.artfess.workflow.bpmModel.controller;

import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.StringUtil;
import com.artfess.bpm.persistence.manager.BpmWatermarkProcessManager;
import com.artfess.bpm.persistence.model.BpmWatermarkProcess;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.List;

/**
 * 
 * <pre> 
 * 描述：水印分配流程 控制器类
 * 构建组：x7
 * 作者:zjq
 * 邮箱:zjq@jee-soft.cn
 * 日期:2020-12-23 17:12:58
 * 版权：广州宏天软件股份有限公司
 * </pre>
 */
@RestController
@RequestMapping(value="/bpmModel/bpmWatermarkProcess/v1")
@Api(tags="bpmWatermarkProcessController")
public class BpmWatermarkProcessController extends BaseController<BpmWatermarkProcessManager,BpmWatermarkProcess>{
	@Resource
	BpmWatermarkProcessManager bpmWatermarkProcessManager;
	
	/**
	 * 水印分配流程列表(分页条件查询)数据
	 * @param queryFilter
	 * @return
	 * @throws Exception 
	 * PageJson
	 * @exception 
	 */
	@PostMapping("/listJson")
	@ApiOperation(value="水印分配流程数据列表", httpMethod = "POST", notes = "获取水印分配流程列表")
	public PageList<BpmWatermarkProcess> list(@ApiParam(name="queryFilter",value="查询对象")@RequestBody QueryFilter queryFilter) throws Exception{
		return bpmWatermarkProcessManager.query(queryFilter);
	}
	
	/**
	 * 水印分配流程明细页面
	 * @param id
	 * @return
	 * @throws Exception 
	 * ModelAndView
	 */
	@GetMapping(value="/getJson")
	@ApiOperation(value="水印分配流程数据详情",httpMethod = "GET",notes = "水印分配流程数据详情")
	public BpmWatermarkProcess get(@ApiParam(name="id",value="业务对象主键", required = true)@RequestParam String id) throws Exception{
		return bpmWatermarkProcessManager.get(id);
	}
	
    /**
	 * 新增水印分配流程
	 * @param bpmWatermarkProcess
	 * @throws Exception 
	 * @return
	 * @exception 
	 */
	@PostMapping(value="save")
	@ApiOperation(value = "新增,更新水印分配流程数据", httpMethod = "POST", notes = "新增,更新水印分配流程数据")
	public CommonResult<String> save(@ApiParam(name="bpmWatermarkProcess",value="水印分配流程业务对象", required = true)@RequestBody BpmWatermarkProcess bpmWatermarkProcess) throws Exception{
		String msg = "添加水印分配流程成功";
		if(StringUtil.isEmpty(bpmWatermarkProcess.getId())){
			bpmWatermarkProcessManager.create(bpmWatermarkProcess);
		}else{
			bpmWatermarkProcessManager.update(bpmWatermarkProcess);
			 msg = "更新水印分配流程成功";
		}
		return new CommonResult<String>(msg);
	}
	
	/**
	 * 批量删除水印分配流程记录
	 * @param ids
	 * @throws Exception 
	 * @return
	 * @exception 
	 */
	@DeleteMapping(value="/remove")
	@ApiOperation(value = "批量删除水印分配流程记录", httpMethod = "DELETE", notes = "批量删除水印分配流程记录")
	public CommonResult<String> removes(@ApiParam(name="ids",value="业务主键数组,多个业务主键之间用逗号分隔", required = true)@RequestParam String...ids) throws Exception{
		bpmWatermarkProcessManager.removeByIds(ids);
		return new CommonResult<String>(true, "批量删除成功");
	}

	/**
	 * 批量添加
	 * @param watermarkProcesses
	 * @param isAllSave 是否全部保存，1为是，0为否
	 * @return
	 */
	@PostMapping(value="/batchAdd")
	@ApiOperation(value = "批量添加", httpMethod = "POST", notes = "批量添加")
	public CommonResult<String> batchAdd(
			@ApiParam(name="ids",value="业务主键数组,多个业务主键之间用逗号分隔", required = true) @RequestBody List<BpmWatermarkProcess> watermarkProcesses,@RequestParam(value="isAllSave") int isAllSave){
		bpmWatermarkProcessManager.batchAdd(watermarkProcesses, isAllSave);
		return new CommonResult<>(true,"添加成功");
	}

	@PostMapping(value="/isExist")
	@ApiOperation(value = "是否存在", httpMethod = "POST", notes = "是否存在")
	public CommonResult<String> isExist(
			@ApiParam(name="ids",value="业务主键数组,多个业务主键之间用逗号分隔", required = true) @RequestBody List<BpmWatermarkProcess> watermarkProcesses){
		return bpmWatermarkProcessManager.isExist(watermarkProcesses);
	}
}
