package com.artfess.uc.model;

import com.artfess.base.entity.BizDelModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;

import java.time.LocalDateTime;

import com.baomidou.mybatisplus.annotation.TableId;

import java.io.Serializable;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 用户注册审核记录表
 *
 * @author 系统管理员
 * @company 阿特菲斯信息技术有限公司
 * @since 2025-02-11
 */
@ApiModel(value = "BizUserApprovalRecord对象", description = "用户注册审核记录表")
@TableName("biz_user_approval_record")
@Data
@EqualsAndHashCode(callSuper = true)
public class BizUserApprovalRecord extends BizDelModel<BizUserApprovalRecord> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "id_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "用户ID")
    @TableField("user_id_")
    private String userId;

    @ApiModelProperty(value = "审批节点名称（目前有提交申请、管理员审核）")
    @TableField("approval_node_")
    private String approvalNode;

    @ApiModelProperty(value = "审批人ID")
    @TableField("approval_user_id_")
    private String approvalUserId;

    @ApiModelProperty(value = "审批人账号")
    @TableField("approval_user_account_")
    private String approvalUserAccount;

    @ApiModelProperty(value = "审批人姓名")
    @TableField("approval_user_name_")
    private String approvalUserName;

    @ApiModelProperty(value = "审批人组织ID")
    @TableField("approval_org_id_")
    private String approvalOrgId;

    @ApiModelProperty(value = "审批人组织名称")
    @TableField("approval_org_name_")
    private String approvalOrgName;

    @ApiModelProperty(value = "审批人单位ID")
    @TableField("approval_dept_id_")
    private String approvalDeptId;

    @ApiModelProperty(value = "审批人单位名称")
    @TableField("approval_dept_name_")
    private String approvalDeptName;

    @ApiModelProperty(value = "审批时间")
    @TableField("approval_date_")
    private LocalDateTime approvalDate;

    @ApiModelProperty(value = "办理时间（使用此次审批时间减去上一次审批时间），单位：秒")
    @TableField("processing_time_")
    private Long processingTime;

    @ApiModelProperty(value = "审批意见")
    @TableField("intranet_port_")
    private String intranetPort;

    @ApiModelProperty(value = "审批结果（-1:未处理 0：驳回，1：同意,3:发起）")
    @TableField("approval_result_")
    private Integer approvalResult;
}
