package com.artfess.uc.controller;


import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

import io.swagger.annotations.ApiParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.util.BeanUtils;
import com.artfess.uc.manager.UserUniteManager;
import com.artfess.uc.model.UserUnite;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

/**
 * 用户与外部通讯录关系表 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author pangquan
 * @since 2020-10-30
 */
@RestController
@RequestMapping("/uc/userUnite/v1/")
@Api(tags="用户与外部通讯录关系")
@ApiGroup(group= {ApiGroupConsts.GROUP_UC})
public class UserUniteController extends BaseController<UserUniteManager, UserUnite> {


	@RequestMapping(value = "removes", method = RequestMethod.DELETE, produces = {"application/json; charset=utf-8"})
	@ApiOperation(value = "批量删除绑定第三方的用户信息", httpMethod = "DELETE", notes = "批量删除绑定第三方的用户信息")
	public CommonResult<String> batchRemove(@ApiParam(name = "ids", value = "主键集合", required = true) @RequestParam String... ids) throws Exception {
		try {
			this.baseService.removeByIds(Arrays.asList(ids));
			return new CommonResult<String>("删除成功");
		} catch (Exception e) {
			return new CommonResult<String>(false, "删除失败");
		}
	}

	@PostMapping("updateUserUnite")
	@ApiOperation(value = "更新", httpMethod = "POST", notes = "更新")
	public CommonResult<String> updateUserUnite(@RequestBody UserUnite userUnite){
		this.baseService.updateUserUnite(userUnite);
		
		return new CommonResult<String>("更新成功");
	}
	@PostMapping("save")
	@ApiOperation(value = "保存", httpMethod = "POST", notes = "保存")
	public CommonResult<String> save(@RequestBody UserUnite userUnite){
		if(BeanUtils.isNotEmpty(userUnite.getId())){
			this.baseService.update(userUnite);
		}else{
			this.baseService.create(userUnite);
		}
		
		return new CommonResult<String>("更新成功");
	}
	/**
	 * 根据企业微信通讯录userid获取数据
	 * @param wxWorkId
	 * @return
	 */
	@GetMapping("getUserUniteByWxWorkId")
	@ApiOperation(value = "根据企业微信通讯录userid获取数据", httpMethod = "POST", notes = "根据企业微信通讯录userid获取数据")
	public Object getUserUniteByWxWorkId(@RequestParam(value="wxWorkId",required=true) String wxWorkId){
		QueryWrapper<UserUnite> queryWrapper = new QueryWrapper<UserUnite>().eq("WX_WORK_ID_", wxWorkId);
		UserUnite exist = this.baseService.getOne(queryWrapper);
		return exist;
	}
	/**
	 * 根据用户id获取数据
	 * @param userId
	 * @return
	 */
	@GetMapping("/getByUserId/{userId}")
	@ApiOperation(value = "根据用户id获取数据", httpMethod = "GET", notes = "根据用户id获取数据")
	public UserUnite getByUserId(@PathVariable String userId){
		QueryWrapper<UserUnite> queryWrapper = new QueryWrapper<UserUnite>().eq("USER_ID_", userId);
		UserUnite exist = this.baseService.getOne(queryWrapper);
		return exist;
	}
	/**
	 * 根据userIds获取钉钉ids
	 * @param userIds
	 * @return
	 */
	@GetMapping("/getDingtalkIdsByUserIds")
	@ApiOperation(value = "根据userIds获取钉钉ids", httpMethod = "GET", notes = "根据userIds获取钉钉ids")
	public String getDingtalkIdsByUserIds(@RequestParam(value="userIds",required=true) String userIds){
		if(BeanUtils.isNotEmpty(userIds)){
			Object[] userIdList = userIds.split(",");
			QueryWrapper<UserUnite> queryWrapper = new QueryWrapper<UserUnite>();
			queryWrapper.in("USER_ID_", userIdList);
			List<UserUnite> list = this.baseService.list(queryWrapper);
			if(BeanUtils.isNotEmpty(list)){
				List<String> dingtalkIds = list.stream().filter(e->BeanUtils.isNotEmpty(e.getDingtalkId())).
														map(UserUnite::getDingtalkId).collect(Collectors.toList());
				if(BeanUtils.isNotEmpty(dingtalkIds)){
					return String.join(",", dingtalkIds);
				}
			}
		}
		return "";
	}
	/**
	 * 根据userIds获取企业微信ids
	 * @param userIds
	 * @return
	 */
	@GetMapping("/getWxWorkIdsByUserIds")
	@ApiOperation(value = "根据userIds获取企业微信ids", httpMethod = "GET", notes = "根据userIds获取企业微信ids")
	public String getWxWorkIdsByUserIds(@RequestParam(value="userIds",required=true) String userIds){
		if(BeanUtils.isNotEmpty(userIds)){
			Object[] userIdList = userIds.split(",");
			QueryWrapper<UserUnite> queryWrapper = new QueryWrapper<UserUnite>();
			queryWrapper.in("USER_ID_", userIdList);
			List<UserUnite> list = this.baseService.list(queryWrapper);
			if(BeanUtils.isNotEmpty(list)){
				List<String> wxWorkIds = list.stream().filter(e->BeanUtils.isNotEmpty(e.getWxWorkId())).
						map(UserUnite::getWxWorkId).collect(Collectors.toList());
				if(BeanUtils.isNotEmpty(wxWorkIds)){
					return String.join(",", wxWorkIds);
				}
			}
		}
		return "";
	}
	
	/**
	 * 根据userIds获取公众号openids
	 * @param userIds
	 * @return
	 */
	@GetMapping("/getOpenIdsByUserIds")
	@ApiOperation(value = "根据userIds获取公众号openids", httpMethod = "GET", notes = "根据userIds获取公众号openids")
	public String getOpenIdsByUserIds(@RequestParam(value="userIds",required=true) String userIds){
		if(BeanUtils.isNotEmpty(userIds)){
			Object[] userIdList = userIds.split(",");
			QueryWrapper<UserUnite> queryWrapper = new QueryWrapper<UserUnite>();
			queryWrapper.in("USER_ID_", userIdList);
			List<UserUnite> list = this.baseService.list(queryWrapper);
			if(BeanUtils.isNotEmpty(list)){
				List<String> getOpenId = list.stream().filter(e->BeanUtils.isNotEmpty(e.getOpenId())).
						map(UserUnite::getOpenId).collect(Collectors.toList());
				if(BeanUtils.isNotEmpty(getOpenId)){
					return String.join(",", getOpenId);
				}
			}
		}
		return "";
	}
}
