/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.uc.openApi.vo;

import cn.hutool.core.util.StrUtil;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.slf4j.MDC;
import org.springframework.context.annotation.DependsOn;

@ApiModel
@DependsOn
public class Response<T> {
    @ApiModelProperty(notes="\u54cd\u5e94\u7801\uff0c\u975e0 \u5373\u4e3a\u5f02\u5e38", example="0")
    private final String code;
    @ApiModelProperty(notes="\u54cd\u5e94\u6d88\u606f", example="\u63d0\u4ea4\u6210\u529f")
    private final String msg;
    @ApiModelProperty(notes="\u54cd\u5e94\u6570\u636e")
    private final T data;
    @ApiModelProperty(notes="\u8bf7\u6c42id")
    private final String requestId;
    @ApiModelProperty(notes="\u8bf7\u6c42id")
    private final Boolean success;

    public Response(String code, String msg, T data) {
        this.code = code;
        this.msg = msg;
        this.data = data;
        this.success = StrUtil.equals((CharSequence)"0", (CharSequence)code);
        this.requestId = MDC.get((String)"requestId");
    }

    public static <T> Response<T> ok(String msg, T data) {
        return new Response<T>("0", msg, data);
    }

    public static <T> Response<T> ok(T data) {
        return new Response<T>("0", "\u64cd\u4f5c\u6210\u529f", data);
    }

    public static <T> Response<Void> ok() {
        return new Response<Object>("0", "\u64cd\u4f5c\u6210\u529f", null);
    }

    public static <T> Response<T> error(T data) {
        return new Response<T>("500", "", data);
    }

    public static <T> Response<T> error(String code, String msg, T data) {
        return new Response<T>(code, msg, data);
    }

    public static <T> Response<T> error(String code, String msg) {
        return new Response<Object>(code, msg, null);
    }

    public String getCode() {
        return this.code;
    }

    public String getMsg() {
        return this.msg;
    }

    public T getData() {
        return this.data;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public Boolean getSuccess() {
        return this.success;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Response)) {
            return false;
        }
        Response other = (Response)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$code = this.getCode();
        String other$code = other.getCode();
        if (this$code == null ? other$code != null : !this$code.equals(other$code)) {
            return false;
        }
        String this$msg = this.getMsg();
        String other$msg = other.getMsg();
        if (this$msg == null ? other$msg != null : !this$msg.equals(other$msg)) {
            return false;
        }
        T this$data = this.getData();
        T other$data = other.getData();
        if (this$data == null ? other$data != null : !this$data.equals(other$data)) {
            return false;
        }
        String this$requestId = this.getRequestId();
        String other$requestId = other.getRequestId();
        if (this$requestId == null ? other$requestId != null : !this$requestId.equals(other$requestId)) {
            return false;
        }
        Boolean this$success = this.getSuccess();
        Boolean other$success = other.getSuccess();
        return !(this$success == null ? other$success != null : !((Object)this$success).equals(other$success));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Response;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : $code.hashCode());
        String $msg = this.getMsg();
        result = result * 59 + ($msg == null ? 43 : $msg.hashCode());
        T $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        String $requestId = this.getRequestId();
        result = result * 59 + ($requestId == null ? 43 : $requestId.hashCode());
        Boolean $success = this.getSuccess();
        result = result * 59 + ($success == null ? 43 : ((Object)$success).hashCode());
        return result;
    }

    public String toString() {
        return "Response(code=" + this.getCode() + ", msg=" + this.getMsg() + ", data=" + this.getData() + ", requestId=" + this.getRequestId() + ", success=" + this.getSuccess() + ")";
    }

    public Response(String code, String msg, T data, String requestId, Boolean success) {
        this.code = code;
        this.msg = msg;
        this.data = data;
        this.requestId = requestId;
        this.success = success;
    }
}

