/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.file.util;

import java.io.File;
import java.util.Arrays;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.jodconverter.core.office.OfficeException;
import org.jodconverter.core.office.OfficeManager;
import org.jodconverter.local.LocalConverter;
import org.jodconverter.local.office.LocalOfficeManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class LibreOfficeConverterUtils {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value(value="${file.office.home}")
    private String officeHome;
    @Value(value="${file.office.enable:false}")
    private boolean fileEnable;
    @Value(value="${file.office.port:9693}")
    private String officePorts;
    private LocalOfficeManager officeManager;

    @PostConstruct
    public void startOfficeManager() {
        if (this.fileEnable && this.officeHome != null && !this.officeHome.isEmpty()) {
            this.logger.info("\u5f00\u59cb\u6ce8\u5165officeManager,{}", (Object)this.officeHome);
            int[] officePortList = Arrays.stream(this.officePorts.split(",")).mapToInt(Integer::parseInt).toArray();
            this.officeManager = LocalOfficeManager.builder().officeHome(this.officeHome).portNumbers(officePortList).build();
            try {
                this.officeManager.start();
                this.logger.info("OfficeManager\u542f\u52a8\u6210\u529f");
            }
            catch (org.artofsolving.jodconverter.office.OfficeException | OfficeException e) {
                throw new RuntimeException("\u542f\u52a8OfficeManager\u5931\u8d25", e);
            }
        }
    }

    public void convert(File inputFile, File outputFile) {
        if (this.officeManager == null) {
            throw new RuntimeException("OfficeManager\u672a\u542f\u52a8");
        }
        try {
            LocalConverter.make((OfficeManager)this.officeManager).convert(inputFile).to(outputFile).execute();
            this.logger.info("\u8f6c\u6362\u6210\u529f");
        }
        catch (org.artofsolving.jodconverter.office.OfficeException | OfficeException e) {
            throw new RuntimeException("\u8f6c\u6362\u5931\u8d25", e);
        }
    }

    @PreDestroy
    public void stopOfficeManager() {
        if (this.officeManager != null) {
            try {
                this.officeManager.stop();
                this.logger.info("OfficeManager\u505c\u6b62\u6210\u529f");
            }
            catch (org.artofsolving.jodconverter.office.OfficeException | OfficeException e) {
                this.logger.error("\u505c\u6b62OfficeManager\u5931\u8d25", e);
            }
        }
    }
}

