package com.artfess.portal.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.artfess.base.cache.annotation.CacheEvict;
import com.artfess.base.constants.CacheKeyConst;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.StringUtil;
import com.artfess.portal.model.PortalDataSensitive;
import com.artfess.portal.persistence.manager.PortalDataSensitiveManager;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;

/**
 * <pre>
 * 描述：表字段脱敏处理 控制器类
 * 构建组：x7
 * 作者:heyf
 * 邮箱:heyf@jee-soft.cn
 * 日期:2020-07-27 16:01:10
 * 版权：广州宏天软件股份有限公司
 * </pre>
 */
@RestController
@RequestMapping(value = "/portal/portalDataSensitive/v1")
@Api(tags = "portalDataSensitiveController")
public class PortalDataSensitiveController extends BaseController<PortalDataSensitiveManager, PortalDataSensitive> {
    @Resource
    PortalDataSensitiveManager portalDataSensitiveManager;

    /**
     * 表字段脱敏处理列表(分页条件查询)数据
     *
     * @param queryFilter
     * @return
     * @throws Exception PageJson
     * @throws
     */
    @PostMapping("/listJson")
    @ApiOperation(value = "表字段脱敏处理数据列表", httpMethod = "POST", notes = "获取表字段脱敏处理列表")
    public PageList<PortalDataSensitive> list(@ApiParam(name = "queryFilter", value = "查询对象") @RequestBody QueryFilter queryFilter) throws Exception {
        return portalDataSensitiveManager.query(queryFilter);
    }

    /**
     * 表字段脱敏处理明细页面
     *
     * @param id
     * @return
     * @throws Exception ModelAndView
     */
    @GetMapping(value = "/getJson")
    @ApiOperation(value = "表字段脱敏处理数据详情", httpMethod = "GET", notes = "表字段脱敏处理数据详情")
    public PortalDataSensitive get(@ApiParam(name = "id", value = "业务对象主键", required = true) @RequestParam String id) throws Exception {
        return portalDataSensitiveManager.get(id);
    }

    /**
     * 新增表字段脱敏处理
     *
     * @param portalDataSensitive
     * @return
     * @throws Exception
     * @throws
     */
    @PostMapping(value = "save")
    @ApiOperation(value = "新增,更新表字段脱敏处理数据", httpMethod = "POST", notes = "新增,更新表字段脱敏处理数据")
    @CacheEvict(value = CacheKeyConst.EIP_SYS_DATA_SENSITIVE, key = "#portalDataSensitive.tableName.toLowerCase()")
    public CommonResult<String> save(@ApiParam(name = "portalDataSensitive", value = "表字段脱敏处理业务对象", required = true) @RequestBody PortalDataSensitive portalDataSensitive) throws Exception {
        String msg = "添加表字段脱敏处理成功";
        if (StringUtil.isEmpty(portalDataSensitive.getId())) {
            portalDataSensitiveManager.create(portalDataSensitive);
        } else {
            portalDataSensitiveManager.update(portalDataSensitive);
            msg = "更新表字段脱敏处理成功";
        }
        return new CommonResult<String>(msg);
    }

    /**
     * 批量删除表字段脱敏处理记录
     *
     * @param ids
     * @return
     * @throws Exception
     * @throws
     */
    @DeleteMapping(value = "/remove")
    @ApiOperation(value = "批量删除表字段脱敏处理记录", httpMethod = "DELETE", notes = "批量删除表字段脱敏处理记录")
    @CacheEvict(value = CacheKeyConst.EIP_SYS_DATA_SENSITIVE, allEntries = true, ignoreException = false)
    public CommonResult<String> removes(@ApiParam(name = "ids", value = "业务主键数组,多个业务主键之间用逗号分隔", required = true) @RequestParam String... ids) throws Exception {
        portalDataSensitiveManager.removeByIds(ids);
        return new CommonResult<String>(true, "批量删除成功");
    }

    /**
     * 表字段脱敏处理明细页面
     *
     * @param dataSourceAlias
     * @param tableName
     * @return
     * @throws Exception ModelAndView
     */
    @GetMapping(value = "/getByDsNameAndTableName")
    @ApiOperation(value = "表字段脱敏处理数据详情", httpMethod = "GET", notes = "表字段脱敏处理数据详情")
    public CommonResult<PortalDataSensitive> getByDsNameAndTableName(@ApiParam(name = "dataSourceAlias", value = "数据源", required = false) @RequestParam String dataSourceAlias, @ApiParam(name = "tableName", value = "表名", required = true) @RequestParam String tableName) throws Exception {
        if (StringUtil.isEmpty(dataSourceAlias)) {
            dataSourceAlias = "local";
        }
        PortalDataSensitive portalDataSensitive = portalDataSensitiveManager.getByDsNameAndTableName(dataSourceAlias, tableName.toLowerCase());
        return new CommonResult<PortalDataSensitive>(true, "", portalDataSensitive);
    }

    @GetMapping(value = "/getByTableName/{tableName}")
    @ApiOperation(value = "是否存在此配置", httpMethod = "POST", notes = "是否存在此配置")
    public PortalDataSensitive isExist(@ApiParam(name = "实体", value = "实体", required = true) @PathVariable String tableName) throws Exception {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq("table_name_", tableName.toLowerCase());
        return baseService.getOne(wrapper);
    }
}
