package com.artfess.portal.kh.model;

import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;

/**
 * 考核评级方案详情
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2024-02-20
 */
@ApiModel(value="KhAssessDetails对象", description="考核评级方案详情")
public class KhAssessDetails extends BaseModel<KhAssessDetails> {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "方案ID")
    @TableField("assess_id_")
    private String assessId;

    @ApiModelProperty(value = "名称")
    @TableField("name_")
    private String name;

    @ApiModelProperty(value = "最大值")
    @TableField("max_value_")
    private Double maxValue;

    @ApiModelProperty(value = "最小值")
    @TableField("min_value_")
    private Double minValue;

    @ApiModelProperty(value = "说明")
    @TableField("memo_")
    private String memo;

    @ApiModelProperty(value = "是否已删，1已删除，0未删除")
    @TableField("is_dele_")
    private String isDele;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getAssessId() {
        return assessId;
    }

    public void setAssessId(String assessId) {
        this.assessId = assessId;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Double getMaxValue() {
        return maxValue;
    }

    public void setMaxValue(Double maxValue) {
        this.maxValue = maxValue;
    }

    public Double getMinValue() {
        return minValue;
    }

    public void setMinValue(Double minValue) {
        this.minValue = minValue;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public String getIsDele() {
        return isDele;
    }

    public void setIsDele(String isDele) {
        this.isDele = isDele;
    }


    @Override
    protected Serializable pkVal() {
        return this.id;
    }

    @Override
    public String toString() {
        return "KhAssessDetails{" +
            "id=" + id +
            ", assessId=" + assessId +
            ", name=" + name +
            ", maxValue=" + maxValue +
            ", minValue=" + minValue +
            ", memo=" + memo +
            ", isDele=" + isDele +
        "}";
    }
}
