package com.artfess.gyl.supplierApply2.model;

import com.artfess.base.entity.AutoFillFullModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableLogic;

import java.time.LocalDate;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableField;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 供应商准入申请表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wubin
 * @since 2025-11-10
 */
@Data
@ApiModel(value="BizSupplierEnterpriseAccess对象", description="供应商准入申请表")
public class BizSupplierEnterpriseAccess extends AutoFillFullModel<BizSupplierEnterpriseAccess> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "准入申请流水号")
    @TableField("SUPPLIER_ACCESS_NUMBER_")
    private String supplierAccessNumber;

    @ApiModelProperty(value = "申请人ID")
    @TableField("APPLICANT_ACCOUNT_ID_")
    private String applicantAccountId;

    @ApiModelProperty(value = "申请人账号")
    @TableField("APPLICANT_ACCOUNT_")
    private String applicantAccount;

    @ApiModelProperty(value = "申请人姓名")
    @TableField("APPLICANT_NAME_")
    private String applicantName;

    @ApiModelProperty(value = "申请人组织编码")
    @TableField("APPLICANT_ORG_CODE_")
    private String applicantOrgCode;

    @ApiModelProperty(value = "申请人组织名称")
    @TableField("APPLICANT_ORG_NAME_")
    private String applicantOrgName;

    @ApiModelProperty(value = "申请时间")
    @TableField("APPLY_DATE")
    private LocalDate applyDate;

    @ApiModelProperty(value = "企业ID")
    @TableField("ENTERPRISE_ID_")
    private String enterpriseId;

    @ApiModelProperty(value = "企业编码（企业平台编码）")
    @TableField("ENTERPRISE_CODE_")
    private String enterpriseCode;

    @ApiModelProperty(value = "供应商ID")
    @TableField("SUPPLIER_ID_")
    private String supplierId;

    @ApiModelProperty(value = "供应商编码（企业平台编码）")
    @TableField("SUPPLIER_CODE_")
    private String supplierCode;

    @ApiModelProperty(value = "完成时间")
    @TableField("SELECTION_DATE")
    private LocalDate selectionDate;

    @ApiModelProperty(value = "推荐人")
    @TableField("REFERRER_")
    private String referrer;

    @ApiModelProperty(value = "推荐人部门")
    @TableField("RECOMMENDED_DEPARTMENT_")
    private String recommendedDepartment;

    @ApiModelProperty(value = "推荐理由（1质量优势，2价格优势，3新品开发需要，4现有资源不足（独家供货），5现有资源不足（产能不足），6储备供应商，7资质变更，8其他）")
    @TableField("DRIVING_REASONS_")
    private String drivingReasons;

    @ApiModelProperty(value = "供应商合作意愿（1一般，2强烈，3较强烈）")
    @TableField("COOPERATE_WILLINGNESS_")
    private String cooperateWillingness;

    @ApiModelProperty(value = "简要说明")
    @TableField("BRIEF_DESCRIPTION_")
    private String briefDescription;

    @ApiModelProperty(value = "创建方式（1企业直接添加，2供应商准入申请，3企业准入申请）")
    @TableField("CREATE_METHOD_")
    private String createMethod;

    @ApiModelProperty(value = "状态（0保存草稿，1提交申请，2基本情况审核，3确认评审方案，4现场评审，5评审报告，6样品试用，7准入报告（已完成），8取消）")
    @TableField("STATUS_")
    private String status;

    @ApiModelProperty(value = "评审结果（1试用供应商，2合格供应商，3淘汰）")
    @TableField("REVIEW_RESULTS_")
    private String reviewResults;

    @ApiModelProperty(value = "备注")
    @TableField("REMARKS_")
    private String remarks;

    @TableLogic
    @ApiModelProperty(value = "是否已删，1已删除，0未删除")
    @TableField("IS_DELE_")
    private String isDele;

    @ApiModelProperty(value = "版本号")
    @TableField("VERSION_")
    private Long version;

    @ApiModelProperty(value = "租户ID")
    @TableField("TENANT_ID_")
    private String tenantId;
}
