package com.artfess.gyl.supplierAccess.vo;

import com.artfess.base.util.BeanUtils;
import com.artfess.gyl.supplierAccess.model.BizSupplierReviewConfiguration;
import com.artfess.gyl.supplierAccess.model.BizSupplierReviewConfigurationDetails;
import com.baomidou.mybatisplus.annotation.TableLogic;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Map;

/**
 * 供应商准入评审评分配置表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wubin
 * @since 2025-11-09
 */
@Data
@ApiModel(value="BizSupplierReviewConfigurationVo对象", description="供应商准入评审评分配置表")
public class BizSupplierReviewConfigurationVo {
    @ApiModelProperty(value = "主键_ID")
    private String id;

    @ApiModelProperty(value = "企业ID")
    private String enterpriseId;

    @ApiModelProperty(value = "企业编码")
    private String enterpriseCode;

    @ApiModelProperty(value = "配置编码")
    private String code;

    @ApiModelProperty(value = "配置名称")
    private String name;

    @ApiModelProperty(value = "基础物料分类ID")
    private String categoryId;

    @ApiModelProperty(value = "基础物料分类编号")
    private String categoryPlatcode;

    @ApiModelProperty(value = "评审要求")
    private String desc;

    @ApiModelProperty(value = "总分值")
    private Integer totalScore;

    @ApiModelProperty(value = "状态(1：启用，0：禁用)")
    private String status;

    @ApiModelProperty(value = "排序号")
    private Integer seq;

    @ApiModelProperty(value = "备注")
    private String remarks;

    @TableLogic
    @ApiModelProperty(value = "是否已删，1已删除，0未删除")
    private String isDele;

    @ApiModelProperty(value = "供应商准入评审评分配置指标明细")
    private Map<String, List<BizSupplierReviewConfigurationDetails>> detailsMap;

    public void copy(BizSupplierReviewConfiguration source){
        try {
            BeanUtils.copyNotNullProperties(this,source);
        } catch (IllegalAccessException e) {
            e.printStackTrace();
        } catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }
}
