package com.artfess.gyl.base.model;

import com.artfess.base.entity.BizDelModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.List;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 供应商分级管理表
 *
 * @author 系统管理员
 * @since 2025-11-07
 */
@Data
@TableName("BIZ_SUPPLIER_GRADING_CONFIGURATION")
@ApiModel(value="BizSupplierGradingConfiguration对象", description="供应商分级管理表")
public class BizSupplierGradingConfiguration extends BizDelModel<BizSupplierGradingConfiguration> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "分级编码")
    @TableField("CODE_")
    private String code;

    @ApiModelProperty(value = "分级名称")
    @TableField("NAME_")
    private String name;

    @ApiModelProperty(value = "状态(1：启用，0：禁用))")
    @TableField("STATUS_")
    private String status;

    @ApiModelProperty(value = "排序号")
    @TableField("SEQ_")
    private Integer seq;

    @ApiModelProperty(value = "备注")
    @TableField("REMARKS_")
    private String remarks;

    @ApiModelProperty(value = "供应商分类名称")
    @TableField(exist = false)
    private String supplierNames;

    @ApiModelProperty(value = "分类关联")
    @TableField(exist = false)
    private List<BizSupplierGradingSupplyScope> scopes;
}
