package com.artfess.gyl.base.manager.impl;

import com.artfess.base.util.StringUtil;
import com.artfess.gyl.base.model.BizSupplierMaterialCategory;
import com.artfess.gyl.base.dao.BizSupplierMaterialCategoryDao;
import com.artfess.gyl.base.manager.BizSupplierMaterialCategoryManager;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.sysConfig.persistence.manager.SysIdentityManager;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;

/**
 * 物资分类表 服务实现类
 *
 * @author 系统管理员
 * @since 2025-11-06
 */
@Service
public class BizSupplierMaterialCategoryManagerImpl extends BaseManagerImpl<BizSupplierMaterialCategoryDao, BizSupplierMaterialCategory> implements BizSupplierMaterialCategoryManager {

    @Resource
    private SysIdentityManager sysIdentityManager;

    @Override
    public boolean updateStatusById(String id, String status) {
        LambdaUpdateWrapper<BizSupplierMaterialCategory> wrapper = new LambdaUpdateWrapper<>();
        wrapper.eq(BizSupplierMaterialCategory::getId, id);
        wrapper.set(BizSupplierMaterialCategory::getStatus, status);
        return this.update(wrapper);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public boolean save(BizSupplierMaterialCategory entity){
        String no = sysIdentityManager.nextId("wzflbm");
        entity.setCode(no);
        if(StringUtil.isEmpty(entity.getStatus())){
            entity.setStatus("1");
        }
        return super.save(entity);
    }
}
