package com.artfess.gyl.base.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.model.CommonResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import com.artfess.base.controller.BaseController;
import com.artfess.gyl.base.model.BizSupplierQualificationCategory;
import com.artfess.gyl.base.manager.BizSupplierQualificationCategoryManager;

/**
 * 供应商资质类型表 前端控制器
 *
 * @author 系统管理员
 * @since 2025-11-08
 */
@RestController
@RequestMapping("/bizSupplierQualificationCategory/v1/")
@Api(tags = "供应商资质类型")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ_GYL})
public class BizSupplierQualificationCategoryController extends BaseController<BizSupplierQualificationCategoryManager, BizSupplierQualificationCategory> {

    @PostMapping("/updateByStatus")
    @ApiOperation(value = "根据id修改状态")
    public CommonResult<String> updateStatus(@RequestParam("id")String id, @RequestParam("status")String status) {
        boolean res = baseService.updateStatusById(id, status);
        return new CommonResult(res?"修改成功":"修改失败");
    }
}
