package com.artfess.gyl.thirdParty.manager;

import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.gyl.base.model.BizSupplierQualificationDatabase;
import com.artfess.gyl.thirdParty.model.BizCategory;
import com.artfess.base.manager.BaseManager;
import com.artfess.gyl.thirdParty.vo.CategoryNumVo;

import java.util.List;

/**
 *  服务类
 *
 * @author 系统管理员
 * @since 2025-11-10
 */
public interface BizCategoryManager extends BaseManager<BizCategory> {

    /**
     * 通用查询
     * @param queryFilter
     * @return
     */
    List<BizCategory> tree(QueryFilter<BizCategory> queryFilter);

    /**
     * 根据分类统计绑定情况
     * @param queryFilter
     * @return
     */
    List<CategoryNumVo> countByType(QueryFilter<BizCategory> queryFilter);
}
