package com.artfess.gyl.supplierEva.manager.impl;

import cn.hutool.core.lang.Assert;
import com.artfess.gyl.base.model.BizSupplierMaterialCategory;
import com.artfess.gyl.supplierEva.dto.ConfigurationDTO;
import com.artfess.gyl.supplierEva.manager.BizSupplierPerformanceEvaluationDetailsManager;
import com.artfess.gyl.supplierEva.manager.BizSupplierPerformanceEvaluationIntervalManager;
import com.artfess.gyl.supplierEva.model.BizSupplierPerformanceEvaluationConfiguration;
import com.artfess.gyl.supplierEva.dao.BizSupplierPerformanceEvaluationConfigurationDao;
import com.artfess.gyl.supplierEva.manager.BizSupplierPerformanceEvaluationConfigurationManager;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.gyl.supplierEva.model.BizSupplierPerformanceEvaluationDetails;
import com.artfess.gyl.supplierEva.model.BizSupplierPerformanceEvaluationInterval;
import com.artfess.gyl.supplierEva.vo.ConfigurationVo;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.List;

/**
 * 供应商绩效考核配置表 服务实现类
 *
 * @author huqi
 * @since 2025-11-11
 */
@Service
public class BizSupplierPerformanceEvaluationConfigurationManagerImpl extends BaseManagerImpl<BizSupplierPerformanceEvaluationConfigurationDao, BizSupplierPerformanceEvaluationConfiguration> implements BizSupplierPerformanceEvaluationConfigurationManager {

    @Resource
    private BizSupplierPerformanceEvaluationDetailsManager detailsManager;

    @Resource
    private BizSupplierPerformanceEvaluationIntervalManager intervalManager;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public boolean savaModel(ConfigurationDTO dto) {
        Assert.notNull(dto.getDetails(),"配置详情不能为空");
        Assert.notNull(dto.getIntervals(),"得分项不能为空");
        boolean save = super.save(dto);
        if (!save) {
            return false;
        }
        //更新评审详情
        List<BizSupplierPerformanceEvaluationDetails> details = dto.getDetails();
        details.forEach(detail -> {
            detail.setPerformanceEvaluationConfigurationId(dto.getId());
            detail.setStatus("1");
        });
        detailsManager.saveBatch(details);
       //更新评分项
        List<BizSupplierPerformanceEvaluationInterval> intervals = dto.getIntervals();
        intervals.forEach(detail -> {
            detail.setPerformanceEvaluationConfigurationId(dto.getId());
        });
        intervalManager.saveBatch(intervals);
        return true;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public boolean updateModel(ConfigurationDTO dto) {
        Assert.notNull(dto.getDetails(),"配置详情不能为空");
        Assert.notNull(dto.getIntervals(),"得分项不能为空");
        boolean update = super.updateById(dto);
        if (!update) {
            return false;
        }

        //删除之前评审项
        detailsManager.remove(new LambdaQueryWrapper<BizSupplierPerformanceEvaluationDetails>()
                .eq(BizSupplierPerformanceEvaluationDetails::getPerformanceEvaluationConfigurationId, dto.getId()));
        //更新评审详情
        List<BizSupplierPerformanceEvaluationDetails> details = dto.getDetails();
        details.forEach(detail -> {
            detail.setId(null);
            detail.setPerformanceEvaluationConfigurationId(dto.getId());
            detail.setStatus("1");
        });
        detailsManager.saveBatch(details);

        //删除之前评分项
        intervalManager.remove(new LambdaQueryWrapper<BizSupplierPerformanceEvaluationInterval>()
                .eq(BizSupplierPerformanceEvaluationInterval::getPerformanceEvaluationConfigurationId, dto.getId()));
        //更新评分项
        List<BizSupplierPerformanceEvaluationInterval> intervals = dto.getIntervals();
        intervals.forEach(detail -> {
            detail.setId(null);
            detail.setPerformanceEvaluationConfigurationId(dto.getId());
        });
        intervalManager.saveBatch(intervals);
        return true;
    }

    @Override
    @Transactional(readOnly = true)
    public ConfigurationVo getModel(String id) {
        BizSupplierPerformanceEvaluationConfiguration configuration = super.getById(id);
        ConfigurationVo vo = new ConfigurationVo(configuration);
        if (configuration != null) {
            List<BizSupplierPerformanceEvaluationDetails> details = detailsManager.list(new LambdaQueryWrapper<BizSupplierPerformanceEvaluationDetails>()
                    .eq(BizSupplierPerformanceEvaluationDetails::getPerformanceEvaluationConfigurationId, id));
            vo.setDetails(details);
            List<BizSupplierPerformanceEvaluationInterval> intervals = intervalManager.list(new LambdaQueryWrapper<BizSupplierPerformanceEvaluationInterval>()
                    .eq(BizSupplierPerformanceEvaluationInterval::getPerformanceEvaluationConfigurationId, id));
            vo.setIntervals(intervals);
        }
        return vo;
    }

    @Override
    public boolean updateStatusById(String id, String status) {
        LambdaUpdateWrapper<BizSupplierPerformanceEvaluationConfiguration> wrapper = new LambdaUpdateWrapper<>();
        wrapper.eq(BizSupplierPerformanceEvaluationConfiguration::getId, id);
        wrapper.set(BizSupplierPerformanceEvaluationConfiguration::getStatus, status);
        return this.update(wrapper);
    }
}
