package com.artfess.gyl.supplierApply2.model;

import com.artfess.base.entity.AutoFillFullModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 生产工艺流程表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wubin
 * @since 2025-11-11
 */
@Data
@ApiModel(value="BizSupplierProductionProcessFlow2对象", description="生产工艺流程表")
public class BizSupplierProductionProcessFlow2 extends AutoFillFullModel<BizSupplierProductionProcessFlow2> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "生产制造过程绩效表ID")
    @TableField("SUPPLIER_PRODUCTION_PROCESS_PERFORMANCE_ID_")
    private String supplierProductionProcessPerformanceId;

    @ApiModelProperty(value = "关键&重要过程")
    @TableField("KEY_IMPORTANT_PROCESS_")
    private String keyImportantProcess;

    @ApiModelProperty(value = "控制参数或特性")
    @TableField("CONTROL_PARAMETERS_CHARACTERISTICS_")
    private String controlParametersCharacteristics;

    @ApiModelProperty(value = "过程能力指数")
    @TableField("PROCESS_CAPABILITY_INDEX_")
    private String processCapabilityIndex;

    @ApiModelProperty(value = "是否已删，1已删除，0未删除")
    @TableField("IS_DELE_")
    private String isDele;

    @ApiModelProperty(value = "版本号")
    @TableField("VERSION_")
    private Long version;

    @ApiModelProperty(value = "租户ID")
    @TableField("TENANT_ID_")
    private String tenantId;
}
