package com.artfess.gyl.supplierApply2.model;

import com.artfess.base.entity.AutoFillFullModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 主营产品情况及质量业绩表-主营产品生产销售情况表2
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wubin
 * @since 2025-11-11
 */
@Data
@ApiModel(value="BizSupplierMainProductsSalesStatus2对象", description="主营产品情况及质量业绩表-主营产品生产销售情况表2")
public class BizSupplierMainProductsSalesStatus2 extends AutoFillFullModel<BizSupplierMainProductsSalesStatus2> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "主营产品情况及质量业绩ID")
    @TableField("SUPPLIER_MAIN_PRODUCTS_PERFORMANCE_ID_")
    private String supplierMainProductsPerformanceId;

    @ApiModelProperty(value = "产品种类")
    @TableField("PRODUCT_CATEGORY_")
    private String productCategory;

    @ApiModelProperty(value = "规格")
    @TableField("SPECIFICATIONS_")
    private String specifications;

    @ApiModelProperty(value = "近三年年产量")
    @TableField("PAST_THREE_YEARS_ANNUAL_PRODUCTION_")
    private String pastThreeYearsAnnualProduction;

    @ApiModelProperty(value = "交货周期")
    @TableField("DELIVERY_CYCLE_")
    private String deliveryCycle;

    @ApiModelProperty(value = "主要客户及市场")
    @TableField("MAIN_CUSTOMERS_MARKETS_")
    private String mainCustomersMarkets;

    @ApiModelProperty(value = "是否已删，1已删除，0未删除")
    @TableField("IS_DELE_")
    private String isDele;

    @ApiModelProperty(value = "版本号")
    @TableField("VERSION_")
    private Long version;

    @ApiModelProperty(value = "租户ID")
    @TableField("TENANT_ID_")
    private String tenantId;
}
