package com.artfess.gyl.supplierAccess.model;

import com.artfess.base.entity.AutoFillFullModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableField;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 供应商准入配置表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wubin
 * @since 2025-11-07
 */
@Data
@ApiModel(value="BizSupplierAccessConfiguration对象", description="供应商准入配置表")
public class BizSupplierAccessConfiguration extends AutoFillFullModel<BizSupplierAccessConfiguration> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "配置编码")
    @TableField("CODE_")
    private String code;

    @ApiModelProperty(value = "配置名称")
    @TableField("NAME_")
    private String name;

    @ApiModelProperty(value = "配置描述")
    @TableField("DESC_")
    private String desc;

    @ApiModelProperty(value = "企业ID")
    @TableField("ENTERPRISE_ID_")
    private String enterpriseId;

    @ApiModelProperty(value = "企业编号")
    @TableField("ENTERPRISE_CODE_")
    private String enterpriseCode;

    @TableLogic
    @ApiModelProperty(value = "是否已删，1已删除，0未删除")
    @TableField("IS_DELE_")
    private String isDele;

    @ApiModelProperty(value = "版本号")
    @TableField("VERSION_")
    private Long version;

    @ApiModelProperty(value = "租户ID")
    @TableField("TENANT_ID_")
    private String tenantId;
}
