package com.artfess.gyl.supplierAccess.manager.impl;

import com.artfess.base.exception.ApplicationException;
import com.artfess.base.util.BeanUtils;
import com.artfess.gyl.supplierAccess.dto.BizSupplierReviewConfigurationDto;
import com.artfess.gyl.supplierAccess.manager.BizSupplierReviewConfigurationDetailsManager;
import com.artfess.gyl.supplierAccess.model.BizSupplierAccessBasic;
import com.artfess.gyl.supplierAccess.model.BizSupplierAccessQualification;
import com.artfess.gyl.supplierAccess.model.BizSupplierReviewConfiguration;
import com.artfess.gyl.supplierAccess.dao.BizSupplierReviewConfigurationDao;
import com.artfess.gyl.supplierAccess.manager.BizSupplierReviewConfigurationManager;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.gyl.supplierAccess.model.BizSupplierReviewConfigurationDetails;
import com.artfess.gyl.supplierAccess.vo.BizSupplierAccessConfigurationVo;
import com.artfess.gyl.supplierAccess.vo.BizSupplierReviewConfigurationVo;
import com.artfess.sysConfig.persistence.manager.SysIdentityManager;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 供应商准入评审评分配置表 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wubin
 * @since 2025-11-09
 */
@Service
public class BizSupplierReviewConfigurationManagerImpl extends BaseManagerImpl<BizSupplierReviewConfigurationDao, BizSupplierReviewConfiguration> implements BizSupplierReviewConfigurationManager {

    @Resource
    private BizSupplierReviewConfigurationDetailsManager supplierReviewConfigurationDetailsManager;

    @Resource
    private SysIdentityManager sysIdentityManager;

    @Transactional(rollbackFor = Exception.class)
    @Override
    public Boolean saveModel(BizSupplierReviewConfigurationDto dto) {
        Boolean result = false;
        BizSupplierReviewConfiguration supplierReviewConfiguration = BizSupplierReviewConfigurationDto.parse(dto);
        validateModel(supplierReviewConfiguration);
        String currentOrgId = ContextUtil.getCurrentOrgId();
        String currentOrgCode = ContextUtil.getCurrentOrgCode();
        String code = sysIdentityManager.nextId("gyszrpspfpzbm");
        supplierReviewConfiguration.setIsDele("0");
        supplierReviewConfiguration.setStatus("0");
        supplierReviewConfiguration.setEnterpriseId(currentOrgId);
        supplierReviewConfiguration.setEnterpriseCode(currentOrgCode);
        supplierReviewConfiguration.setCode(code);
        //保存供应商准入评审评分配置主表
        result = save(supplierReviewConfiguration);
        if (!result){
            return false;
        }
        //保存明细
        dto.setEnterpriseId(currentOrgId);
        dto.setEnterpriseCode(currentOrgCode);
        dto.setCode(code);
        String id = supplierReviewConfiguration.getId();
        dto.setId(id);
        saveDetails(dto);
        return true;
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public Boolean batchDelete(String[] ids) {
        //删除明细
        batchDeleteDetail(ids);
        //删除主表
        return this.removeByIds(Arrays.asList(ids));
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public Boolean updateModel(BizSupplierReviewConfigurationDto dto) {
        Boolean result = false;
        BizSupplierReviewConfiguration supplierReviewConfiguration = BizSupplierReviewConfigurationDto.parse(dto);
        validateModel(supplierReviewConfiguration);
        result = updateById(supplierReviewConfiguration);
        if (!result){
            return false;
        }
        //删除旧明细
        String id = dto.getId();
        batchDeleteDetail(new String[]{id});
        //保存新明细
        saveDetails(dto);
        return true;
    }

    @Override
    public BizSupplierReviewConfigurationVo getInfo(String id) {
        BizSupplierReviewConfiguration supplierReviewConfiguration = get(id);
        BizSupplierReviewConfigurationVo vo = new BizSupplierReviewConfigurationVo();
        vo.copy(supplierReviewConfiguration);
        List<BizSupplierReviewConfigurationDetails> detailsList = supplierReviewConfigurationDetailsManager.list(new LambdaQueryWrapper<BizSupplierReviewConfigurationDetails>()
                .eq(BizSupplierReviewConfigurationDetails::getReviewConfigurationId, id)
                .eq(BizSupplierReviewConfigurationDetails::getIsDele, "0"));
        Map<String, List<BizSupplierReviewConfigurationDetails>> detailsMap = detailsList
                .stream()
                .collect(Collectors.groupingBy(BizSupplierReviewConfigurationDetails::getClassificationName));
        vo.setDetailsMap(detailsMap);
        return vo;
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public Boolean updateStatus(String id, String status) {
        int count = baseMapper.updateStatus(id,status);
        return count > 0 ? true : false;
    }

    /**
     * 批量删除明细
     * @param ids
     */
    @Transactional(rollbackFor = Exception.class)
    public void batchDeleteDetail(String[] ids){
        supplierReviewConfigurationDetailsManager.remove(new LambdaQueryWrapper<BizSupplierReviewConfigurationDetails>()
                .in(BizSupplierReviewConfigurationDetails::getReviewConfigurationId,ids)
                .eq(BizSupplierReviewConfigurationDetails::getIsDele,"0"));
    }

    /**
     * 保存明细
     * @param dto
     */
    @Transactional(rollbackFor = Exception.class)
    public void saveDetails(BizSupplierReviewConfigurationDto dto){
        String reviewConfigurationId = dto.getId();
        Map<String, List<BizSupplierReviewConfigurationDetails>> detailsMap = dto.getDetailsMap();
        List<BizSupplierReviewConfigurationDetails> detailsList = new ArrayList<>();
        Set<String> keySet = detailsMap.keySet();
        for (String key : keySet) {
            detailsList.addAll(BeanUtils.isEmpty(detailsMap.get(key)) ? new ArrayList<>() : detailsMap.get(key));
        }
        detailsList.forEach(d -> {
            d.setIsDele("0");
            String code = sysIdentityManager.nextId("gyszrpspfpzzblbbm");
            d.setCode(code);
            d.setReviewConfigurationId(reviewConfigurationId);
            d.setId(null);
        });
        supplierReviewConfigurationDetailsManager.saveBatch(detailsList);
    }

    private void validateModel(BizSupplierReviewConfiguration supplierReviewConfiguration){
        if (BeanUtils.isEmpty(supplierReviewConfiguration)){
            throw new ApplicationException("保存的对象为空！");
        }
    }
}
