package com.artfess.gyl.supplierApply2.model;

import com.artfess.base.entity.AutoFillFullModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 主要原材料及供应商表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wubin
 * @since 2025-11-11
 */
@Data
@ApiModel(value="BizSupplierMainRawMaterialsSuppliers2对象", description="主要原材料及供应商表")
public class BizSupplierMainRawMaterialsSuppliers2 extends AutoFillFullModel<BizSupplierMainRawMaterialsSuppliers2> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "供应商准入ID")
    @TableField("SUPPLIER_ENTERPRISE_ID_")
    private String supplierEnterpriseId;

    @ApiModelProperty(value = "主要原料名称")
    @TableField("MAIN_RAW_MATERIAL_NAME_")
    private String mainRawMaterialName;

    @ApiModelProperty(value = "供应厂家")
    @TableField("SUPPLIER_")
    private String supplier;

    @ApiModelProperty(value = "上年度业绩表现")
    @TableField("PREVIOUS_YEAR_PERFORMANCE_")
    private String previousYearPerformance;

    @ApiModelProperty(value = "是否已删，1已删除，0未删除")
    @TableField("IS_DELE_")
    private String isDele;

    @ApiModelProperty(value = "版本号")
    @TableField("VERSION_")
    private Long version;

    @ApiModelProperty(value = "租户ID")
    @TableField("TENANT_ID_")
    private String tenantId;
}
