package com.artfess.gyl.supplierAccess.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.valid.AddGroup;
import com.artfess.gyl.supplierAccess.dto.BizSupplierAccessConfigurationDto;
import com.artfess.gyl.supplierAccess.vo.BizSupplierAccessConfigurationVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import com.artfess.base.controller.BaseController;
import com.artfess.gyl.supplierAccess.model.BizSupplierAccessConfiguration;
import com.artfess.gyl.supplierAccess.manager.BizSupplierAccessConfigurationManager;

/**
 * 供应商准入配置表 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wubin
 * @since 2025-11-07
 */
@RestController
@RequestMapping("/bizSupplierAccessConfiguration/v1/")
@Api(tags = "供应商准入配置表")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ_GYL})
public class BizSupplierAccessConfigurationController extends BaseController<BizSupplierAccessConfigurationManager, BizSupplierAccessConfiguration> {

    @PostMapping("/saveModel")
    @ApiOperation("保存供应商准入配置")
    public CommonResult<String> saveModel(@ApiParam(name = "model", value = "实体信息") @Validated({AddGroup.class}) @RequestBody BizSupplierAccessConfigurationDto supplierAccessConfigurationDto) {
        Boolean result = baseService.saveModel(supplierAccessConfigurationDto);
        if (!result){
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION,null);
        }
        return CommonResult.success(supplierAccessConfigurationDto,"保存成功");
    }

    @GetMapping("/getInfo/{id}")
    @ApiOperation("供应商准入配置详情")
    public BizSupplierAccessConfigurationVo getInfo(@ApiParam(name = "id", value = "实体id") @PathVariable String id){
        return baseService.getInfo(id);
    }

    @PostMapping("/updateModel")
    @ApiOperation("修改供应商准入配置")
    public CommonResult<String> updateModel(@ApiParam(name = "model", value = "实体信息") @Validated({AddGroup.class}) @RequestBody BizSupplierAccessConfigurationDto supplierAccessConfigurationDto) {
        Boolean result = baseService.updateModel(supplierAccessConfigurationDto);
        if (!result){
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION,null);
        }
        return CommonResult.success(supplierAccessConfigurationDto,"修改成功");
    }

    @Override
    @DeleteMapping("/")
    @ApiOperation("根据id集合批量删除")
    public CommonResult<String> deleteByIds(@ApiParam(name = "ids", value = "实体集合") @RequestParam String... ids) {
        Boolean result = baseService.batchDelete(ids);
        if (!result){
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION,null);
        }
        return new CommonResult<>();
    }

    @PostMapping(value = "/queryPage", produces = {"application/json; charset=utf-8"})
    @ApiOperation("分页查询")
    public PageList<BizSupplierAccessConfigurationVo> queryPage(@ApiParam(name = "queryFilter", value = "分页查询信息") @RequestBody QueryFilter<BizSupplierAccessConfiguration> queryFilter) {
        return baseService.queryPage(queryFilter);
    }
}
