package com.artfess.form.controller;

import com.artfess.base.controller.BaseController;
import com.artfess.form.manager.FormDataTemplateExtendManager;
import com.artfess.form.model.FormDataTemplateExtend;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

@RestController
@RequestMapping("/form/formDataTemplateExtend/v1/")
public class FormDataTemplateExtendController extends BaseController<FormDataTemplateExtendManager, FormDataTemplateExtend> {

    @RequestMapping(value = "getDataTemplateExtendByFormKey", method = RequestMethod.GET, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "根据表单key 获取提醒设置", httpMethod = "GET", notes = "根据表单key 获取提醒设置")
    public List<FormDataTemplateExtend> getDataTemplateExtendByFormKey(@ApiParam(name = "formKey", value = "表单数据") @RequestParam String formKey) {
        return baseService.getDataTemplateExtendByFormKey(formKey);
    }

}
